/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.id;

import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.com.ComException;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.ha.id.IdAllocation;
import org.neo4j.kernel.ha.id.IdRangeIterator;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.id.configuration.CommunityIdTypeConfigurationProvider;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class HaIdGeneratorFactoryTest {
    @Rule
    public final EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();
    private Master master;
    private DelegateInvocationHandler<Master> masterDelegate;
    private EphemeralFileSystemAbstraction fs;
    private HaIdGeneratorFactory fac;

    @Before
    public void before() {
        this.master = (Master)Mockito.mock(Master.class);
        this.masterDelegate = new DelegateInvocationHandler(Master.class);
        this.fs = this.fileSystemRule.get();
        this.fac = new HaIdGeneratorFactory(this.masterDelegate, (LogProvider)NullLogProvider.getInstance(), (RequestContextFactory)Mockito.mock(RequestContextFactory.class), (FileSystemAbstraction)this.fs, (IdTypeConfigurationProvider)new CommunityIdTypeConfigurationProvider());
    }

    @Test
    public void slaveIdGeneratorShouldReturnFromAssignedRange() throws Exception {
        IdAllocation firstResult = new IdAllocation(new IdRange(new long[0], 42L, 123), 123L, 0L);
        Response<IdAllocation> response = this.response(firstResult, new IdAllocation[0]);
        Mockito.when((Object)this.master.allocateIds((RequestContext)Matchers.any(RequestContext.class), (IdType)Matchers.any(IdType.class))).thenReturn(response);
        IdGenerator gen = this.switchToSlave();
        for (long i = firstResult.getIdRange().getRangeStart(); i < (long)firstResult.getIdRange().getRangeLength(); ++i) {
            Assert.assertEquals((long)i, (long)gen.nextId());
        }
        ((Master)Mockito.verify((Object)this.master, (VerificationMode)Mockito.times((int)1))).allocateIds((RequestContext)Matchers.any(RequestContext.class), (IdType)Matchers.eq((Object)IdType.NODE));
    }

    @Test
    public void slaveIdGeneratorShouldAskForMoreWhenRangeIsOver() throws Exception {
        long i;
        IdAllocation firstResult = new IdAllocation(new IdRange(new long[0], 42L, 123), 165L, 0L);
        IdAllocation secondResult = new IdAllocation(new IdRange(new long[0], 1042L, 223), 1265L, 0L);
        Response<IdAllocation> response = this.response(firstResult, secondResult);
        Mockito.when((Object)this.master.allocateIds((RequestContext)Matchers.any(RequestContext.class), (IdType)Matchers.any(IdType.class))).thenReturn(response);
        IdGenerator gen = this.switchToSlave();
        long startAt = firstResult.getIdRange().getRangeStart();
        long forThatMany = firstResult.getIdRange().getRangeLength();
        for (i = startAt; i < startAt + forThatMany; ++i) {
            Assert.assertEquals((long)i, (long)gen.nextId());
        }
        ((Master)Mockito.verify((Object)this.master, (VerificationMode)Mockito.times((int)1))).allocateIds((RequestContext)Matchers.any(RequestContext.class), (IdType)Matchers.eq((Object)IdType.NODE));
        startAt = secondResult.getIdRange().getRangeStart();
        forThatMany = secondResult.getIdRange().getRangeLength();
        for (i = startAt; i < startAt + forThatMany; ++i) {
            Assert.assertEquals((long)i, (long)gen.nextId());
        }
        ((Master)Mockito.verify((Object)this.master, (VerificationMode)Mockito.times((int)2))).allocateIds((RequestContext)Matchers.any(RequestContext.class), (IdType)Matchers.eq((Object)IdType.NODE));
    }

    @Test
    public void shouldUseDefraggedIfPresent() throws Exception {
        long[] defragIds = new long[]{42L, 27172828L, 314159L};
        IdAllocation firstResult = new IdAllocation(new IdRange(defragIds, 0L, 0), 0L, (long)defragIds.length);
        Response<IdAllocation> response = this.response(firstResult, new IdAllocation[0]);
        Mockito.when((Object)this.master.allocateIds((RequestContext)Matchers.any(RequestContext.class), (IdType)Matchers.any(IdType.class))).thenReturn(response);
        IdGenerator gen = this.switchToSlave();
        for (long defragId : defragIds) {
            Assert.assertEquals((long)defragId, (long)gen.nextId());
        }
    }

    @Test
    public void shouldMoveFromDefraggedToRange() throws Exception {
        long[] defragIds = new long[]{42L, 27172828L, 314159L};
        IdAllocation firstResult = new IdAllocation(new IdRange(defragIds, 0L, 10), 100L, (long)defragIds.length);
        Response<IdAllocation> response = this.response(firstResult, new IdAllocation[0]);
        Mockito.when((Object)this.master.allocateIds((RequestContext)Matchers.any(RequestContext.class), (IdType)Matchers.any(IdType.class))).thenReturn(response);
        IdGenerator gen = this.switchToSlave();
        for (long defragId : defragIds) {
            Assert.assertEquals((long)defragId, (long)gen.nextId());
        }
    }

    @Test
    public void slaveShouldNeverAllowReducingHighId() throws Exception {
        int highIdFromAllocation = 123;
        IdAllocation firstResult = new IdAllocation(new IdRange(new long[0], 42L, 123), 123L, 0L);
        Response<IdAllocation> response = this.response(firstResult, new IdAllocation[0]);
        Mockito.when((Object)this.master.allocateIds((RequestContext)Matchers.any(RequestContext.class), (IdType)Matchers.any(IdType.class))).thenReturn(response);
        IdGenerator gen = this.switchToSlave();
        int highIdFromUpdatedRecord = 124;
        gen.setHighId(124L);
        gen.nextId();
        Assert.assertEquals((long)124L, (long)gen.getHighId());
    }

    @Test
    public void shouldDeleteIdGeneratorsAsPartOfSwitchingToSlave() throws Exception {
        this.fac.switchToMaster();
        File idFile = new File("my.id");
        this.fac.create(idFile, 10L, true);
        IdGenerator idGenerator = this.fac.open(idFile, 10, IdType.NODE, 10L, StandardV3_0.RECORD_FORMATS.node().getMaxId());
        Assert.assertTrue((boolean)this.fs.fileExists(idFile));
        idGenerator.close();
        this.fac.switchToSlave();
        Assert.assertFalse((String)"Id file should've been deleted by now", (boolean)this.fs.fileExists(idFile));
    }

    @Test
    public void shouldDeleteIdGeneratorsAsPartOfOpenAfterSwitchingToSlave() throws Exception {
        this.fac.switchToSlave();
        File idFile = new File("my.id");
        this.fac.create(idFile, 10L, true);
        IdGenerator idGenerator = this.fac.open(idFile, 10, IdType.NODE, 10L, StandardV3_0.RECORD_FORMATS.node().getMaxId());
        Assert.assertFalse((String)"Id file should've been deleted by now", (boolean)this.fs.fileExists(idFile));
    }

    @Test(expected=TransientTransactionFailureException.class)
    public void shouldTranslateComExceptionsIntoTransientTransactionFailures() throws Exception {
        Mockito.when((Object)this.master.allocateIds((RequestContext)Matchers.any(RequestContext.class), (IdType)Matchers.any(IdType.class))).thenThrow(new Throwable[]{new ComException()});
        IdGenerator generator = this.switchToSlave();
        generator.nextId();
    }

    @Test
    public void shouldNotUseForbiddenMinusOneIdFromIdBatches() throws Exception {
        long[] defragIds = new long[]{3L, 5L};
        int size = 10;
        long low = 0xFFFFFFFFL - (long)(size / 2);
        IdRange idRange = new IdRange(defragIds, low, size);
        IdRangeIterator iterartor = new IdRangeIterator(idRange);
        for (long id : defragIds) {
            Assert.assertEquals((long)id, (long)iterartor.next());
        }
        int expectedRangeSize = size - 1;
        long i = 0L;
        long expectedId = low;
        while (i < (long)expectedRangeSize) {
            if (expectedId == 0xFFFFFFFFL) {
                ++expectedId;
            }
            long id = iterartor.next();
            Assert.assertNotEquals((long)0xFFFFFFFFL, (long)id);
            Assert.assertEquals((long)expectedId, (long)id);
            ++i;
            ++expectedId;
        }
        Assert.assertEquals((long)-1L, (long)iterartor.next());
    }

    private Response<IdAllocation> response(IdAllocation firstValue, IdAllocation ... additionalValues) {
        Response response = (Response)Mockito.mock(Response.class);
        Mockito.when((Object)response.response()).thenReturn((Object)firstValue, (Object[])additionalValues);
        return response;
    }

    private IdGenerator switchToSlave() {
        this.fac.switchToSlave();
        IdGenerator gen = this.fac.open(new File("someFile"), 10, IdType.NODE, 1L, StandardV3_0.RECORD_FORMATS.node().getMaxId());
        this.masterDelegate.setDelegate((Object)this.master);
        return gen;
    }
}

