/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan;

import java.util.Collections;
import java.util.Iterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public abstract class LabelScanStoreHaIT {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final LifeSupport life = new LifeSupport();
    private ClusterManager.ManagedCluster cluster;
    private final TestMonitor monitor = new TestMonitor();

    @Test
    public void shouldCopyLabelScanStoreToNewSlaves() throws Exception {
        Assert.assertTrue((String)("Expected initial calls to init to be at least one per cluster member (>= 3), but was " + this.monitor.callsTo_init), (this.monitor.callsTo_init >= 3 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Expected none to build their label scan store index.", (long)0L, (long)this.monitor.timesRebuiltWithData);
        for (GraphDatabaseService graphDatabaseService : this.cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
            Assert.assertEquals((long)2L, (long)this.numberOfNodesHavingLabel(graphDatabaseService, Labels.First));
            Assert.assertEquals((long)2L, (long)this.numberOfNodesHavingLabel(graphDatabaseService, Labels.First));
        }
    }

    private long numberOfNodesHavingLabel(GraphDatabaseService db, Label label) {
        try (Transaction tx = db.beginTx();){
            long count = Iterators.count((Iterator)db.findNodes(label));
            tx.success();
            long l = count;
            return l;
        }
    }

    private void createSomeLabeledNodes(GraphDatabaseService db, Label[] ... labelArrays) {
        try (Transaction tx = db.beginTx();){
            for (Label[] labels : labelArrays) {
                db.createNode(labels);
            }
            tx.success();
        }
    }

    @Before
    public void setUp() {
        KernelExtensionFactory<?> testExtension = this.labelScanStoreExtension(this.monitor);
        TestHighlyAvailableGraphDatabaseFactory factory = new TestHighlyAvailableGraphDatabaseFactory();
        factory.addKernelExtensions(Collections.singletonList(testExtension));
        ClusterManager clusterManager = new ClusterManager.Builder(this.testDirectory.directory("root")).withDbFactory(factory).withStoreDirInitializer((serverId, storeDir) -> {
            if (serverId == 1) {
                GraphDatabaseService db = new TestGraphDatabaseFactory().addKernelExtension(testExtension).newEmbeddedDatabaseBuilder(storeDir.getAbsoluteFile()).newGraphDatabase();
                try {
                    this.createSomeLabeledNodes(db, {Labels.First}, {Labels.First, Labels.Second}, {Labels.Second});
                }
                finally {
                    db.shutdown();
                }
            }
        }).build();
        this.life.add((Lifecycle)clusterManager);
        this.life.start();
        this.cluster = clusterManager.getCluster();
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        this.cluster.await(ClusterManager.allAvailabilityGuardsReleased());
    }

    protected abstract KernelExtensionFactory<?> labelScanStoreExtension(LabelScanStore.Monitor var1);

    @After
    public void tearDown() {
        this.life.shutdown();
    }

    private static class TestMonitor
    implements LabelScanStore.Monitor {
        private volatile int callsTo_init;
        private volatile int timesRebuiltWithData;

        private TestMonitor() {
        }

        public void init() {
            ++this.callsTo_init;
        }

        public void noIndex() {
        }

        public void lockedIndex(Exception e) {
        }

        public void notValidIndex() {
        }

        public void rebuilding() {
        }

        public void rebuilt(long roughNodeCount) {
            if (roughNodeCount > 0L) {
                ++this.timesRebuiltWithData;
            }
        }
    }

    private static enum Labels implements Label
    {
        First,
        Second;

    }
}

