/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.schema.IndexDescriptor;
import org.neo4j.kernel.api.schema.NodePropertyDescriptor;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.test.ha.ClusterRule;

public class HaCountsIT {
    private static final Label LABEL = Label.label((String)"label");
    private static final String PROPERTY_NAME = "prop";
    private static final String PROPERTY_VALUE = "value";
    @Rule
    public ClusterRule clusterRule = new ClusterRule(this.getClass());
    private ClusterManager.ManagedCluster cluster;
    private HighlyAvailableGraphDatabase master;
    private HighlyAvailableGraphDatabase slave1;
    private HighlyAvailableGraphDatabase slave2;

    @Before
    public void setup() throws Exception {
        this.cluster = this.clusterRule.startCluster();
        this.master = this.cluster.getMaster();
        this.slave1 = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        this.slave2 = this.cluster.getAnySlave(this.slave1);
        this.clearDatabase();
    }

    private void clearDatabase() throws InterruptedException {
        try (Transaction tx = this.master.beginTx();){
            for (IndexDefinition index : this.master.schema().getIndexes()) {
                index.drop();
            }
            tx.success();
        }
        tx = this.master.beginTx();
        var2_2 = null;
        try {
            for (Node node : this.master.getAllNodes()) {
                for (Relationship relationship : node.getRelationships()) {
                    relationship.delete();
                }
                node.delete();
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
    }

    @Test
    public void shouldUpdateCountsOnSlavesWhenCreatingANodeOnMaster() throws Exception {
        this.createANode(this.master, LABEL, PROPERTY_VALUE, PROPERTY_NAME);
        this.cluster.sync(this.master);
        this.assertOnNodeCounts(1, 1, LABEL, this.master);
        this.assertOnNodeCounts(1, 1, LABEL, this.slave1);
        this.assertOnNodeCounts(1, 1, LABEL, this.slave2);
    }

    @Test
    public void shouldUpdateCountsOnMasterAndSlaveWhenCreatingANodeOnSlave() throws Exception {
        this.createANode(this.slave1, LABEL, PROPERTY_VALUE, PROPERTY_NAME);
        this.cluster.sync(this.slave1);
        this.assertOnNodeCounts(1, 1, LABEL, this.master);
        this.assertOnNodeCounts(1, 1, LABEL, this.slave1);
        this.assertOnNodeCounts(1, 1, LABEL, this.slave2);
    }

    @Test
    public void shouldUpdateCountsOnSlavesWhenCreatingAnIndexOnMaster() throws Exception {
        this.createANode(this.master, LABEL, PROPERTY_VALUE, PROPERTY_NAME);
        IndexDescriptor indexDescriptor = this.createAnIndex(this.master, LABEL, PROPERTY_NAME);
        this.awaitOnline(this.master, indexDescriptor);
        this.cluster.sync(this.master);
        this.awaitOnline(this.slave1, indexDescriptor);
        this.awaitOnline(this.slave2, indexDescriptor);
        this.assertOnIndexCounts(0, 1, 1, 1, indexDescriptor, this.master);
        this.assertOnIndexCounts(0, 1, 1, 1, indexDescriptor, this.slave1);
        this.assertOnIndexCounts(0, 1, 1, 1, indexDescriptor, this.slave2);
    }

    @Test
    public void shouldUpdateCountsOnClusterWhenCreatingANodeOnSlaveAndAnIndexOnMaster() throws Exception {
        this.createANode(this.slave1, LABEL, PROPERTY_VALUE, PROPERTY_NAME);
        IndexDescriptor indexDescriptor = this.createAnIndex(this.master, LABEL, PROPERTY_NAME);
        this.awaitOnline(this.master, indexDescriptor);
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.awaitOnline(this.slave1, indexDescriptor);
        this.awaitOnline(this.slave2, indexDescriptor);
        this.assertOnIndexCounts(0, 1, 1, 1, indexDescriptor, this.master);
        this.assertOnIndexCounts(0, 1, 1, 1, indexDescriptor, this.slave1);
        this.assertOnIndexCounts(0, 1, 1, 1, indexDescriptor, this.slave2);
    }

    private void createANode(HighlyAvailableGraphDatabase db, Label label, String value, String property) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode(new Label[]{label});
            node.setProperty(property, (Object)value);
            tx.success();
        }
    }

    private IndexDescriptor createAnIndex(HighlyAvailableGraphDatabase db, Label label, String propertyName) throws KernelException {
        try (Transaction tx = db.beginTx();){
            Statement statement = this.statement(db);
            int labelId = statement.tokenWriteOperations().labelGetOrCreateForName(label.name());
            int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(propertyName);
            IndexDescriptor index = statement.schemaWriteOperations().indexCreate(new NodePropertyDescriptor(labelId, propertyKeyId));
            tx.success();
            IndexDescriptor indexDescriptor = index;
            return indexDescriptor;
        }
    }

    private void assertOnNodeCounts(int expectedTotalNodes, int expectedLabelledNodes, Label label, HighlyAvailableGraphDatabase db) {
        try (Transaction ignored = db.beginTx();){
            Statement statement = this.statement(db);
            int labelId = statement.readOperations().labelGetForName(label.name());
            Assert.assertEquals((long)expectedTotalNodes, (long)statement.readOperations().countsForNode(-1));
            Assert.assertEquals((long)expectedLabelledNodes, (long)statement.readOperations().countsForNode(labelId));
        }
    }

    private void assertOnIndexCounts(int expectedIndexUpdates, int expectedIndexSize, int expectedUniqueValues, int expectedSampleSize, IndexDescriptor descriptor, HighlyAvailableGraphDatabase db) {
        CountsTracker counts = this.counts(db);
        this.assertDoubleLongEquals(expectedIndexUpdates, expectedIndexSize, counts.indexUpdatesAndSize(descriptor, Registers.newDoubleLongRegister()));
        this.assertDoubleLongEquals(expectedUniqueValues, expectedSampleSize, counts.indexSample(descriptor, Registers.newDoubleLongRegister()));
    }

    private void assertDoubleLongEquals(int expectedFirst, int expectedSecond, Register.DoubleLongRegister actualValues) {
        String msg = String.format("Expected (%d,%d) but was (%d,%d)", expectedFirst, expectedSecond, actualValues.readFirst(), actualValues.readSecond());
        Assert.assertTrue((String)msg, (boolean)actualValues.hasValues((long)expectedFirst, (long)expectedSecond));
    }

    private CountsTracker counts(HighlyAvailableGraphDatabase db) {
        return ((RecordStorageEngine)db.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores().getCounts();
    }

    private Statement statement(HighlyAvailableGraphDatabase db) {
        return ((ThreadToStatementContextBridge)db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).get();
    }

    private IndexDescriptor awaitOnline(HighlyAvailableGraphDatabase db, IndexDescriptor index) throws KernelException {
        long start = System.currentTimeMillis();
        long end = start + 3000L;
        while (System.currentTimeMillis() < end) {
            Transaction tx = db.beginTx();
            Throwable throwable = null;
            try {
                switch (this.statement(db).readOperations().indexGetState(index)) {
                    case ONLINE: {
                        IndexDescriptor indexDescriptor = index;
                        return indexDescriptor;
                    }
                    case FAILED: {
                        throw new IllegalStateException("Index failed instead of becoming ONLINE");
                    }
                }
                tx.success();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            }
        }
        throw new IllegalStateException("Index did not become ONLINE within reasonable time");
    }
}

