/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.ha;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

class ParallelLifecycle
extends LifecycleAdapter {
    private final List<Lifecycle> lifecycles = new ArrayList<Lifecycle>();
    private final long timeout;
    private final TimeUnit unit;

    public ParallelLifecycle(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
    }

    public <T extends Lifecycle> T add(T lifecycle) {
        this.lifecycles.add(lifecycle);
        return lifecycle;
    }

    public void init() throws Throwable {
        this.perform(Lifecycle::init);
    }

    public void start() throws Throwable {
        this.perform(Lifecycle::start);
    }

    public void stop() throws Throwable {
        this.perform(Lifecycle::stop);
    }

    public void shutdown() throws Throwable {
        this.perform(Lifecycle::shutdown);
    }

    private void perform(Action action) throws Exception {
        ExecutorService service = Executors.newFixedThreadPool(this.lifecycles.size());
        ArrayList futures = new ArrayList();
        for (Lifecycle lifecycle : this.lifecycles) {
            service.submit(() -> {
                try {
                    action.act(lifecycle);
                }
                catch (Throwable e) {
                    throw Exceptions.launderedException((Throwable)e);
                }
            });
        }
        service.shutdown();
        if (!service.awaitTermination(this.timeout, this.unit)) {
            for (Future future : futures) {
                future.cancel(true);
            }
        }
        Exception exception = null;
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                exception = (Exception)Exceptions.combine(exception, (Throwable)e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private static interface Action {
        public void act(Lifecycle var1) throws Throwable;
    }
}

