/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexProvider;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.IndexDescriptor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.ha.ClusterRule;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class SchemaIndexHaIT {
    @ClassRule
    public static DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public ClusterRule clusterRule = new ClusterRule(this.getClass());
    private static final Predicate<GraphDatabaseService> IS_MASTER = item -> item instanceof HighlyAvailableGraphDatabase && ((HighlyAvailableGraphDatabase)item).isMaster();
    private final String key = "key";
    private final Label label = Label.label((String)"label");
    private static final SchemaIndexProvider.Descriptor CONTROLLED_PROVIDER_DESCRIPTOR = new SchemaIndexProvider.Descriptor("controlled", "1.0");

    @Test
    public void creatingIndexOnMasterShouldHaveSlavesBuildItAsWell() throws Throwable {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        Map<Object, Node> data = this.createSomeData((GraphDatabaseService)master);
        IndexDefinition index = this.createIndex((GraphDatabaseService)master);
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        SchemaIndexHaIT.awaitIndexOnline(index, cluster, data);
    }

    @Test
    public void creatingIndexOnSlaveIsNotAllowed() throws Throwable {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try {
            this.createIndex((GraphDatabaseService)slave);
            Assert.fail((String)"should have thrown exception");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void indexPopulationJobsShouldContinueThroughRoleSwitch() throws Throwable {
        ControlledGraphDatabaseFactory dbFactory = new ControlledGraphDatabaseFactory();
        ClusterManager.ManagedCluster cluster = this.clusterRule.withDbFactory(dbFactory).startCluster();
        HighlyAvailableGraphDatabase firstMaster = cluster.getMaster();
        Map<Object, Node> data = this.createSomeData((GraphDatabaseService)firstMaster);
        this.createIndex((GraphDatabaseService)firstMaster);
        dbFactory.triggerFinish((GraphDatabaseService)firstMaster);
        HighlyAvailableGraphDatabase aSlave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        ((UpdatePuller)aSlave.getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
        dbFactory.awaitPopulationStarted((GraphDatabaseService)aSlave);
        cluster.shutdown(firstMaster);
        dbFactory.triggerFinish((GraphDatabaseService)aSlave);
        cluster.await(ClusterManager.masterAvailable(firstMaster));
        HighlyAvailableGraphDatabase newMaster = cluster.getMaster();
        Assert.assertEquals((String)"Unexpected new master", (Object)aSlave, (Object)newMaster);
        try (Transaction tx = newMaster.beginTx();){
            IndexDefinition index = (IndexDefinition)Iterables.single((Iterable)newMaster.schema().getIndexes());
            SchemaIndexHaIT.awaitIndexOnline(index, (GraphDatabaseService)newMaster, data);
            tx.success();
        }
        for (HighlyAvailableGraphDatabase db : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
            dbFactory.triggerFinish((GraphDatabaseService)db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void populatingSchemaIndicesOnMasterShouldBeBroughtOnlineOnSlavesAfterStoreCopy() throws Throwable {
        ControlledGraphDatabaseFactory dbFactory = new ControlledGraphDatabaseFactory(IS_MASTER);
        ClusterManager.ManagedCluster cluster = this.clusterRule.withDbFactory(dbFactory).startCluster();
        try {
            IndexDefinition index;
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
            ClusterManager.RepairKit slaveDown = this.bringSlaveOfflineAndRemoveStoreFiles(cluster, slave);
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            Map<Object, Node> data = this.createSomeData((GraphDatabaseService)master);
            this.createIndex((GraphDatabaseService)master);
            dbFactory.awaitPopulationStarted((GraphDatabaseService)master);
            slave = slaveDown.repair();
            cluster.await(ClusterManager.allSeesAllAsAvailable(), 180);
            cluster.sync(new HighlyAvailableGraphDatabase[0]);
            dbFactory.triggerFinish((GraphDatabaseService)master);
            try (Transaction tx = master.beginTx();){
                index = (IndexDefinition)Iterables.single((Iterable)master.schema().getIndexes());
                SchemaIndexHaIT.awaitIndexOnline(index, (GraphDatabaseService)master, data);
                tx.success();
            }
            tx = slave.beginTx();
            var9_8 = null;
            try {
                SchemaIndexHaIT.awaitIndexOnline(index, (GraphDatabaseService)slave, data);
                tx.success();
            }
            catch (Throwable throwable) {
                var9_8 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var9_8 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var9_8.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        finally {
            for (HighlyAvailableGraphDatabase db : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                dbFactory.triggerFinish((GraphDatabaseService)db);
            }
        }
    }

    @Test
    public void onlineSchemaIndicesOnMasterShouldBeBroughtOnlineOnSlavesAfterStoreCopy() throws Throwable {
        IndexDefinition index;
        ControlledGraphDatabaseFactory dbFactory = new ControlledGraphDatabaseFactory();
        ClusterManager.ManagedCluster cluster = this.clusterRule.withDbFactory(dbFactory).startCluster();
        cluster.await(ClusterManager.allSeesAllAsAvailable(), 120);
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        this.proceedAsNormalWithIndexPopulationOnAllSlavesExcept(dbFactory, cluster, slave);
        ClusterManager.RepairKit slaveDown = this.bringSlaveOfflineAndRemoveStoreFiles(cluster, slave);
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        Map<Object, Node> data = this.createSomeData((GraphDatabaseService)master);
        this.createIndex((GraphDatabaseService)master);
        dbFactory.awaitPopulationStarted((GraphDatabaseService)master);
        dbFactory.triggerFinish((GraphDatabaseService)master);
        try (Transaction tx = master.beginTx();){
            index = (IndexDefinition)Iterables.single((Iterable)master.schema().getIndexes());
            SchemaIndexHaIT.awaitIndexOnline(index, (GraphDatabaseService)master, data);
            tx.success();
        }
        slave = slaveDown.repair();
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        dbFactory.triggerFinish((GraphDatabaseService)slave);
        tx = slave.beginTx();
        var9_8 = null;
        try {
            SchemaIndexHaIT.awaitIndexOnline(index, (GraphDatabaseService)slave, data);
            tx.success();
        }
        catch (Throwable throwable) {
            var9_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var9_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var9_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void proceedAsNormalWithIndexPopulationOnAllSlavesExcept(ControlledGraphDatabaseFactory dbFactory, ClusterManager.ManagedCluster cluster, HighlyAvailableGraphDatabase slaveToIgnore) {
        for (HighlyAvailableGraphDatabase db : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
            if (db == slaveToIgnore || db.getInstanceState() != HighAvailabilityMemberState.SLAVE) continue;
            dbFactory.triggerFinish((GraphDatabaseService)db);
        }
    }

    private ClusterManager.RepairKit bringSlaveOfflineAndRemoveStoreFiles(ClusterManager.ManagedCluster cluster, HighlyAvailableGraphDatabase slave) throws IOException {
        ClusterManager.RepairKit slaveDown = cluster.shutdown(slave);
        File storeDir = new File(slave.getStoreDir());
        FileUtils.deleteRecursively((File)storeDir);
        storeDir.mkdir();
        return slaveDown;
    }

    private Map<Object, Node> createSomeData(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            HashMap<Object, Node> result = new HashMap<Object, Node>();
            for (int i = 0; i < 10; ++i) {
                Node node = db.createNode(new Label[]{this.label});
                Integer propertyValue = i;
                node.setProperty("key", (Object)propertyValue);
                result.put(propertyValue, node);
            }
            tx.success();
            HashMap<Object, Node> hashMap = result;
            return hashMap;
        }
    }

    private IndexDefinition createIndex(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            IndexDefinition index = db.schema().indexFor(this.label).on("key").create();
            tx.success();
            IndexDefinition indexDefinition = index;
            return indexDefinition;
        }
    }

    private static void awaitIndexOnline(IndexDefinition index, ClusterManager.ManagedCluster cluster, Map<Object, Node> expectedDdata) throws InterruptedException {
        for (GraphDatabaseService graphDatabaseService : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
            SchemaIndexHaIT.awaitIndexOnline(index, graphDatabaseService, expectedDdata);
        }
    }

    private static IndexDefinition reHomedIndexDefinition(GraphDatabaseService db, IndexDefinition definition) {
        for (IndexDefinition candidate : db.schema().getIndexes()) {
            if (!candidate.equals(definition)) continue;
            return candidate;
        }
        throw new NoSuchElementException("New database doesn't have requested index");
    }

    private static void awaitIndexOnline(IndexDefinition requestedIndex, GraphDatabaseService db, Map<Object, Node> expectedData) throws InterruptedException {
        try (Transaction tx = db.beginTx();){
            IndexDefinition index = SchemaIndexHaIT.reHomedIndexDefinition(db, requestedIndex);
            long timeout = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(120L);
            while (!SchemaIndexHaIT.indexOnline(index, db)) {
                Thread.sleep(1L);
                if (System.currentTimeMillis() <= timeout) continue;
                Assert.fail((String)"Expected index to come online within a reasonable time.");
            }
            SchemaIndexHaIT.assertIndexContents(index, db, expectedData);
            tx.success();
        }
    }

    private static void assertIndexContents(IndexDefinition index, GraphDatabaseService db, Map<Object, Node> expectedData) {
        for (Map.Entry<Object, Node> entry : expectedData.entrySet()) {
            Assert.assertEquals((Object)Iterators.asSet((Object[])new Node[]{entry.getValue()}), (Object)Iterators.asUniqueSet((Iterator)db.findNodes(index.getLabel(), (String)Iterables.single((Iterable)index.getPropertyKeys()), entry.getKey())));
        }
    }

    private static boolean indexOnline(IndexDefinition index, GraphDatabaseService db) {
        try {
            return db.schema().getIndexState(index) == Schema.IndexState.ONLINE;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    private static class ControlledGraphDatabaseFactory
    extends TestHighlyAvailableGraphDatabaseFactory {
        final Map<GraphDatabaseService, SchemaIndexProvider> perDbIndexProvider = new ConcurrentHashMap<GraphDatabaseService, SchemaIndexProvider>();
        private final KernelExtensionFactory<?> factory;

        ControlledGraphDatabaseFactory() {
            this.factory = new ControllingIndexProviderFactory(this.perDbIndexProvider, Predicates.alwaysTrue());
        }

        private ControlledGraphDatabaseFactory(Predicate<GraphDatabaseService> dbsToControlIndexingOn) {
            this.factory = new ControllingIndexProviderFactory(this.perDbIndexProvider, dbsToControlIndexingOn);
        }

        public GraphDatabaseBuilder newEmbeddedDatabaseBuilder(File file) {
            this.getCurrentState().addKernelExtensions(Arrays.asList(this.factory));
            return super.newEmbeddedDatabaseBuilder(file);
        }

        void awaitPopulationStarted(GraphDatabaseService db) {
            ControlledSchemaIndexProvider provider = (ControlledSchemaIndexProvider)this.perDbIndexProvider.get(db);
            if (provider != null) {
                provider.latch.waitForAllToStart();
            }
        }

        void triggerFinish(GraphDatabaseService db) {
            ControlledSchemaIndexProvider provider = (ControlledSchemaIndexProvider)this.perDbIndexProvider.get(db);
            if (provider != null) {
                provider.latch.finish();
            }
        }
    }

    private static class ControllingIndexProviderFactory
    extends KernelExtensionFactory<IndexProviderDependencies> {
        private final Map<GraphDatabaseService, SchemaIndexProvider> perDbIndexProvider;
        private final Predicate<GraphDatabaseService> injectLatchPredicate;

        ControllingIndexProviderFactory(Map<GraphDatabaseService, SchemaIndexProvider> perDbIndexProvider, Predicate<GraphDatabaseService> injectLatchPredicate) {
            super(CONTROLLED_PROVIDER_DESCRIPTOR.getKey());
            this.perDbIndexProvider = perDbIndexProvider;
            this.injectLatchPredicate = injectLatchPredicate;
        }

        public Lifecycle newInstance(KernelContext context, IndexProviderDependencies deps) throws Throwable {
            if (this.injectLatchPredicate.test(deps.db())) {
                ControlledSchemaIndexProvider provider = new ControlledSchemaIndexProvider((SchemaIndexProvider)new LuceneSchemaIndexProvider(fileSystemRule.get(), DirectoryFactory.PERSISTENT, context.storeDir(), (LogProvider)NullLogProvider.getInstance(), deps.config(), context.databaseInfo().operationalMode));
                this.perDbIndexProvider.put(deps.db(), provider);
                return provider;
            }
            return new LuceneSchemaIndexProvider(fileSystemRule.get(), DirectoryFactory.PERSISTENT, context.storeDir(), (LogProvider)NullLogProvider.getInstance(), deps.config(), context.databaseInfo().operationalMode);
        }
    }

    static interface IndexProviderDependencies {
        public GraphDatabaseService db();

        public Config config();
    }

    private static class ControlledSchemaIndexProvider
    extends SchemaIndexProvider {
        private final SchemaIndexProvider delegate;
        private final DoubleLatch latch = new DoubleLatch();

        ControlledSchemaIndexProvider(SchemaIndexProvider delegate) {
            super(CONTROLLED_PROVIDER_DESCRIPTOR, 100);
            this.delegate = delegate;
        }

        public IndexPopulator getPopulator(long indexId, IndexDescriptor descriptor, IndexConfiguration config, IndexSamplingConfig samplingConfig) {
            IndexPopulator populator = this.delegate.getPopulator(indexId, descriptor, config, samplingConfig);
            return new ControlledIndexPopulator(populator, this.latch);
        }

        public IndexAccessor getOnlineAccessor(long indexId, IndexConfiguration config, IndexSamplingConfig samplingConfig) throws IOException {
            return this.delegate.getOnlineAccessor(indexId, config, samplingConfig);
        }

        public InternalIndexState getInitialState(long indexId) {
            return this.delegate.getInitialState(indexId);
        }

        public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache, LabelScanStoreProvider labelScanStoreProvider) {
            return this.delegate.storeMigrationParticipant(fs, pageCache, labelScanStoreProvider);
        }

        public String getPopulationFailure(long indexId) throws IllegalStateException {
            return this.delegate.getPopulationFailure(indexId);
        }
    }

    private static class ControlledIndexPopulator
    implements IndexPopulator {
        private final DoubleLatch latch;
        private final IndexPopulator delegate;

        ControlledIndexPopulator(IndexPopulator delegate, DoubleLatch latch) {
            this.delegate = delegate;
            this.latch = latch;
        }

        public void create() throws IOException {
            this.delegate.create();
        }

        public void drop() throws IOException {
            this.delegate.drop();
        }

        public void add(Collection<IndexEntryUpdate> updates) throws IndexEntryConflictException, IOException {
            this.delegate.add(updates);
            this.latch.startAndWaitForAllToStartAndFinish();
        }

        public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
            this.delegate.verifyDeferredConstraints(propertyAccessor);
        }

        public IndexUpdater newPopulatingUpdater(PropertyAccessor propertyAccessor) throws IOException {
            return this.delegate.newPopulatingUpdater(propertyAccessor);
        }

        public void close(boolean populationCompletedSuccessfully) throws IOException {
            this.delegate.close(populationCompletedSuccessfully);
            Assert.assertTrue((String)"Expected population to succeed :(", (boolean)populationCompletedSuccessfully);
            this.latch.finish();
        }

        public void markAsFailed(String failure) throws IOException {
            this.delegate.markAsFailed(failure);
        }

        public void includeSample(IndexEntryUpdate update) {
            this.delegate.includeSample(update);
        }

        public void configureSampling(boolean onlineSampling) {
            this.delegate.configureSampling(onlineSampling);
        }

        public IndexSample sampleResult() {
            return this.delegate.sampleResult();
        }
    }
}

