/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIn;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.helpers.Strings;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.IdController;
import org.neo4j.test.Race;
import org.neo4j.test.ha.ClusterRule;
import org.parboiled.common.StringUtils;

@RunWith(value=Parameterized.class)
public class TerminationOfSlavesDuringPullUpdatesTest {
    private static final int READER_CONTESTANTS = 20;
    private static final int STRING_LENGTH = 20000;
    private static final int PROPERTY_KEY_CHAIN_LENGTH = 100;
    @Rule
    public ClusterRule clusterRule = ((ClusterRule)new ClusterRule(this.getClass()).withSharedSetting(HaSettings.pull_interval, "0")).withSharedSetting(HaSettings.tx_push_factor, "0");
    @Parameterized.Parameter(value=0)
    public ReadContestantActions action;
    @Parameterized.Parameter(value=1)
    public String name;

    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({new PropertyValueActions(TerminationOfSlavesDuringPullUpdatesTest.longString('a'), TerminationOfSlavesDuringPullUpdatesTest.longString('b'), true), "NodeStringProperty[txTerminationAwareLocks=yes]"}, {new PropertyValueActions(TerminationOfSlavesDuringPullUpdatesTest.longString('a'), TerminationOfSlavesDuringPullUpdatesTest.longString('b'), true), "NodeStringProperty[txTerminationAwareLocks=no]"}, {new PropertyValueActions(TerminationOfSlavesDuringPullUpdatesTest.longString('a'), TerminationOfSlavesDuringPullUpdatesTest.longString('b'), false), "RelationshipStringProperty[txTerminationAwareLocks=yes]"}, {new PropertyValueActions(TerminationOfSlavesDuringPullUpdatesTest.longString('a'), TerminationOfSlavesDuringPullUpdatesTest.longString('b'), false), "RelationshipStringProperty[txTerminationAwareLocks=no]"}, {new PropertyValueActions(TerminationOfSlavesDuringPullUpdatesTest.longArray('a'), TerminationOfSlavesDuringPullUpdatesTest.longArray('b'), true), "NodeArrayProperty[txTerminationAwareLocks=yes]"}, {new PropertyValueActions(TerminationOfSlavesDuringPullUpdatesTest.longArray('a'), TerminationOfSlavesDuringPullUpdatesTest.longArray('b'), true), "NodeArrayProperty[txTerminationAwareLocks=no]"}, {new PropertyValueActions(TerminationOfSlavesDuringPullUpdatesTest.longArray('a'), TerminationOfSlavesDuringPullUpdatesTest.longArray('b'), false), "RelationshipArrayProperty[txTerminationAwareLocks=yes]"}, {new PropertyValueActions(TerminationOfSlavesDuringPullUpdatesTest.longArray('a'), TerminationOfSlavesDuringPullUpdatesTest.longArray('b'), false), "RelationshipArrayProperty[txTerminationAwareLocks=no]"}, {new PropertyKeyActions('a', 'b', true), "NodePropertyKeys[txTerminationAwareLocks=yes]"}, {new PropertyKeyActions('a', 'b', true), "NodePropertyKeys[txTerminationAwareLocks=no]"}, {new PropertyKeyActions('a', 'b', false), "RelationshipPropertyKeys[txTerminationAwareLocks=yes]"}, {new PropertyKeyActions('a', 'b', false), "RelationshipPropertyKeys[txTerminationAwareLocks=no]"});
    }

    @Test
    public void slavesTerminateOrReadConsistentDataWhenApplyingBatchLargerThanSafeZone() throws Throwable {
        long safeZone = TimeUnit.MILLISECONDS.toMillis(0L);
        this.clusterRule.withSharedSetting(HaSettings.id_reuse_safe_zone_time, String.valueOf(safeZone));
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        long entityId = this.action.createInitialEntity(master);
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.action.removeProperties(master, entityId);
        Thread.sleep(100L);
        this.forceMaintenance(master);
        this.action.setNewProperties(master, entityId);
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        Race race = new Race();
        AtomicBoolean end = new AtomicBoolean(false);
        for (int i = 0; i < 20; ++i) {
            race.addContestant(this.readContestant(this.action, entityId, slave, end));
        }
        race.addContestant(this.pullUpdatesContestant(slave, end));
        race.go();
    }

    @Test
    public void slavesDontTerminateAndReadConsistentDataWhenApplyingBatchSmallerThanSafeZone() throws Throwable {
        long safeZone = TimeUnit.MINUTES.toMillis(1L);
        this.clusterRule.withSharedSetting(HaSettings.id_reuse_safe_zone_time, String.valueOf(safeZone));
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        long entityId = this.action.createInitialEntity(master);
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.action.removeProperties(master, entityId);
        this.forceMaintenance(master);
        this.action.setNewProperties(master, entityId);
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        Race race = new Race();
        AtomicBoolean end = new AtomicBoolean(false);
        for (int i = 0; i < 20; ++i) {
            race.addContestant(this.readContestant(this.action, entityId, slave, end));
        }
        race.addContestant(this.pullUpdatesContestant(slave, end));
        race.go();
    }

    private Runnable readContestant(final ReadContestantActions action, final long entityId, final HighlyAvailableGraphDatabase slave, final AtomicBoolean end) {
        return new Runnable(){

            @Override
            public void run() {
                while (!end.get()) {
                    try {
                        Transaction tx = slave.beginTx();
                        Throwable throwable = null;
                        try {
                            for (int i = 0; i < 10; ++i) {
                                action.verifyProperties(slave, entityId);
                            }
                            tx.success();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (tx == null) continue;
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            tx.close();
                        }
                    }
                    catch (TransactionTerminatedException | TransientTransactionFailureException throwable) {}
                }
            }
        };
    }

    private Runnable pullUpdatesContestant(final HighlyAvailableGraphDatabase slave, final AtomicBoolean end) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    Random rnd = new Random();
                    Thread.sleep(rnd.nextInt(100));
                    ((UpdatePuller)slave.getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    end.set(true);
                }
            }
        };
    }

    private static Object longArray(char b) {
        return TerminationOfSlavesDuringPullUpdatesTest.longString(b).toCharArray();
    }

    private static String longString(char ch) {
        return StringUtils.repeat((char)ch, (int)20000);
    }

    private void forceMaintenance(HighlyAvailableGraphDatabase master) {
        ((IdController)master.getDependencyResolver().resolveDependency(IdController.class)).maintenance();
    }

    private static void assertPropertyValue(Object property, Object ... candidates) {
        if (property == null) {
            return;
        }
        for (Object candidate : candidates) {
            if (!Objects.deepEquals(property, candidate)) continue;
            return;
        }
        Assert.fail((String)("property value was " + Strings.prettyPrint((Object)property)));
    }

    private static void assertPropertyChain(Set<String> allProperties, Character ... keyPrefix) {
        boolean first = true;
        Character actualFirst = null;
        for (String key : allProperties) {
            if (first) {
                first = false;
                actualFirst = Character.valueOf(key.charAt(0));
                Assert.assertThat((String)"Other prefix than expected", (Object)actualFirst, (Matcher)IsIn.isIn((Object[])keyPrefix));
            }
            Assert.assertThat((String)("Property key chain is broken " + Arrays.toString(allProperties.toArray())), (Object)Character.valueOf(key.charAt(0)), (Matcher)CoreMatchers.equalTo((Object)actualFirst));
        }
    }

    private static class PropertyKeyActions
    implements ReadContestantActions {
        final char keyPrefixA;
        final char keyPrefixB;
        final boolean node;

        PropertyKeyActions(char keyPrefixA, char keyPrefixB, boolean node) {
            this.keyPrefixA = keyPrefixA;
            this.keyPrefixB = keyPrefixB;
            this.node = node;
        }

        @Override
        public long createInitialEntity(HighlyAvailableGraphDatabase db) {
            try (Transaction tx = db.beginTx();){
                long id = this.node ? this.createInitialNode(db) : this.createInitialRelationship(db);
                tx.success();
                long l = id;
                return l;
            }
        }

        long createInitialNode(HighlyAvailableGraphDatabase db) {
            Node node = db.createNode();
            this.createPropertyChain((PropertyContainer)node, this.keyPrefixA);
            return node.getId();
        }

        long createInitialRelationship(HighlyAvailableGraphDatabase db) {
            Node start = db.createNode();
            Node end = db.createNode();
            Relationship relationship = start.createRelationshipTo(end, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"));
            this.createPropertyChain((PropertyContainer)relationship, this.keyPrefixA);
            return relationship.getId();
        }

        void createPropertyChain(PropertyContainer entity, char prefix) {
            for (int i = 0; i < 100; ++i) {
                entity.setProperty("" + prefix + i, (Object)i);
            }
        }

        @Override
        public void removeProperties(HighlyAvailableGraphDatabase db, long entityId) {
            try (Transaction tx = db.beginTx();){
                PropertyContainer entity = this.getEntity(db, entityId);
                for (String key : entity.getPropertyKeys()) {
                    entity.removeProperty(key);
                }
                tx.success();
            }
        }

        @Override
        public void setNewProperties(HighlyAvailableGraphDatabase db, long entityId) {
            try (Transaction tx = db.beginTx();){
                this.createPropertyChain(this.getEntity(db, entityId), this.keyPrefixB);
                tx.success();
            }
        }

        @Override
        public void verifyProperties(HighlyAvailableGraphDatabase db, long entityId) {
            TerminationOfSlavesDuringPullUpdatesTest.assertPropertyChain(this.getEntity(db, entityId).getAllProperties().keySet(), new Character[]{Character.valueOf(this.keyPrefixA), Character.valueOf(this.keyPrefixB)});
        }

        PropertyContainer getEntity(HighlyAvailableGraphDatabase db, long id) {
            return this.node ? db.getNodeById(id) : db.getRelationshipById(id);
        }
    }

    private static class PropertyValueActions
    implements ReadContestantActions {
        static final String KEY = "key";
        final Object valueA;
        final Object valueB;
        final boolean node;

        PropertyValueActions(Object valueA, Object valueB, boolean node) {
            this.valueA = valueA;
            this.valueB = valueB;
            this.node = node;
        }

        @Override
        public long createInitialEntity(HighlyAvailableGraphDatabase db) {
            try (Transaction tx = db.beginTx();){
                long id = this.node ? this.createInitialNode(db) : this.createInitialRelationship(db);
                tx.success();
                long l = id;
                return l;
            }
        }

        long createInitialNode(HighlyAvailableGraphDatabase db) {
            Node node = db.createNode();
            node.setProperty(KEY, this.valueA);
            return node.getId();
        }

        long createInitialRelationship(HighlyAvailableGraphDatabase db) {
            Node start = db.createNode();
            Node end = db.createNode();
            Relationship relationship = start.createRelationshipTo(end, (RelationshipType)DynamicRelationshipType.withName((String)"KNOWS"));
            relationship.setProperty(KEY, this.valueA);
            return relationship.getId();
        }

        @Override
        public void removeProperties(HighlyAvailableGraphDatabase db, long entityId) {
            try (Transaction tx = db.beginTx();){
                this.getEntity(db, entityId).removeProperty(KEY);
                tx.success();
            }
        }

        @Override
        public void setNewProperties(HighlyAvailableGraphDatabase db, long entityId) {
            try (Transaction tx = db.beginTx();){
                this.getEntity(db, entityId).setProperty(KEY, this.valueB);
                tx.success();
            }
        }

        @Override
        public void verifyProperties(HighlyAvailableGraphDatabase db, long entityId) {
            Object value = this.getEntity(db, entityId).getProperty(KEY, null);
            TerminationOfSlavesDuringPullUpdatesTest.assertPropertyValue(value, new Object[]{this.valueA, this.valueB});
        }

        PropertyContainer getEntity(HighlyAvailableGraphDatabase db, long id) {
            return this.node ? db.getNodeById(id) : db.getRelationshipById(id);
        }
    }

    private static interface ReadContestantActions {
        public long createInitialEntity(HighlyAvailableGraphDatabase var1);

        public void removeProperties(HighlyAvailableGraphDatabase var1, long var2);

        public void setNewProperties(HighlyAvailableGraphDatabase var1, long var2);

        public void verifyProperties(HighlyAvailableGraphDatabase var1, long var2);
    }
}

