/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.modeswitch;

import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.cluster.modeswitch.ComponentSwitcher;

public abstract class AbstractComponentSwitcher<T>
implements ComponentSwitcher {
    private final DelegateInvocationHandler<T> delegate;

    protected AbstractComponentSwitcher(DelegateInvocationHandler<T> delegate) {
        this.delegate = delegate;
    }

    protected abstract T getMasterImpl();

    protected abstract T getSlaveImpl();

    protected T getPendingImpl() {
        return null;
    }

    @Override
    public final void switchToMaster() {
        this.updateDelegate(this.getMasterImpl());
    }

    @Override
    public final void switchToSlave() {
        this.updateDelegate(this.getSlaveImpl());
    }

    @Override
    public final void switchToPending() {
        this.updateDelegate(this.getPendingImpl());
    }

    private void updateDelegate(T newValue) {
        T oldDelegate = this.delegate.setDelegate(newValue);
        this.shutdownOldDelegate(oldDelegate);
        this.startNewDelegate(newValue);
    }

    protected void startNewDelegate(T newValue) {
    }

    protected void shutdownOldDelegate(T oldDelegate) {
    }
}

