/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import java.io.StringWriter;
import java.io.Writer;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.locking.DumpLocksVisitor;
import org.neo4j.kernel.impl.locking.LockType;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.Log;
import org.neo4j.storageengine.api.lock.ResourceType;

public class LocalDeadlockDetectedException
extends DeadlockDetectedException {
    public LocalDeadlockDetectedException(Locks.Client lockClient, Locks lockManager, ResourceType resourceType, long resourceId, LockType type) {
        super(LocalDeadlockDetectedException.constructHelpfulDiagnosticsMessage(lockClient, lockManager, resourceType, resourceId, type));
    }

    private static String constructHelpfulDiagnosticsMessage(Locks.Client client, Locks lockManager, ResourceType resourceType, long resourceId, LockType type) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.append(String.format("%s tried to apply local %s lock on %s(%s) after acquired on master. Currently these locks exist:%n", client, type, resourceType, resourceId));
        lockManager.accept((Locks.Visitor)new DumpLocksVisitor((Log)FormattedLog.withUTCTimeZone().toWriter((Writer)stringWriter)));
        return stringWriter.toString();
    }
}

