/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.member.paxos.MemberIsAvailable;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcastListener;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcastSerializer;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectInputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectOutputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.Payload;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.test.ProcessStreamHandler;
import org.neo4j.test.rule.TestDirectory;

public class HardKillIT {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    private ProcessStreamHandler processHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterSwitchHappensOnKillMinus9() throws Exception {
        Process proc = null;
        HighlyAvailableGraphDatabase dbWithId2 = null;
        HighlyAvailableGraphDatabase dbWithId3 = null;
        HighlyAvailableGraphDatabase oldMaster = null;
        try {
            proc = this.run(1);
            dbWithId2 = HardKillIT.startDb(2, this.path(2));
            dbWithId3 = HardKillIT.startDb(3, this.path(3));
            HardKillIT.waitUntilAllProperlyAvailable(dbWithId2, 1, "master", 2, "slave", 3, "slave");
            HardKillIT.waitUntilAllProperlyAvailable(dbWithId3, 1, "master", 2, "slave", 3, "slave");
            final CountDownLatch newMasterAvailableLatch = new CountDownLatch(1);
            ((ClusterClient)dbWithId2.getDependencyResolver().resolveDependency(ClusterClient.class)).addAtomicBroadcastListener(new AtomicBroadcastListener(){

                public void receive(Payload value) {
                    try {
                        Object event = new AtomicBroadcastSerializer((ObjectInputStreamFactory)new ObjectStreamFactory(), (ObjectOutputStreamFactory)new ObjectStreamFactory()).receive(value);
                        if (event instanceof MemberIsAvailable && "master".equals(((MemberIsAvailable)event).getRole())) {
                            newMasterAvailableLatch.countDown();
                        }
                    }
                    catch (Exception e) {
                        Assert.fail((String)e.toString());
                    }
                }
            });
            proc.destroy();
            proc = null;
            Assert.assertTrue((boolean)newMasterAvailableLatch.await(60L, TimeUnit.SECONDS));
            Assert.assertTrue((boolean)dbWithId2.isMaster());
            Assert.assertTrue((!dbWithId3.isMaster() ? 1 : 0) != 0);
            HardKillIT.waitUntilAllProperlyAvailable(dbWithId2, 1, "UNKNOWN", 2, "master", 3, "slave");
            HardKillIT.waitUntilAllProperlyAvailable(dbWithId3, 1, "UNKNOWN", 2, "master", 3, "slave");
            oldMaster = HardKillIT.startDb(1, this.path(1));
            long oldMasterNode = this.createNamedNode(oldMaster, "Old master");
            Assert.assertEquals((long)oldMasterNode, (long)this.getNamedNode(dbWithId2, "Old master"));
        }
        finally {
            if (proc != null) {
                proc.destroy();
            }
            if (oldMaster != null) {
                oldMaster.shutdown();
            }
            if (dbWithId2 != null) {
                dbWithId2.shutdown();
            }
            if (dbWithId3 != null) {
                dbWithId3.shutdown();
            }
        }
    }

    private long getNamedNode(HighlyAvailableGraphDatabase db, String name) {
        try (Transaction transaction = db.beginTx();){
            for (Node node : db.getAllNodes()) {
                if (!name.equals(node.getProperty("name", null))) continue;
                long l = node.getId();
                return l;
            }
            Assert.fail((String)("Couldn't find named node '" + name + "' at " + db));
            long l = -1L;
            return l;
        }
    }

    private long createNamedNode(HighlyAvailableGraphDatabase db, String name) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            node.setProperty("name", (Object)name);
            tx.success();
            long l = node.getId();
            return l;
        }
    }

    private Process run(int machineId) throws IOException {
        ArrayList<String> allArgs = new ArrayList<String>(Arrays.asList("java", "-cp", System.getProperty("java.class.path"), "-Djava.awt.headless=true", HardKillIT.class.getName()));
        allArgs.add("" + machineId);
        allArgs.add(this.path(machineId).getAbsolutePath());
        Process process = Runtime.getRuntime().exec(allArgs.toArray(new String[allArgs.size()]));
        this.processHandler = new ProcessStreamHandler(process, false);
        this.processHandler.launch();
        return process;
    }

    public static void main(String[] args) throws InterruptedException {
        HighlyAvailableGraphDatabase db = HardKillIT.startDb(Integer.parseInt(args[0]), new File(args[1]));
        HardKillIT.waitUntilAllProperlyAvailable(db, 1, "master", 2, "slave", 3, "slave");
    }

    private static void waitUntilAllProperlyAvailable(HighlyAvailableGraphDatabase db, Object ... expected) throws InterruptedException {
        ClusterMembers members = (ClusterMembers)db.getDependencyResolver().resolveDependency(ClusterMembers.class);
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(60L);
        Map<Integer, String> expectedStates = HardKillIT.toExpectedStatesMap(expected);
        while (System.currentTimeMillis() < endTime && !HardKillIT.allMembersAreAsExpected(members, expectedStates)) {
            Thread.sleep(100L);
        }
        if (!HardKillIT.allMembersAreAsExpected(members, expectedStates)) {
            throw new IllegalStateException("Not all members available, according to " + db);
        }
    }

    private static boolean allMembersAreAsExpected(ClusterMembers members, Map<Integer, String> expectedStates) {
        int count = 0;
        for (ClusterMember member : members.getMembers()) {
            boolean whatExpected;
            int serverId = member.getInstanceId().toIntegerIndex();
            String expectedRole = expectedStates.get(serverId);
            boolean bl = whatExpected = (expectedRole.equals("UNKNOWN") || member.isAlive()) && member.getHARole().equals(expectedRole);
            if (!whatExpected) {
                return false;
            }
            ++count;
        }
        return count == expectedStates.size();
    }

    private static Map<Integer, String> toExpectedStatesMap(Object[] expected) {
        HashMap<Integer, String> expectedStates = new HashMap<Integer, String>();
        int i = 0;
        while (i < expected.length) {
            expectedStates.put((Integer)expected[i++], (String)expected[i++]);
        }
        return expectedStates;
    }

    private static HighlyAvailableGraphDatabase startDb(int serverId, File path) {
        return (HighlyAvailableGraphDatabase)new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(path).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:7102,127.0.0.1:7103").setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + (7101 + serverId)).setConfig(ClusterSettings.server_id, "" + serverId).setConfig(ClusterSettings.heartbeat_timeout, "5s").setConfig(ClusterSettings.default_timeout, "1s").setConfig(HaSettings.ha_server, ":" + (7501 + serverId)).setConfig(HaSettings.tx_push_factor, "0").newGraphDatabase();
    }

    private File path(int i) {
        return new File(this.testDirectory.graphDbDir(), "" + i);
    }
}

