/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.ha;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.FreePorts;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.Cluster;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.client.ClusterClientModule;
import org.neo4j.cluster.com.NetworkReceiver;
import org.neo4j.cluster.com.NetworkSender;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.NotElectableElectionCredentialsProvider;
import org.neo4j.cluster.protocol.heartbeat.Heartbeat;
import org.neo4j.consistency.store.StoreAssertions;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.cluster.member.ObservedClusterMembers;
import org.neo4j.kernel.ha.com.master.Slaves;
import org.neo4j.kernel.impl.ha.ParallelLifecycle;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.Listener;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.storageengine.api.StorageEngine;

public class ClusterManager
extends LifecycleAdapter {
    private static final int CLUSTER_MIN_PORT = 11000;
    private static final int CLUSTER_MAX_PORT = 21000;
    private static final int HA_MIN_PORT = 21001;
    private static final int HA_MAX_PORT = 31001;
    public static final int FIRST_SERVER_ID = 1;
    private static final long DEFAULT_TIMEOUT_SECONDS = 60L;
    public static final Map<String, String> CONFIG_FOR_SINGLE_JVM_CLUSTER = Collections.unmodifiableMap(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), "8m", GraphDatabaseSettings.shutdown_transaction_end_timeout.name(), "1s", new BoltConnector((String)"bolt").type.name(), "BOLT", new BoltConnector((String)"bolt").enabled.name(), "false"}));
    private final String localAddress = ClusterManager.getLocalAddress();
    private final File root;
    private final Map<String, IntFunction<String>> commonConfig;
    private final Function<FreePorts.Session, Cluster> clustersProvider;
    private final HighlyAvailableGraphDatabaseFactory dbFactory;
    private final StoreDirInitializer storeDirInitializer;
    private final Listener<GraphDatabaseService> initialDatasetCreator;
    private final List<Predicate<ManagedCluster>> availabilityChecks;
    private ManagedCluster managedCluster;
    private final boolean consistencyCheck;
    private final int firstInstanceId;
    private LifeSupport life;
    private static final FreePorts PORTS = new FreePorts();

    public static IntFunction<String> constant(String value) {
        return ignored -> value;
    }

    private ClusterManager(Builder builder) {
        this.clustersProvider = builder.provider;
        this.root = builder.root;
        this.commonConfig = this.withDefaults(builder.commonConfig);
        this.dbFactory = builder.factory;
        this.storeDirInitializer = builder.initializer;
        this.initialDatasetCreator = builder.initialDatasetCreator;
        this.availabilityChecks = builder.availabilityChecks;
        this.consistencyCheck = builder.consistencyCheck;
        this.firstInstanceId = builder.firstInstanceId;
    }

    private Map<String, IntFunction<String>> withDefaults(Map<String, IntFunction<String>> commonConfig) {
        HashMap<String, IntFunction<String>> result = new HashMap<String, IntFunction<String>>();
        for (Map.Entry<String, String> conf : CONFIG_FOR_SINGLE_JVM_CLUSTER.entrySet()) {
            result.put(conf.getKey(), ClusterManager.constant(conf.getValue()));
        }
        result.putAll(commonConfig);
        return result;
    }

    private static String getLocalAddress() {
        try {
            return InetAddress.getByName(null).getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Function<FreePorts.Session, Cluster> clusterOfSize(int memberCount) {
        return ClusterManager.clusterOfSize(ClusterManager.getLocalAddress(), memberCount);
    }

    public static Function<FreePorts.Session, Cluster> clusterOfSize(String hostname, int memberCount) {
        return session -> {
            Cluster cluster = new Cluster();
            try {
                for (int i = 0; i < memberCount; ++i) {
                    int port = session.findFreePort(11000, 21000);
                    cluster.getMembers().add(new Cluster.Member(hostname + ":" + port, true));
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)"Failed to find an open port");
            }
            return cluster;
        };
    }

    public static Function<FreePorts.Session, Cluster> clusterWithAdditionalClients(int haMemberCount, int additionalClientCount) {
        return session -> {
            Cluster cluster = new Cluster();
            try {
                int port;
                int i;
                for (i = 0; i < haMemberCount; ++i) {
                    port = session.findFreePort(11000, 21000);
                    cluster.getMembers().add(new Cluster.Member(port, true));
                }
                for (i = 0; i < additionalClientCount; ++i) {
                    port = session.findFreePort(11000, 21000);
                    cluster.getMembers().add(new Cluster.Member(port, false));
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)"Failed to find an open port");
            }
            return cluster;
        };
    }

    public static Function<FreePorts.Session, Cluster> clusterWithAdditionalArbiters(int haMemberCount, int arbiterCount) {
        return session -> {
            Cluster cluster = new Cluster();
            try {
                int port;
                int i;
                for (i = 0; i < arbiterCount; ++i) {
                    port = session.findFreePort(11000, 21000);
                    cluster.getMembers().add(new Cluster.Member(port, false));
                }
                for (i = 0; i < haMemberCount; ++i) {
                    port = session.findFreePort(11000, 21000);
                    cluster.getMembers().add(new Cluster.Member(port, true));
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)"Failed to find an open port");
            }
            return cluster;
        };
    }

    public static Predicate<ManagedCluster> masterSeesSlavesAsAvailable(final int count) {
        return new Predicate<ManagedCluster>(){

            @Override
            public boolean test(ManagedCluster cluster) {
                return Iterables.count((Iterable)((Slaves)cluster.getMaster().getDependencyResolver().resolveDependency(Slaves.class)).getSlaves()) >= (long)count;
            }

            public String toString() {
                return "Master should see " + count + " slaves as available";
            }
        };
    }

    public static Predicate<ManagedCluster> masterSeesAllSlavesAsAvailable() {
        return new Predicate<ManagedCluster>(){

            @Override
            public boolean test(ManagedCluster cluster) {
                return Iterables.count((Iterable)((Slaves)cluster.getMaster().getDependencyResolver().resolveDependency(Slaves.class)).getSlaves()) >= (long)(cluster.size() - 1);
            }

            public String toString() {
                return "Master should see all slaves as available";
            }
        };
    }

    public static Predicate<ManagedCluster> masterAvailable(HighlyAvailableGraphDatabase ... except) {
        final List<HighlyAvailableGraphDatabase> excludedNodes = Arrays.asList(except);
        return new Predicate<ManagedCluster>(){

            @Override
            public boolean test(ManagedCluster cluster) {
                Predicate<HighlyAvailableGraphDatabase> filterMasterPredicate = node -> !excludedNodes.contains(node) && node.isAvailable(0L) && node.isMaster();
                return Iterables.filter(filterMasterPredicate, cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])).iterator().hasNext();
            }

            public String toString() {
                return "There's an available master";
            }
        };
    }

    public static Predicate<ManagedCluster> masterSeesMembers(final int count) {
        return new Predicate<ManagedCluster>(){

            @Override
            public boolean test(ManagedCluster cluster) {
                ClusterMembers members = (ClusterMembers)cluster.getMaster().getDependencyResolver().resolveDependency(ClusterMembers.class);
                return Iterables.count((Iterable)members.getMembers()) == (long)count;
            }

            public String toString() {
                return "Master should see " + count + " members";
            }
        };
    }

    public static Predicate<ManagedCluster> allSeesAllAsAvailable() {
        return new Predicate<ManagedCluster>(){

            @Override
            public boolean test(ManagedCluster cluster) {
                if (!ClusterManager.allSeesAllAsJoined().test(cluster)) {
                    return false;
                }
                int clusterMembersChecked = 0;
                for (HighlyAvailableGraphDatabase database : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                    ++clusterMembersChecked;
                    ClusterMembers members = (ClusterMembers)database.getDependencyResolver().resolveDependency(ClusterMembers.class);
                    for (ClusterMember clusterMember : members.getMembers()) {
                        if (cluster.isAvailable(clusterMember)) continue;
                        return false;
                    }
                }
                if (clusterMembersChecked == 0) {
                    return false;
                }
                for (HighlyAvailableGraphDatabase database : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                    Log log = ((LogService)database.getDependencyResolver().resolveDependency(LogService.class)).getInternalLog(this.getClass());
                    log.debug(this.toString());
                }
                return true;
            }

            public String toString() {
                return "All instances should see all others as available";
            }
        };
    }

    public static Predicate<ManagedCluster> allSeesAllAsJoined() {
        return new Predicate<ManagedCluster>(){

            @Override
            public boolean test(ManagedCluster cluster) {
                int clusterSize = cluster.size();
                int clusterMembersChecked = 0;
                for (HighlyAvailableGraphDatabase database : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                    ++clusterMembersChecked;
                    ClusterMembers members = (ClusterMembers)database.getDependencyResolver().resolveDependency(ClusterMembers.class);
                    if (Iterables.count((Iterable)members.getMembers()) >= (long)clusterSize) continue;
                    return false;
                }
                for (ObservedClusterMembers arbiter : cluster.getArbiters()) {
                    ++clusterMembersChecked;
                    if (Iterables.count((Iterable)arbiter.getMembers()) >= (long)clusterSize) continue;
                    return false;
                }
                return clusterMembersChecked > 0;
            }

            public String toString() {
                return "All instances should see all others as joined";
            }
        };
    }

    public static Predicate<ManagedCluster> allAvailabilityGuardsReleased() {
        return item -> {
            int clusterMembersChecked = 0;
            for (HighlyAvailableGraphDatabase member : item.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                ++clusterMembersChecked;
                try {
                    member.beginTx().close();
                }
                catch (TransactionFailureException e) {
                    return false;
                }
                ++clusterMembersChecked;
            }
            return clusterMembersChecked > 0;
        };
    }

    public static Predicate<ManagedCluster> instanceEvicted(final HighlyAvailableGraphDatabase instance) {
        return new Predicate<ManagedCluster>(){

            @Override
            public boolean test(ManagedCluster managedCluster) {
                InstanceId instanceId = managedCluster.getServerId(instance);
                Iterable<HighlyAvailableGraphDatabase> members = managedCluster.getAllMembers(new HighlyAvailableGraphDatabase[0]);
                for (HighlyAvailableGraphDatabase member : members) {
                    if (!instanceId.equals((Object)managedCluster.getServerId(member)) || !member.role().equals("UNKNOWN")) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<ManagedCluster> memberSeesOtherMemberAsFailed(HighlyAvailableGraphDatabase observer, HighlyAvailableGraphDatabase observed) {
        return cluster -> {
            InstanceId observedServerId = (InstanceId)((Config)observed.getDependencyResolver().resolveDependency(Config.class)).get(ClusterSettings.server_id);
            for (ClusterMember member : ((ClusterMembers)observer.getDependencyResolver().resolveDependency(ClusterMembers.class)).getMembers()) {
                if (!member.getInstanceId().equals((Object)observedServerId)) continue;
                return !member.isAlive();
            }
            throw new IllegalStateException(observed + " not a member according to " + observer);
        };
    }

    public static Predicate<ManagedCluster> entireClusterSeesMemberAsNotAvailable(HighlyAvailableGraphDatabase observed) {
        return cluster -> {
            InstanceId observedServerId = (InstanceId)((Config)observed.getDependencyResolver().resolveDependency(Config.class)).get(ClusterSettings.server_id);
            int clusterMembersChecked = 0;
            for (HighlyAvailableGraphDatabase observer : cluster.getAllMembers(observed)) {
                ++clusterMembersChecked;
                for (ClusterMember member : ((ClusterMembers)observer.getDependencyResolver().resolveDependency(ClusterMembers.class)).getMembers()) {
                    if (!member.getInstanceId().equals((Object)observedServerId) || !cluster.isAvailable(member)) continue;
                    return false;
                }
            }
            return clusterMembersChecked > 0;
        };
    }

    public static Predicate<ManagedCluster> memberThinksItIsRole(HighlyAvailableGraphDatabase member, String role) {
        return cluster -> role.equals(member.role());
    }

    public static String stateToString(ManagedCluster cluster) {
        StringBuilder buf = new StringBuilder("\n");
        for (HighlyAvailableGraphDatabase database : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
            ClusterClient client = (ClusterClient)database.getDependencyResolver().resolveDependency(ClusterClient.class);
            buf.append("Instance ").append(client.getServerId()).append(":State ").append(database.getInstanceState()).append(" (").append(client.getClusterServer()).append("):").append("\n");
            ClusterMembers members = (ClusterMembers)database.getDependencyResolver().resolveDependency(ClusterMembers.class);
            buf.append(members);
        }
        return buf.toString();
    }

    public void start() throws Throwable {
        final FreePorts.Session session = PORTS.newSession();
        Cluster cluster = this.clustersProvider.apply(session);
        this.life = new LifeSupport();
        this.life.add((Lifecycle)new LifecycleAdapter(){

            public void shutdown() throws Throwable {
                session.close();
            }
        });
        this.life.start();
        this.managedCluster = new ManagedCluster(cluster, session);
        this.life.add((Lifecycle)this.managedCluster);
        this.availabilityChecks.forEach(this.managedCluster::await);
        if (this.initialDatasetCreator != null) {
            this.initialDatasetCreator.receive((Object)this.managedCluster.getMaster());
            this.managedCluster.sync(new HighlyAvailableGraphDatabase[0]);
        }
    }

    public void stop() throws Throwable {
        this.life.stop();
    }

    public void shutdown() throws Throwable {
        this.life.shutdown();
    }

    public void safeShutdown() {
        try {
            this.shutdown();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public ManagedCluster getCluster() {
        return this.managedCluster;
    }

    private class StartDatabaseAgainKit
    implements RepairKit {
        private final InstanceId serverId;
        private final ManagedCluster cluster;

        StartDatabaseAgainKit(ManagedCluster cluster, InstanceId serverId) {
            this.cluster = cluster;
            this.serverId = serverId;
        }

        @Override
        public HighlyAvailableGraphDatabase repair() throws Throwable {
            return this.cluster.startMemberNow(this.serverId);
        }
    }

    private class StartNetworkAgainKit
    implements RepairKit {
        private final HighlyAvailableGraphDatabase db;
        private final NetworkReceiver networkReceiver;
        private final NetworkSender networkSender;
        private final NetworkFlag[] flags;

        StartNetworkAgainKit(HighlyAvailableGraphDatabase db, NetworkReceiver networkReceiver, NetworkSender networkSender, NetworkFlag ... flags) {
            this.db = db;
            this.networkReceiver = networkReceiver;
            this.networkSender = networkSender;
            this.flags = flags;
        }

        @Override
        public HighlyAvailableGraphDatabase repair() throws Throwable {
            if (ArrayUtil.contains((Object[])this.flags, (Object)((Object)NetworkFlag.OUT))) {
                this.networkSender.setPaused(false);
            }
            if (ArrayUtil.contains((Object[])this.flags, (Object)((Object)NetworkFlag.IN))) {
                this.networkReceiver.setPaused(false);
            }
            return this.db;
        }
    }

    public class ManagedCluster
    extends LifecycleAdapter {
        private final Cluster spec;
        private final String name;
        private final Map<InstanceId, HighlyAvailableGraphDatabase> members = new ConcurrentHashMap<InstanceId, HighlyAvailableGraphDatabase>();
        private final List<ObservedClusterMembers> arbiters = new ArrayList<ObservedClusterMembers>();
        private final Set<RepairKit> pendingRepairs = Collections.synchronizedSet(new HashSet());
        private final ParallelLifecycle parallelLife = new ParallelLifecycle(60L, TimeUnit.SECONDS);
        private final String initialHosts;
        private final File parent;
        private final FreePorts.Session ports;

        ManagedCluster(Cluster spec, FreePorts.Session ports) throws URISyntaxException {
            this.spec = spec;
            this.ports = ports;
            this.name = spec.getName();
            this.initialHosts = this.buildInitialHosts();
            this.parent = new File(ClusterManager.this.root, this.name);
            for (int i = 0; i < spec.getMembers().size(); ++i) {
                this.startMember(new InstanceId(ClusterManager.this.firstInstanceId + i));
            }
        }

        public String getInitialHostsConfigString() {
            StringBuilder result = new StringBuilder();
            for (HighlyAvailableGraphDatabase member : this.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                result.append(result.length() > 0 ? "," : "").append(ClusterManager.this.localAddress).append(":").append(((ClusterClient)member.getDependencyResolver().resolveDependency(ClusterClient.class)).getClusterServer().getPort());
            }
            return result.toString();
        }

        public void init() throws Throwable {
            this.parallelLife.init();
        }

        public void start() throws Throwable {
            this.parallelLife.start();
        }

        public void stop() throws Throwable {
            List dbs = Iterables.asList(this.getAllMembers(new HighlyAvailableGraphDatabase[0]));
            this.parallelLife.stop();
            for (HighlyAvailableGraphDatabase db : dbs) {
                if (!ClusterManager.this.consistencyCheck) continue;
                this.consistencyCheck(db.getStoreDirectory());
            }
        }

        public void shutdown() throws Throwable {
            this.parallelLife.shutdown();
        }

        private void consistencyCheck(File storeDir) throws Throwable {
            StoreAssertions.assertConsistentStore((File)storeDir);
        }

        public Iterable<HighlyAvailableGraphDatabase> getAllMembers(HighlyAvailableGraphDatabase ... except) {
            HashSet<HighlyAvailableGraphDatabase> exceptSet = new HashSet<HighlyAvailableGraphDatabase>(Arrays.asList(except));
            return this.members.values().stream().filter(db -> !exceptSet.contains(db)).collect(Collectors.toList());
        }

        public Iterable<ObservedClusterMembers> getArbiters() {
            return this.arbiters;
        }

        public boolean isArbiter(ClusterMember clusterMember) {
            for (ObservedClusterMembers arbiter : this.arbiters) {
                if (!arbiter.getCurrentMember().getInstanceId().equals((Object)clusterMember.getInstanceId())) continue;
                return true;
            }
            return false;
        }

        public boolean isAvailable(ClusterMember clusterMember) {
            if (this.isArbiter(clusterMember)) {
                return clusterMember.isAlive();
            }
            return clusterMember.isAlive() && !clusterMember.getHARole().equals("UNKNOWN");
        }

        public HighlyAvailableGraphDatabase getMaster() {
            for (HighlyAvailableGraphDatabase graphDatabaseService : this.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                if (!graphDatabaseService.isAvailable(0L) || !graphDatabaseService.isMaster()) continue;
                return graphDatabaseService;
            }
            throw new IllegalStateException("No master found in cluster " + this.name + ClusterManager.stateToString(this));
        }

        public HighlyAvailableGraphDatabase getAnySlave(HighlyAvailableGraphDatabase ... except) {
            HashSet<HighlyAvailableGraphDatabase> exceptSet = new HashSet<HighlyAvailableGraphDatabase>(Arrays.asList(except));
            for (HighlyAvailableGraphDatabase graphDatabaseService : this.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                if (graphDatabaseService.getInstanceState() != HighAvailabilityMemberState.SLAVE || exceptSet.contains(graphDatabaseService)) continue;
                return graphDatabaseService;
            }
            throw new IllegalStateException("No slave found in cluster " + this.name + ClusterManager.stateToString(this));
        }

        public HighlyAvailableGraphDatabase getMemberByServerId(InstanceId serverId) {
            HighlyAvailableGraphDatabase db = this.members.get(serverId);
            if (db == null) {
                throw new IllegalStateException("Db " + serverId + " not found at the moment in " + this.name + ClusterManager.stateToString(this));
            }
            return db;
        }

        public RepairKit shutdown(HighlyAvailableGraphDatabase db) {
            this.assertMember(db);
            InstanceId serverId = (InstanceId)((Config)db.getDependencyResolver().resolveDependency(Config.class)).get(ClusterSettings.server_id);
            this.shutdownMember(serverId);
            this.await(ClusterManager.entireClusterSeesMemberAsNotAvailable(db));
            return this.wrap(new StartDatabaseAgainKit(this, serverId));
        }

        private void shutdownMember(InstanceId serverId) {
            HighlyAvailableGraphDatabase db = this.members.remove(serverId);
            Config config = (Config)db.getDependencyResolver().resolveDependency(Config.class);
            int haPort = ((HostnamePort)config.get(HaSettings.ha_server)).getPort();
            db.shutdown();
            this.ports.releasePort(haPort);
        }

        private void assertMember(HighlyAvailableGraphDatabase db) {
            for (HighlyAvailableGraphDatabase existingMember : this.members.values()) {
                if (!existingMember.equals(db)) continue;
                return;
            }
            throw new IllegalArgumentException("Db " + db + " not a member of this cluster " + this.name + ClusterManager.stateToString(this));
        }

        public RepairKit fail(HighlyAvailableGraphDatabase db) throws Throwable {
            return this.fail(db, NetworkFlag.values());
        }

        public RepairKit fail(HighlyAvailableGraphDatabase db, NetworkFlag ... flags) throws Throwable {
            return this.fail(db, true, flags);
        }

        public RepairKit fail(HighlyAvailableGraphDatabase db, boolean waitUntilDown, NetworkFlag ... flags) throws Throwable {
            this.assertMember(db);
            NetworkReceiver networkReceiver = (NetworkReceiver)db.getDependencyResolver().resolveDependency(NetworkReceiver.class);
            NetworkSender networkSender = (NetworkSender)db.getDependencyResolver().resolveDependency(NetworkSender.class);
            if (ArrayUtil.contains((Object[])flags, (Object)((Object)NetworkFlag.IN))) {
                networkReceiver.setPaused(true);
            }
            if (ArrayUtil.contains((Object[])flags, (Object)((Object)NetworkFlag.OUT))) {
                networkSender.setPaused(true);
            }
            if (waitUntilDown) {
                this.await(ClusterManager.entireClusterSeesMemberAsNotAvailable(db));
            }
            return this.wrap(new StartNetworkAgainKit(db, networkReceiver, networkSender, flags));
        }

        private RepairKit wrap(RepairKit actual) {
            this.pendingRepairs.add(actual);
            return () -> {
                try {
                    HighlyAvailableGraphDatabase highlyAvailableGraphDatabase = actual.repair();
                    return highlyAvailableGraphDatabase;
                }
                finally {
                    this.pendingRepairs.remove(actual);
                }
            };
        }

        private HighlyAvailableGraphDatabase startMemberNow(InstanceId serverId) throws IOException, URISyntaxException {
            Cluster.Member member = this.memberSpec(serverId);
            URI clusterUri = this.clusterUri(member);
            int clusterPort = clusterUri.getPort();
            int haPort = this.ports.findFreePort(21001, 31001);
            File storeDir = new File(this.parent, "server" + serverId);
            if (ClusterManager.this.storeDirInitializer != null) {
                ClusterManager.this.storeDirInitializer.initializeStoreDir(serverId.toIntegerIndex(), storeDir);
            }
            GraphDatabaseBuilder builder = ClusterManager.this.dbFactory.newEmbeddedDatabaseBuilder(storeDir.getAbsoluteFile());
            builder.setConfig(ClusterSettings.cluster_name, this.name);
            builder.setConfig(ClusterSettings.initial_hosts, this.initialHosts);
            builder.setConfig(ClusterSettings.server_id, serverId + "");
            builder.setConfig(ClusterSettings.cluster_server, "0.0.0.0:" + clusterPort);
            builder.setConfig(HaSettings.ha_server, clusterUri.getHost() + ":" + haPort);
            builder.setConfig(OnlineBackupSettings.online_backup_enabled, "false");
            for (Map.Entry conf : ClusterManager.this.commonConfig.entrySet()) {
                builder.setConfig((String)conf.getKey(), (String)((IntFunction)conf.getValue()).apply(serverId.toIntegerIndex()));
            }
            HighlyAvailableGraphDatabase graphDatabase = (HighlyAvailableGraphDatabase)builder.newGraphDatabase();
            this.members.put(serverId, graphDatabase);
            return graphDatabase;
        }

        private URI clusterUri(Cluster.Member member) throws URISyntaxException {
            return new URI("cluster://" + member.getHost());
        }

        private Cluster.Member memberSpec(InstanceId serverId) {
            return (Cluster.Member)this.spec.getMembers().get(serverId.toIntegerIndex() - ClusterManager.this.firstInstanceId);
        }

        private void startMember(final InstanceId serverId) throws URISyntaxException {
            Cluster.Member member = this.memberSpec(serverId);
            if (member.isFullHaMember()) {
                this.parallelLife.add(new LifecycleAdapter(){

                    public void start() throws Throwable {
                        ManagedCluster.this.startMemberNow(serverId);
                    }

                    public void stop() throws Throwable {
                        HighlyAvailableGraphDatabase db = (HighlyAvailableGraphDatabase)ManagedCluster.this.members.remove(serverId);
                        if (db != null) {
                            db.shutdown();
                        }
                    }
                });
            } else {
                URI clusterUri = this.clusterUri(member);
                Config config = Config.embeddedDefaults((Map)MapUtil.stringMap((String[])new String[]{ClusterSettings.cluster_name.name(), this.name, ClusterSettings.initial_hosts.name(), this.initialHosts, ClusterSettings.server_id.name(), serverId + "", ClusterSettings.cluster_server.name(), "0.0.0.0:" + clusterUri.getPort()}));
                LifeSupport clusterClientLife = new LifeSupport();
                NullLogService logService = NullLogService.getInstance();
                ClusterClientModule clusterClientModule = new ClusterClientModule(clusterClientLife, new Dependencies(), new Monitors(), config, (LogService)logService, (ElectionCredentialsProvider)new NotElectableElectionCredentialsProvider());
                this.arbiters.add(new ObservedClusterMembers(logService.getInternalLogProvider(), (org.neo4j.cluster.protocol.cluster.Cluster)clusterClientModule.clusterClient, (Heartbeat)clusterClientModule.clusterClient, new ClusterMemberEvents(){

                    public void addClusterMemberListener(ClusterMemberListener listener) {
                    }

                    public void removeClusterMemberListener(ClusterMemberListener listener) {
                    }
                }, clusterClientModule.clusterClient.getServerId()));
                this.parallelLife.add(clusterClientLife);
            }
        }

        private String buildInitialHosts() throws URISyntaxException {
            StringBuilder initialHosts = new StringBuilder();
            for (int i = 0; i < this.spec.getMembers().size(); ++i) {
                URI uri;
                if (i > 0) {
                    initialHosts.append(",");
                }
                if ((uri = new URI("cluster://" + ((Cluster.Member)this.spec.getMembers().get(i)).getHost())).getHost() == null || uri.getHost().isEmpty() || uri.getHost().equals("0.0.0.0")) {
                    initialHosts.append(ClusterManager.this.localAddress).append(":").append(uri.getPort());
                    continue;
                }
                initialHosts.append(uri.getHost()).append(":").append(uri.getPort());
            }
            return initialHosts.toString();
        }

        public void await(Predicate<ManagedCluster> predicate) {
            this.await(predicate, 60);
        }

        public void await(Predicate<ManagedCluster> predicate, int maxSeconds) {
            long end = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(maxSeconds);
            while (System.currentTimeMillis() < end) {
                if (predicate.test(this)) {
                    return;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            String state = ClusterManager.stateToString(this);
            throw new IllegalStateException(String.format("Awaited condition never met, waited %s seconds for %s:%n%s", maxSeconds, predicate, state));
        }

        public int size() {
            return this.spec.getMembers().size();
        }

        public InstanceId getServerId(HighlyAvailableGraphDatabase member) {
            this.assertMember(member);
            return (InstanceId)((Config)member.getDependencyResolver().resolveDependency(Config.class)).get(ClusterSettings.server_id);
        }

        public File getStoreDir(HighlyAvailableGraphDatabase member) {
            this.assertMember(member);
            return member.getStoreDirectory();
        }

        public void sync(HighlyAvailableGraphDatabase ... except) {
            HashSet<HighlyAvailableGraphDatabase> exceptSet = new HashSet<HighlyAvailableGraphDatabase>(Arrays.asList(except));
            for (HighlyAvailableGraphDatabase db : this.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                if (exceptSet.contains(db)) continue;
                UpdatePuller updatePuller = (UpdatePuller)db.getDependencyResolver().resolveDependency(UpdatePuller.class);
                try {
                    if (!db.isAvailable(60000L)) continue;
                    updatePuller.pullUpdates();
                }
                catch (Exception e) {
                    throw new IllegalStateException(ClusterManager.stateToString(this), e);
                }
            }
        }

        public void force(HighlyAvailableGraphDatabase ... except) {
            HashSet<HighlyAvailableGraphDatabase> exceptSet = new HashSet<HighlyAvailableGraphDatabase>(Arrays.asList(except));
            for (HighlyAvailableGraphDatabase db : this.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                if (exceptSet.contains(db)) continue;
                IOLimiter limiter = IOLimiter.unlimited();
                ((StorageEngine)db.getDependencyResolver().resolveDependency(StorageEngine.class)).flushAndForce(limiter);
            }
        }

        public void info(String message) {
            for (HighlyAvailableGraphDatabase db : this.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                LogService logService = (LogService)db.getDependencyResolver().resolveDependency(LogService.class);
                Log messagesLog = logService.getInternalLog(HighlyAvailableGraphDatabase.class);
                messagesLog.info(message);
            }
        }

        public void applyOnAll(Function<GraphDatabaseService, Void> function) {
            for (HighlyAvailableGraphDatabase db : this.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                function.apply((GraphDatabaseService)db);
            }
        }

        public void repairAll() throws Throwable {
            for (RepairKit repair : this.pendingRepairs) {
                repair.repair();
            }
            this.pendingRepairs.clear();
        }
    }

    public static class Builder
    implements ClusterBuilder<Builder> {
        private File root;
        private Function<FreePorts.Session, Cluster> provider = ClusterManager.clusterOfSize(3);
        private final Map<String, IntFunction<String>> commonConfig = new HashMap<String, IntFunction<String>>();
        private HighlyAvailableGraphDatabaseFactory factory = new HighlyAvailableGraphDatabaseFactory();
        private StoreDirInitializer initializer;
        private Listener<GraphDatabaseService> initialDatasetCreator;
        private List<Predicate<ManagedCluster>> availabilityChecks = Collections.emptyList();
        private boolean consistencyCheck;
        private int firstInstanceId = 1;

        public Builder(File root) {
            this();
            this.root = root;
        }

        public Builder() {
            this.commonConfig.put(ClusterSettings.heartbeat_interval.name(), ClusterManager.constant("500ms"));
            this.commonConfig.put(ClusterSettings.heartbeat_timeout.name(), ClusterManager.constant("2s"));
            this.commonConfig.put(ClusterSettings.leave_timeout.name(), ClusterManager.constant("5s"));
            this.commonConfig.put(GraphDatabaseSettings.pagecache_memory.name(), ClusterManager.constant("8m"));
        }

        @Override
        public Builder withRootDirectory(File root) {
            this.root = root;
            return this;
        }

        @Override
        public Builder withSeedDir(File seedDir) {
            return this.withStoreDirInitializer((serverId, storeDir) -> FileUtils.copyRecursively((File)seedDir, (File)storeDir));
        }

        @Override
        public Builder withStoreDirInitializer(StoreDirInitializer initializer) {
            this.initializer = initializer;
            return this;
        }

        @Override
        public Builder withDbFactory(HighlyAvailableGraphDatabaseFactory dbFactory) {
            this.factory = dbFactory;
            return this;
        }

        @Override
        public Builder withCluster(Function<FreePorts.Session, Cluster> provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public Builder withInstanceConfig(Map<String, IntFunction<String>> commonConfig) {
            this.commonConfig.putAll(commonConfig);
            return this;
        }

        @Override
        public Builder withInstanceSetting(Setting<?> setting, IntFunction<String> valueFunction) {
            this.commonConfig.put(setting.name(), valueFunction);
            return this;
        }

        @Override
        public Builder withSharedConfig(Map<String, String> commonConfig) {
            HashMap<String, IntFunction<String>> dynamic = new HashMap<String, IntFunction<String>>();
            for (Map.Entry<String, String> entry : commonConfig.entrySet()) {
                dynamic.put(entry.getKey(), ClusterManager.constant(entry.getValue()));
            }
            return this.withInstanceConfig(dynamic);
        }

        @Override
        public Builder withSharedSetting(Setting<?> setting, String value) {
            return this.withInstanceSetting((Setting)setting, (IntFunction)ClusterManager.constant(value));
        }

        @Override
        public Builder withInitialDataset(Listener<GraphDatabaseService> transactor) {
            this.initialDatasetCreator = transactor;
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder withAvailabilityChecks(Predicate<ManagedCluster> ... checks) {
            this.availabilityChecks = Arrays.asList(checks);
            return this;
        }

        @Override
        public Builder withConsistencyCheckAfterwards() {
            this.consistencyCheck = true;
            return this;
        }

        @Override
        public Builder withFirstInstanceId(int firstInstanceId) {
            this.firstInstanceId = firstInstanceId;
            return this;
        }

        public ClusterManager build() {
            if (this.provider == null) {
                this.provider = ClusterManager.clusterOfSize(3);
            }
            return new ClusterManager(this);
        }
    }

    public static interface ClusterBuilder<SELF> {
        public SELF withRootDirectory(File var1);

        public SELF withSeedDir(File var1);

        public SELF withStoreDirInitializer(StoreDirInitializer var1);

        public SELF withDbFactory(HighlyAvailableGraphDatabaseFactory var1);

        public SELF withCluster(Function<FreePorts.Session, Cluster> var1);

        public SELF withInstanceConfig(Map<String, IntFunction<String>> var1);

        public SELF withInstanceSetting(Setting<?> var1, IntFunction<String> var2);

        public SELF withSharedConfig(Map<String, String> var1);

        public SELF withSharedSetting(Setting<?> var1, String var2);

        public SELF withInitialDataset(Listener<GraphDatabaseService> var1);

        public SELF withAvailabilityChecks(Predicate<ManagedCluster> ... var1);

        public SELF withConsistencyCheckAfterwards();

        public SELF withFirstInstanceId(int var1);
    }

    public static interface RepairKit {
        public HighlyAvailableGraphDatabase repair() throws Throwable;
    }

    public static interface StoreDirInitializer {
        public void initializeStoreDir(int var1, File var2) throws IOException;
    }

    public static enum NetworkFlag {
        OUT,
        IN;

    }
}

