/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.time.Duration;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.configuration.Migrator;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.ha.BranchedDataPolicy;
import org.neo4j.kernel.ha.EnterpriseConfigurationMigrator;

@Description(value="High Availability configuration settings")
public class HaSettings
implements LoadableConfig {
    @Migrator
    public static final ConfigurationMigrator migrator = new EnterpriseConfigurationMigrator();
    @Description(value="How long a slave will wait for response from master before giving up.")
    public static final Setting<Duration> read_timeout = Settings.setting((String)"ha.slave_read_timeout", (Function)Settings.DURATION, (String)"20s");
    @Description(value="Timeout for request threads waiting for instance to become master or slave.")
    public static final Setting<Duration> state_switch_timeout = Settings.setting((String)"ha.role_switch_timeout", (Function)Settings.DURATION, (String)"120s");
    @Description(value="Timeout for waiting for internal conditions during state switch, like for transactions to complete, before switching to master or slave.")
    public static final Setting<Duration> internal_state_switch_timeout = Settings.setting((String)"ha.internal_role_switch_timeout", (Function)Settings.DURATION, (String)"10s");
    @Description(value="Timeout for taking remote (write) locks on slaves. Defaults to ha.slave_read_timeout.")
    public static final Setting<Duration> lock_read_timeout = Settings.setting((String)"ha.slave_lock_timeout", (Function)Settings.DURATION, read_timeout);
    @Description(value="Maximum number of connections a slave can have to the master.")
    public static final Setting<Integer> max_concurrent_channels_per_slave = Settings.setting((String)"ha.max_channels_per_slave", (Function)Settings.INTEGER, (String)"20", (BiFunction[])new BiFunction[]{Settings.min((Comparable)Integer.valueOf(1))});
    @Description(value="Hostname and port to bind the HA server.")
    public static final Setting<HostnamePort> ha_server = Settings.setting((String)"ha.host.data", (Function)Settings.HOSTNAME_PORT, (String)"0.0.0.0:6001-6011");
    @Description(value="Whether this instance should only participate as slave in cluster. If set to `true`, it will never be elected as master.")
    public static final Setting<Boolean> slave_only = Settings.setting((String)"ha.slave_only", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="Policy for how to handle branched data.")
    public static final Setting<BranchedDataPolicy> branched_data_policy = Settings.setting((String)"ha.branched_data_policy", (Function)Settings.options(BranchedDataPolicy.class), (String)"keep_all");
    @Description(value="Require authorization for access to the HA status endpoints.")
    public static final Setting<Boolean> ha_status_auth_enabled = Settings.setting((String)"dbms.security.ha_status_auth_enabled", (Function)Settings.BOOLEAN, (String)"true");
    @Description(value="Max size of the data chunks that flows between master and slaves in HA. Bigger size may increase throughput, but may also be more sensitive to variations in bandwidth, whereas lower size increases tolerance for bandwidth variations.")
    public static final Setting<Long> com_chunk_size = Settings.setting((String)"ha.data_chunk_size", (Function)Settings.BYTES, (String)"2M", (BiFunction[])new BiFunction[]{Settings.min((Comparable)Long.valueOf(1024L))});
    @Description(value="Interval of pulling updates from master.")
    public static final Setting<Duration> pull_interval = Settings.setting((String)"ha.pull_interval", (Function)Settings.DURATION, (String)"0s");
    @Description(value="The amount of slaves the master will ask to replicate a committed transaction. ")
    public static final Setting<Integer> tx_push_factor = Settings.setting((String)"ha.tx_push_factor", (Function)Settings.INTEGER, (String)"1", (BiFunction[])new BiFunction[]{Settings.min((Comparable)Integer.valueOf(0))});
    @Description(value="Push strategy of a transaction to a slave during commit.")
    public static final Setting<TxPushStrategy> tx_push_strategy = Settings.setting((String)"ha.tx_push_strategy", (Function)Settings.options(TxPushStrategy.class), (String)TxPushStrategy.fixed_ascending.name());
    @Description(value="Strategy for how to order handling of branched data on slaves and copying of the store from the master. The default is copy_then_branch, which, when combined with the keep_last or keep_none branch handling strategies results in a safer branching strategy, as there is always a store present so store failure to copy a store (for example, because of network failure) does not leave the instance without a store.")
    public static final Setting<BranchedDataCopyingStrategy> branched_data_copying_strategy = Settings.setting((String)"ha.branched_data_copying_strategy", (Function)Settings.options(BranchedDataCopyingStrategy.class), (String)BranchedDataCopyingStrategy.branch_then_copy.name());
    @Description(value="Size of batches of transactions applied on slaves when pulling from master")
    public static final Setting<Integer> pull_apply_batch_size = Settings.setting((String)"ha.pull_batch_size", (Function)Settings.INTEGER, (String)"100");
    @Description(value="Duration for which master will buffer ids and not reuse them to allow slaves read consistently. Slaves will also terminate transactions longer than this duration, when applying received transaction stream, to make sure they do not read potentially inconsistent/reused records.")
    @Internal
    public static final Setting<Duration> id_reuse_safe_zone_time = Settings.setting((String)"unsupported.dbms.id_reuse_safe_zone", (Function)Settings.DURATION, (String)"1h");

    public static enum TxPushStrategy {
        round_robin,
        fixed_descending,
        fixed_ascending;

    }

    public static enum BranchedDataCopyingStrategy {
        branch_then_copy,
        copy_then_branch;

    }
}

