/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.transaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.neo4j.com.Response;
import org.neo4j.kernel.ha.com.master.Slave;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class CommitPusher
extends LifecycleAdapter {
    private static final int PULL_UPDATES_QUEUE_SIZE = 100;
    private final Map<Integer, BlockingQueue<PullUpdateFuture>> pullUpdateQueues = new HashMap<Integer, BlockingQueue<PullUpdateFuture>>();
    private final JobScheduler scheduler;

    public CommitPusher(JobScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void queuePush(Slave slave, long txId) {
        PullUpdateFuture pullRequest = new PullUpdateFuture(slave, txId);
        BlockingQueue<PullUpdateFuture> queue = this.getOrCreateQueue(slave);
        while (!queue.offer(pullRequest)) {
            Thread.yield();
        }
        try {
            pullRequest.get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private synchronized BlockingQueue<PullUpdateFuture> getOrCreateQueue(Slave slave) {
        BlockingQueue<PullUpdateFuture> queue = this.pullUpdateQueues.get(slave.getServerId());
        if (queue == null) {
            queue = new ArrayBlockingQueue<PullUpdateFuture>(100);
            this.pullUpdateQueues.put(slave.getServerId(), queue);
            final BlockingQueue<PullUpdateFuture> finalQueue = queue;
            this.scheduler.schedule(JobScheduler.Groups.masterTransactionPushing, new Runnable(){
                List<PullUpdateFuture> currentPulls = new ArrayList<PullUpdateFuture>();

                /*
                 * Unable to fully structure code
                 */
                @Override
                public void run() {
                    try {
                        block4: while (true) lbl-1000:
                        // 3 sources

                        {
                            this.currentPulls.clear();
                            this.currentPulls.add((PullUpdateFuture)finalQueue.take());
                            finalQueue.drainTo(this.currentPulls);
                            try {
                                pullUpdateFuture = this.currentPulls.get(0);
                                CommitPusher.access$000(CommitPusher.this, pullUpdateFuture);
                                var2_4 = this.currentPulls.iterator();
                                while (true) {
                                    if (!var2_4.hasNext()) ** GOTO lbl-1000
                                    currentPull = var2_4.next();
                                    currentPull.done();
                                }
                            }
                            catch (Exception e) {
                                var2_4 = this.currentPulls.iterator();
                                while (true) {
                                    if (!var2_4.hasNext()) continue block4;
                                    currentPull = var2_4.next();
                                    currentPull.setException(e);
                                }
                            }
                            break;
                        }
                    }
                    catch (InterruptedException var1_3) {
                        return;
                    }
                }
            });
        }
        return queue;
    }

    private void askSlaveToPullUpdates(PullUpdateFuture pullUpdateFuture) {
        Slave slave = pullUpdateFuture.getSlave();
        long lastTxId = pullUpdateFuture.getTxId();
        Response<Void> ignored = slave.pullUpdates(lastTxId);
        Throwable throwable = null;
        if (ignored != null) {
            if (throwable != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ignored.close();
            }
        }
    }

    static /* synthetic */ void access$000(CommitPusher x0, PullUpdateFuture x1) {
        x0.askSlaveToPullUpdates(x1);
    }

    private static class PullUpdateFuture
    extends FutureTask<Object> {
        private final Slave slave;
        private final long txId;

        PullUpdateFuture(Slave slave, long txId) {
            super(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return null;
                }
            });
            this.slave = slave;
            this.txId = txId;
        }

        @Override
        public void done() {
            super.set(null);
            super.done();
        }

        @Override
        public void setException(Throwable t) {
            super.setException(t);
        }

        public Slave getSlave() {
            return this.slave;
        }

        private long getTxId() {
            return this.txId;
        }
    }
}

