/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.net.ConnectException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.test.rule.TestDirectory;

public class HaIPv6ConfigurationTest {
    @Rule
    public TestDirectory dir = TestDirectory.testDirectory();

    @Test
    public void testClusterWithLocalhostAddresses() throws Throwable {
        GraphDatabaseService db = new HighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.dir.makeGraphDbDir()).setConfig(ClusterSettings.cluster_server, this.ipv6HostPortSetting("::1", 5000)).setConfig(ClusterSettings.initial_hosts, this.ipv6HostPortSetting("::1", 5000)).setConfig(HaSettings.ha_server, this.ipv6HostPortSetting("::1", 6000)).setConfig(ClusterSettings.server_id, "1").newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        db.shutdown();
    }

    @Test
    public void testClusterWithLinkLocalAddress() throws Throwable {
        Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
        while (nics.hasMoreElements()) {
            NetworkInterface nic = nics.nextElement();
            Enumeration<InetAddress> inetAddresses = nic.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (!(inetAddress instanceof Inet6Address) || !inetAddress.isLinkLocalAddress()) continue;
                try {
                    if (!inetAddress.isReachable(1000)) continue;
                    this.testWithAddress(inetAddress);
                }
                catch (ConnectException connectException) {}
            }
        }
    }

    private void testWithAddress(InetAddress inetAddress) throws Exception {
        GraphDatabaseService db = new HighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.dir.makeGraphDbDir()).setConfig(ClusterSettings.cluster_server, this.ipv6HostPortSetting(inetAddress.getHostAddress(), 5000)).setConfig(ClusterSettings.initial_hosts, this.ipv6HostPortSetting(inetAddress.getHostAddress(), 5000)).setConfig(HaSettings.ha_server, this.ipv6HostPortSetting("::", 6000)).setConfig(ClusterSettings.server_id, "1").newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        db.shutdown();
    }

    @Test
    public void testClusterWithWildcardAddresses() throws Throwable {
        GraphDatabaseService db = new HighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.dir.makeGraphDbDir()).setConfig(ClusterSettings.cluster_server, this.ipv6HostPortSetting("::", 5000)).setConfig(ClusterSettings.initial_hosts, this.ipv6HostPortSetting("::1", 5000)).setConfig(HaSettings.ha_server, this.ipv6HostPortSetting("::", 6000)).setConfig(ClusterSettings.server_id, "1").newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        db.shutdown();
    }

    private String ipv6HostPortSetting(String address, int port) {
        return "[" + address + "]:" + port;
    }
}

