/*
 * Decompiled with CFR 0.152.
 */
package jmx;

import java.net.URI;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.jmx.Kernel;
import org.neo4j.jmx.impl.JmxKernelExtension;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.management.BranchedStore;
import org.neo4j.management.ClusterMemberInfo;
import org.neo4j.management.HighAvailability;
import org.neo4j.management.Neo4jManager;
import org.neo4j.test.ha.ClusterRule;

public class HaBeanIT {
    @Rule
    public final ClusterRule clusterRule = ((ClusterRule)((ClusterRule)new ClusterRule(HaBeanIT.class).withInstanceSetting((Setting)Settings.setting((String)"jmx.port", (Function)Settings.STRING, (String)null), (IntFunction)ClusterRule.intBase(9912))).withInstanceSetting(HaSettings.ha_server, (IntFunction)ClusterRule.stringWithIntBase(":", 1136))).withInstanceSetting(GraphDatabaseSettings.forced_kernel_id, (IntFunction)ClusterRule.stringWithIntBase("kernel", 0));

    @Test
    public void shouldAccessHaBeans() throws Throwable {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighAvailability ha = this.ha(cluster.getMaster());
        Assert.assertNotNull((String)"could not get ha bean", (Object)ha);
        this.assertMasterInformation(ha);
        this.assertMasterAndSlaveInformation(ha.getInstancesInCluster());
        for (ClusterMemberInfo info : ha.getInstancesInCluster()) {
            Assert.assertTrue((boolean)info.isAlive());
            Assert.assertTrue((boolean)info.isAvailable());
        }
        BranchedStore bs = this.beans(cluster.getMaster()).getBranchedStoreBean();
        Assert.assertNotNull((String)"could not get branched store bean", (Object)bs);
    }

    private void assertMasterInformation(HighAvailability ha) {
        Assert.assertTrue((String)"should be available", (boolean)ha.isAvailable());
        Assert.assertEquals((String)"should be master", (Object)"master", (Object)ha.getRole());
    }

    private Neo4jManager beans(HighlyAvailableGraphDatabase db) {
        return new Neo4jManager((Kernel)((JmxKernelExtension)db.getDependencyResolver().resolveDependency(JmxKernelExtension.class)).getSingleManagementBean(Kernel.class));
    }

    private HighAvailability ha(HighlyAvailableGraphDatabase db) {
        return this.beans(db).getHighAvailabilityBean();
    }

    private static URI getUriForScheme(String scheme, Iterable<URI> uris) {
        return (URI)Iterables.firstOrNull((Iterable)Iterables.filter(item -> item.getScheme().equals(scheme), uris));
    }

    private void assertMasterAndSlaveInformation(ClusterMemberInfo[] instancesInCluster) throws Exception {
        ClusterMemberInfo master = this.member(instancesInCluster, 1);
        Assert.assertEquals((long)1137L, (long)HaBeanIT.getUriForScheme("ha", Iterables.map(URI::create, Arrays.asList(master.getUris()))).getPort());
        Assert.assertEquals((Object)"master", (Object)master.getHaRole());
        ClusterMemberInfo slave = this.member(instancesInCluster, 2);
        Assert.assertEquals((long)1138L, (long)HaBeanIT.getUriForScheme("ha", Iterables.map(URI::create, Arrays.asList(slave.getUris()))).getPort());
        Assert.assertEquals((Object)"slave", (Object)slave.getHaRole());
        Assert.assertTrue((String)"Slave not available", (boolean)slave.isAvailable());
    }

    private ClusterMemberInfo member(ClusterMemberInfo[] members, int instanceId) {
        for (ClusterMemberInfo member : members) {
            if (!member.getInstanceId().equals(Integer.toString(instanceId))) continue;
            return member;
        }
        Assert.fail((String)("Couldn't find cluster member with cluster URI port " + instanceId + " among " + Arrays.toString(members)));
        return null;
    }
}

