/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.backup.OnlineBackupCommandIT;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.ha.ClusterRule;
import org.neo4j.test.rule.SuppressOutput;

public class BackupHaIT {
    @Rule
    public ClusterRule clusterRule = ((ClusterRule)new ClusterRule(this.getClass()).withSharedSetting(OnlineBackupSettings.online_backup_enabled, "true")).withInstanceSetting(OnlineBackupSettings.online_backup_server, serverId -> ":" + (4444 + serverId));
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    private File backupPath;

    @Before
    public void setup() throws Exception {
        this.backupPath = this.clusterRule.cleanDirectory("backup-db");
        OnlineBackupCommandIT.createSomeData((GraphDatabaseService)this.clusterRule.startCluster().getMaster());
    }

    @Test
    public void makeSureBackupCanBePerformed() throws Throwable {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        DbRepresentation beforeChange = DbRepresentation.of((GraphDatabaseService)cluster.getMaster());
        Assert.assertEquals((long)0L, (long)OnlineBackupCommandIT.runBackupToolFromOtherJvmToGetExitCode((File)this.backupPath, (String[])this.backupArguments("localhost:4445", this.backupPath, "basic")));
        DbRepresentation afterChange = OnlineBackupCommandIT.createSomeData((GraphDatabaseService)cluster.getMaster());
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        DbRepresentation backupRepresentation = DbRepresentation.of((File)new File(this.backupPath, "basic"));
        Assert.assertEquals((Object)beforeChange, (Object)backupRepresentation);
        Assert.assertNotEquals((Object)backupRepresentation, (Object)afterChange);
    }

    @Test
    public void makeSureBackupCanBePerformedFromAnyInstance() throws Throwable {
        Integer[] backupPorts;
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        for (Integer port : backupPorts = new Integer[]{4445, 4446, 4447}) {
            DbRepresentation beforeChange = DbRepresentation.of((GraphDatabaseService)cluster.getMaster());
            Assert.assertEquals((long)0L, (long)OnlineBackupCommandIT.runBackupToolFromOtherJvmToGetExitCode((File)this.backupPath, (String[])this.backupArguments("localhost:" + port, this.backupPath, "anyinstance")));
            DbRepresentation afterChange = OnlineBackupCommandIT.createSomeData((GraphDatabaseService)cluster.getMaster());
            cluster.sync(new HighlyAvailableGraphDatabase[0]);
            DbRepresentation backupRepresentation = DbRepresentation.of((File)new File(this.backupPath, "anyinstance"));
            Assert.assertEquals((Object)beforeChange, (Object)backupRepresentation);
            Assert.assertNotEquals((Object)backupRepresentation, (Object)afterChange);
        }
    }

    private String[] backupArguments(String from, File backupDir, String name) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--from=" + from);
        args.add("--cc-report-dir=" + backupDir);
        args.add("--backup-dir=" + backupDir);
        args.add("--name=" + name);
        return args.toArray(new String[args.size()]);
    }
}

