/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.ha.TestRunConditions;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.rule.LoggerRule;
import org.neo4j.test.rule.TestDirectory;

@RunWith(value=Parameterized.class)
public class ClusterFailoverIT {
    @Rule
    public LoggerRule logger = new LoggerRule();
    @Rule
    public TestDirectory dir = TestDirectory.testDirectory();
    private int clusterSize;

    @Parameterized.Parameters(name="clusterSize:{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({3}, {4}, {5}, {6}, {7});
    }

    public ClusterFailoverIT(int clusterSize) {
        this.clusterSize = clusterSize;
    }

    private void testFailOver(int clusterSize) throws Throwable {
        ClusterManager clusterManager = ((ClusterManager.Builder)new ClusterManager.Builder().withRootDirectory(this.dir.cleanDirectory("failover")).withCluster((Function)ClusterManager.clusterOfSize(clusterSize))).build();
        clusterManager.start();
        ClusterManager.ManagedCluster cluster = clusterManager.getCluster();
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        HighlyAvailableGraphDatabase oldMaster = cluster.getMaster();
        long start = System.nanoTime();
        ClusterManager.RepairKit repairKit = cluster.fail(oldMaster);
        this.logger.getLogger().warning("Shut down master");
        cluster.await(ClusterManager.masterAvailable(oldMaster));
        long end = System.nanoTime();
        this.logger.getLogger().warning("Failover took:" + (end - start) / 1000000L + "ms");
        repairKit.repair();
        Thread.sleep(3000L);
        clusterManager.safeShutdown();
    }

    @Test
    public void testFailOver() throws Throwable {
        Assume.assumeTrue((boolean)TestRunConditions.shouldRunAtClusterSize(this.clusterSize));
        this.testFailOver(this.clusterSize);
    }
}

