/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.ha.TransactionChecksumLookup;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;

public class TransactionChecksumLookupTest {
    private TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
    private LogicalTransactionStore transactionStore = (LogicalTransactionStore)Mockito.mock(LogicalTransactionStore.class);

    @Before
    public void setUp() throws IOException {
        Mockito.when((Object)this.transactionIdStore.getLastCommittedTransaction()).thenReturn((Object)new TransactionId(1L, 1L, 1L));
        Mockito.when((Object)this.transactionIdStore.getUpgradeTransaction()).thenReturn((Object)new TransactionId(2L, 2L, 2L));
        Mockito.when((Object)this.transactionStore.getMetadataFor(3L)).thenReturn((Object)new TransactionMetadataCache.TransactionMetadata(1, 1, (LogPosition)Mockito.mock(LogPosition.class), 3L, 3L));
    }

    @Test
    public void lookupChecksumUsingUpgradeTransaction() throws Exception {
        TransactionChecksumLookup checksumLookup = new TransactionChecksumLookup(this.transactionIdStore, this.transactionStore);
        Assert.assertEquals((long)2L, (long)checksumLookup.applyAsLong(2L));
    }

    @Test
    public void lookupChecksumUsingCommittedTransaction() throws Exception {
        TransactionChecksumLookup checksumLookup = new TransactionChecksumLookup(this.transactionIdStore, this.transactionStore);
        Assert.assertEquals((long)1L, (long)checksumLookup.applyAsLong(1L));
    }

    @Test
    public void lookupChecksumUsingTransactionStore() throws Exception {
        TransactionChecksumLookup checksumLookup = new TransactionChecksumLookup(this.transactionIdStore, this.transactionStore);
        Assert.assertEquals((long)3L, (long)checksumLookup.applyAsLong(3L));
    }
}

