/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.com.master.MasterImpl;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.ha.ClusterRule;

public class WhenToInitializeTransactionOnMasterFromSlaveIT {
    @Rule
    public ClusterRule clusterRule = new ClusterRule(this.getClass());
    private GraphDatabaseService slave;
    private ClusterManager.ManagedCluster cluster;
    private MasterImpl.Monitor masterMonitor = (MasterImpl.Monitor)Mockito.mock(MasterImpl.Monitor.class);

    @Before
    public void setUp() throws Exception {
        this.cluster = this.clusterRule.startCluster();
        this.slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try (Transaction tx = this.slave.beginTx();){
            Node node = this.slave.createNode(new Label[]{Label.label((String)"Person")});
            node.setProperty("name", (Object)"Bob");
            node.createRelationshipTo(this.slave.createNode(), RelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        ((Monitors)this.cluster.getMaster().getDependencyResolver().resolveDependency(Monitors.class)).addMonitorListener((Object)this.masterMonitor, new String[0]);
    }

    @Test
    public void shouldNotInitializeTxOnReadOnlyOpsOnNeoXaDS() throws Exception {
        long nodeId = 0L;
        try (Transaction transaction = this.slave.beginTx();){
            Node node = this.slave.getNodeById(nodeId);
            this.assertDidntStartMasterTx();
            Iterables.count((Iterable)node.getLabels());
            this.assertDidntStartMasterTx();
            this.readAllRels(node);
            this.assertDidntStartMasterTx();
            this.readEachProperty((PropertyContainer)node);
            this.assertDidntStartMasterTx();
            transaction.success();
        }
        this.assertDidntStartMasterTx();
    }

    private void assertDidntStartMasterTx() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.masterMonitor});
    }

    private void readAllRels(Node node) {
        for (Relationship relationship : node.getRelationships()) {
            this.readEachProperty((PropertyContainer)relationship);
        }
    }

    private void readEachProperty(PropertyContainer entity) {
        for (String k : entity.getPropertyKeys()) {
            entity.getProperty(k);
        }
    }
}

