/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.cluster.SwitchToMaster;
import org.neo4j.kernel.ha.com.master.MasterServer;

public class SwitchToMasterTest {
    @Test
    public void switchToMasterShouldUseConfigSettingIfSuitable() throws Exception {
        Config config = Config.embeddedDefaults((Map)MapUtil.stringMap((String[])new String[]{ClusterSettings.server_id.name(), "1", HaSettings.ha_server.name(), "192.168.1.99:6001"}));
        URI me = new URI("ha://127.0.0.1");
        MasterServer masterServer = (MasterServer)Mockito.mock(MasterServer.class);
        Mockito.when((Object)masterServer.getSocketAddress()).thenReturn((Object)new InetSocketAddress("192.168.1.1", 6001));
        URI result = SwitchToMaster.getMasterUri((URI)me, (MasterServer)masterServer, (Config)config);
        Assert.assertEquals((String)"Wrong address", (Object)"ha://192.168.1.99:6001?serverId=1", (Object)result.toString());
    }

    @Test
    public void switchToMasterShouldIgnoreWildcardInConfig() throws Exception {
        Config config = Config.embeddedDefaults((Map)MapUtil.stringMap((String[])new String[]{ClusterSettings.server_id.name(), "1", HaSettings.ha_server.name(), "0.0.0.0:6001"}));
        URI me = new URI("ha://127.0.0.1");
        MasterServer masterServer = (MasterServer)Mockito.mock(MasterServer.class);
        Mockito.when((Object)masterServer.getSocketAddress()).thenReturn((Object)new InetSocketAddress("192.168.1.1", 6001));
        URI result = SwitchToMaster.getMasterUri((URI)me, (MasterServer)masterServer, (Config)config);
        Assert.assertEquals((String)"Wrong address", (Object)"ha://192.168.1.1:6001?serverId=1", (Object)result.toString());
        Mockito.when((Object)masterServer.getSocketAddress()).thenReturn((Object)new InetSocketAddress(6001));
        result = SwitchToMaster.getMasterUri((URI)me, (MasterServer)masterServer, (Config)config);
        Assert.assertEquals((String)"Wrong address", (Object)"ha://127.0.0.1:6001?serverId=1", (Object)result.toString());
    }

    @Test
    public void switchToMasterShouldHandleNoIpInConfig() throws Exception {
        Config config = Config.embeddedDefaults((Map)MapUtil.stringMap((String[])new String[]{ClusterSettings.server_id.name(), "1", HaSettings.ha_server.name(), ":6001"}));
        MasterServer masterServer = (MasterServer)Mockito.mock(MasterServer.class);
        URI me = new URI("ha://127.0.0.1");
        Mockito.when((Object)masterServer.getSocketAddress()).thenReturn((Object)new InetSocketAddress("192.168.1.1", 6001));
        URI result = SwitchToMaster.getMasterUri((URI)me, (MasterServer)masterServer, (Config)config);
        Assert.assertEquals((String)"Wrong address", (Object)"ha://192.168.1.1:6001?serverId=1", (Object)result.toString());
        Mockito.when((Object)masterServer.getSocketAddress()).thenReturn((Object)new InetSocketAddress(6001));
        result = SwitchToMaster.getMasterUri((URI)me, (MasterServer)masterServer, (Config)config);
        Assert.assertEquals((String)"Wrong address", (Object)"ha://127.0.0.1:6001?serverId=1", (Object)result.toString());
    }
}

