/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.test.rule.TestDirectory;

public class TestInstanceJoin {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void makeSureSlaveCanJoinEvenIfTooFarBackComparedToMaster() throws Exception {
        String key = "foo";
        String value = "bar";
        HighlyAvailableGraphDatabase master = null;
        HighlyAvailableGraphDatabase slave = null;
        File masterDir = this.testDirectory.directory("master");
        File slaveDir = this.testDirectory.directory("slave");
        try {
            master = TestInstanceJoin.start(masterDir, 0, MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.keep_logical_logs.name(), "1 txs", ClusterSettings.initial_hosts.name(), "127.0.0.1:5001"}));
            this.createNode(master, "something", "unimportant");
            this.checkPoint(master);
            slave = TestInstanceJoin.start(slaveDir, 1, MapUtil.stringMap((String[])new String[]{ClusterSettings.initial_hosts.name(), "127.0.0.1:5001,127.0.0.1:5002"}));
            slave.shutdown();
            this.createNode(master, key, value);
            this.checkPoint(master);
            this.rotateLog(master);
            master.shutdown();
            master = TestInstanceJoin.start(masterDir, 0, MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.keep_logical_logs.name(), "1 txs", ClusterSettings.initial_hosts.name(), "127.0.0.1:5001"}));
            int importantNodeCount = 10;
            for (int i = 0; i < importantNodeCount; ++i) {
                this.createNode(master, key, value);
                this.checkPoint(master);
                this.rotateLog(master);
            }
            this.checkPoint(master);
            slave = TestInstanceJoin.start(slaveDir, 1, MapUtil.stringMap((String[])new String[]{ClusterSettings.initial_hosts.name(), "127.0.0.1:5001,127.0.0.1:5002"}));
            ((UpdatePuller)slave.getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
            try (Transaction ignore = slave.beginTx();){
                Assert.assertEquals((String)"store contents differ", (long)(importantNodeCount + 1), (long)this.nodesHavingProperty(slave, key, value));
            }
        }
        finally {
            if (slave != null) {
                slave.shutdown();
            }
            if (master != null) {
                master.shutdown();
            }
        }
    }

    private void rotateLog(HighlyAvailableGraphDatabase db) throws IOException {
        ((LogRotation)db.getDependencyResolver().resolveDependency(LogRotation.class)).rotateLogFile();
    }

    private void checkPoint(HighlyAvailableGraphDatabase db) throws IOException {
        ((CheckPointer)db.getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
    }

    private int nodesHavingProperty(HighlyAvailableGraphDatabase slave, String key, String value) {
        try (Transaction tx = slave.beginTx();){
            int count = 0;
            for (Node node : slave.getAllNodes()) {
                if (!value.equals(node.getProperty(key, null))) continue;
                ++count;
            }
            tx.success();
            int n = count;
            return n;
        }
    }

    private long createNode(HighlyAvailableGraphDatabase db, String key, String value) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            node.setProperty(key, (Object)value);
            tx.success();
            long l = node.getId();
            return l;
        }
    }

    private static HighlyAvailableGraphDatabase start(File storeDir, int i, Map<String, String> additionalConfig) {
        HighlyAvailableGraphDatabase db = (HighlyAvailableGraphDatabase)new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDir).setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + (5001 + i)).setConfig(ClusterSettings.server_id, i + "").setConfig(HaSettings.ha_server, "127.0.0.1:" + (6666 + i)).setConfig(HaSettings.pull_interval, "0ms").setConfig(additionalConfig).newGraphDatabase();
        TestInstanceJoin.awaitStart(db);
        return db;
    }

    private static void awaitStart(HighlyAvailableGraphDatabase db) {
        db.beginTx().close();
    }
}

