/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.rule.TestDirectory;

public class ConcurrentInstanceStartupIT {
    public static final int INSTANCE_COUNT = 3;
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();

    @Test
    public void concurrentStartupShouldWork() throws Exception {
        this.testDirectory.directory("nothingToSeeHereMoveAlong");
        StringBuffer initialHostsBuffer = new StringBuffer("127.0.0.1:5001");
        for (int i = 2; i <= 3; ++i) {
            initialHostsBuffer.append(",127.0.0.1:500" + i);
        }
        String initialHosts = initialHostsBuffer.toString();
        CyclicBarrier barrier = new CyclicBarrier(3);
        ArrayList<Thread> daThreads = new ArrayList<Thread>(3);
        HighlyAvailableGraphDatabase[] dbs = new HighlyAvailableGraphDatabase[3];
        int i = 1;
        while (i <= 3) {
            int finalI = i++;
            Thread t = new Thread(() -> {
                try {
                    barrier.await();
                    dbs[finalI - 1] = this.startDbAtBase(finalI, initialHosts);
                }
                catch (InterruptedException | BrokenBarrierException e) {
                    throw new RuntimeException(e);
                }
            });
            daThreads.add(t);
            t.start();
        }
        for (Thread daThread : daThreads) {
            daThread.join();
        }
        boolean masterDone = false;
        for (HighlyAvailableGraphDatabase db : dbs) {
            if (db.isMaster()) {
                if (masterDone) {
                    throw new Exception("Two masters discovered");
                }
                masterDone = true;
            }
            try (Transaction tx = db.beginTx();){
                db.createNode();
                tx.success();
            }
        }
        Assert.assertTrue((boolean)masterDone);
        for (HighlyAvailableGraphDatabase db : dbs) {
            db.shutdown();
        }
    }

    private HighlyAvailableGraphDatabase startDbAtBase(int i, String initialHosts) {
        GraphDatabaseBuilder masterBuilder = new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.path(i).getAbsoluteFile()).setConfig(ClusterSettings.initial_hosts, initialHosts).setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + (5000 + i)).setConfig(ClusterSettings.server_id, "" + i).setConfig(HaSettings.ha_server, ":" + (8000 + i)).setConfig(HaSettings.tx_push_factor, "0");
        return (HighlyAvailableGraphDatabase)masterBuilder.newGraphDatabase();
    }

    private File path(int i) {
        return this.testDirectory.directory(i + "");
    }
}

