/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.ha;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.com.ports.allocation.PortAuthority;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.storemigration.LogFiles;
import org.neo4j.test.rule.LoggerRule;
import org.neo4j.test.rule.TestDirectory;

public class ClusterIT {
    @Rule
    public LoggerRule logging = new LoggerRule(Level.ALL);
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public TestName testName = new TestName();

    @Test
    public void testCluster() throws Throwable {
        try {
            ClusterManager clusterManager = ((ClusterManager.Builder)new ClusterManager.Builder(this.testDirectory.directory(this.testName.getMethodName())).withSharedConfig(MapUtil.stringMap((String[])new String[]{HaSettings.ha_server.name(), "localhost:6001-9999", HaSettings.tx_push_factor.name(), "2"}))).build();
            this.createClusterWithNode(clusterManager);
        }
        catch (DirectoryNotEmptyException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException("TODO", e);
        }
    }

    @Test
    public void testClusterWithHostnames() throws Throwable {
        ClusterManager clusterManager = ((ClusterManager.Builder)((ClusterManager.Builder)new ClusterManager.Builder(this.testDirectory.directory(this.testName.getMethodName())).withCluster((Supplier)ClusterManager.clusterOfSize("localhost", 3))).withSharedConfig(MapUtil.stringMap((String[])new String[]{HaSettings.ha_server.name(), "localhost:6001-9999", HaSettings.tx_push_factor.name(), "2"}))).build();
        this.createClusterWithNode(clusterManager);
    }

    @Test
    public void testClusterWithWildcardIP() throws Throwable {
        ClusterManager clusterManager = ((ClusterManager.Builder)((ClusterManager.Builder)new ClusterManager.Builder(this.testDirectory.directory(this.testName.getMethodName())).withCluster((Supplier)ClusterManager.clusterOfSize("0.0.0.0", 3))).withSharedConfig(MapUtil.stringMap((String[])new String[]{HaSettings.ha_server.name(), "0.0.0.0:6001-9999", HaSettings.tx_push_factor.name(), "2"}))).build();
        this.createClusterWithNode(clusterManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInstancesWithConflictingClusterPorts() throws Throwable {
        HighlyAvailableGraphDatabase first = null;
        int clusterPort = PortAuthority.allocatePort();
        try {
            File masterStoreDir = this.testDirectory.directory(this.testName.getMethodName() + "Master");
            first = (HighlyAvailableGraphDatabase)new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(masterStoreDir).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:" + clusterPort).setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + clusterPort).setConfig(ClusterSettings.server_id, "1").setConfig(HaSettings.ha_server, "127.0.0.1:" + PortAuthority.allocatePort()).newGraphDatabase();
            try {
                File slaveStoreDir = this.testDirectory.directory(this.testName.getMethodName() + "Slave");
                HighlyAvailableGraphDatabase failed = (HighlyAvailableGraphDatabase)new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(slaveStoreDir).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:" + clusterPort).setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + clusterPort).setConfig(ClusterSettings.server_id, "2").setConfig(HaSettings.ha_server, "127.0.0.1:" + PortAuthority.allocatePort()).newGraphDatabase();
                failed.shutdown();
                Assert.fail((String)"Should not start when ports conflict");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            if (first != null) {
                first.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void given4instanceClusterWhenMasterGoesDownThenElectNewMaster() throws Throwable {
        ClusterManager clusterManager = ((ClusterManager.Builder)new ClusterManager.Builder(this.testDirectory.directory(this.testName.getMethodName())).withCluster((Supplier)ClusterManager.clusterOfSize(4))).build();
        try {
            clusterManager.start();
            ClusterManager.ManagedCluster cluster = clusterManager.getCluster();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            this.logging.getLogger().info("STOPPING MASTER");
            cluster.shutdown(cluster.getMaster());
            this.logging.getLogger().info("STOPPED MASTER");
            cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            this.logging.getLogger().info("CREATE NODE");
            try (Transaction tx = master.beginTx();){
                master.createNode();
                this.logging.getLogger().info("CREATED NODE");
                tx.success();
            }
            this.logging.getLogger().info("STOPPING CLUSTER");
        }
        finally {
            clusterManager.safeShutdown();
        }
    }

    @Test
    public void givenEmptyHostListWhenClusterStartupThenFormClusterWithSingleInstance() throws Exception {
        HighlyAvailableGraphDatabase db = (HighlyAvailableGraphDatabase)new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.testDirectory.directory(this.testName.getMethodName())).setConfig(ClusterSettings.server_id, "1").setConfig(ClusterSettings.initial_hosts, "").newGraphDatabase();
        try {
            Assert.assertTrue((String)"Single instance cluster was not formed in time", (boolean)db.isAvailable(10000L));
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenClusterWhenMasterGoesDownAndTxIsRunningThenDontWaitToSwitch() throws Throwable {
        ClusterManager clusterManager = ((ClusterManager.Builder)new ClusterManager.Builder(this.testDirectory.directory(this.testName.getMethodName())).withCluster((Supplier)ClusterManager.clusterOfSize(3))).build();
        try {
            clusterManager.start();
            ClusterManager.ManagedCluster cluster = clusterManager.getCluster();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
            Transaction tx = slave.beginTx();
            slave.createNode();
            cluster.shutdown(cluster.getMaster());
            cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
            cluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
            tx.success();
            try {
                tx.close();
                Assert.fail((String)"Exception expected");
            }
            catch (Exception e) {
                Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(TransientTransactionFailureException.class));
                Throwable rootCause = Exceptions.rootCause((Throwable)e);
                Assert.assertThat((Object)rootCause, (Matcher)Matchers.instanceOf(TransactionTerminatedException.class));
                Assert.assertThat((Object)((TransactionTerminatedException)rootCause).status(), (Matcher)Matchers.equalTo((Object)Status.General.DatabaseUnavailable));
            }
        }
        finally {
            clusterManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void lastTxCommitTimestampShouldGetInitializedOnSlaveIfNotPresent() throws Throwable {
        ClusterManager clusterManager = ((ClusterManager.Builder)new ClusterManager.Builder(this.testDirectory.directory(this.testName.getMethodName())).withCluster((Supplier)ClusterManager.clusterOfSize(3))).build();
        try {
            clusterManager.start();
            ClusterManager.ManagedCluster cluster = clusterManager.getCluster();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            ClusterIT.runSomeTransactions(cluster.getMaster());
            cluster.sync(new HighlyAvailableGraphDatabase[0]);
            HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
            File storeDir = slave.getStoreDir();
            ClusterManager.RepairKit slaveRepairKit = cluster.shutdown(slave);
            ClusterIT.clearLastTransactionCommitTimestampField(storeDir);
            HighlyAvailableGraphDatabase repairedSlave = slaveRepairKit.repair();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            Assert.assertEquals((long)ClusterIT.lastCommittedTxTimestamp(cluster.getMaster()), (long)ClusterIT.lastCommittedTxTimestamp(repairedSlave));
        }
        finally {
            clusterManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void lastTxCommitTimestampShouldBeUnknownAfterStartIfNoFiledOrLogsPresent() throws Throwable {
        ClusterManager clusterManager = ((ClusterManager.Builder)new ClusterManager.Builder(this.testDirectory.directory(this.testName.getMethodName())).withCluster((Supplier)ClusterManager.clusterOfSize(3))).build();
        try {
            clusterManager.start();
            ClusterManager.ManagedCluster cluster = clusterManager.getCluster();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            ClusterIT.runSomeTransactions(cluster.getMaster());
            cluster.sync(new HighlyAvailableGraphDatabase[0]);
            HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
            File storeDir = slave.getStoreDir();
            ClusterManager.RepairKit slaveRepairKit = cluster.shutdown(slave);
            ClusterIT.clearLastTransactionCommitTimestampField(storeDir);
            ClusterIT.deleteLogs(storeDir);
            HighlyAvailableGraphDatabase repairedSlave = slaveRepairKit.repair();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            Assert.assertEquals((long)1L, (long)ClusterIT.lastCommittedTxTimestamp(repairedSlave));
        }
        finally {
            clusterManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createClusterWithNode(ClusterManager clusterManager) throws Throwable {
        try {
            long nodeId;
            clusterManager.start();
            clusterManager.getCluster().await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase master = clusterManager.getCluster().getMaster();
            try (Transaction tx = master.beginTx();){
                Node node = master.createNode();
                nodeId = node.getId();
                node.setProperty("foo", (Object)"bar");
                tx.success();
            }
            HighlyAvailableGraphDatabase slave = clusterManager.getCluster().getAnySlave(new HighlyAvailableGraphDatabase[0]);
            try (Transaction ignored = slave.beginTx();){
                Node node = slave.getNodeById(nodeId);
                Assert.assertThat((Object)node.getProperty("foo").toString(), (Matcher)CoreMatchers.equalTo((Object)"bar"));
            }
        }
        finally {
            clusterManager.safeShutdown();
        }
    }

    private static void deleteLogs(File storeDir) {
        for (File file : storeDir.listFiles(LogFiles.FILENAME_FILTER)) {
            FileUtils.deleteFile((File)file);
        }
    }

    private static void runSomeTransactions(HighlyAvailableGraphDatabase db) {
        for (int i = 0; i < 10; ++i) {
            try (Transaction tx = db.beginTx();){
                for (int j = 0; j < 10; ++j) {
                    db.createNode();
                }
                tx.success();
                continue;
            }
        }
    }

    private static void clearLastTransactionCommitTimestampField(File storeDir) throws IOException {
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
             PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fileSystem);){
            File neoStore = new File(storeDir, "neostore");
            MetaDataStore.setRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_COMMIT_TIMESTAMP, (long)0L);
        }
    }

    private static long lastCommittedTxTimestamp(HighlyAvailableGraphDatabase db) {
        DependencyResolver resolver = db.getDependencyResolver();
        MetaDataStore metaDataStore = (MetaDataStore)resolver.resolveDependency(MetaDataStore.class);
        TransactionId txInfo = metaDataStore.getLastCommittedTransaction();
        return txInfo.commitTimestamp();
    }
}

