/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.neo4j.com.ComException;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.kernel.ha.AbstractTokenCreator;
import org.neo4j.kernel.ha.SlaveLabelTokenCreator;
import org.neo4j.kernel.ha.SlavePropertyTokenCreator;
import org.neo4j.kernel.ha.SlaveRelationshipTypeCreator;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.test.ConstantRequestContextFactory;
import org.neo4j.test.IntegerResponse;

@RunWith(value=Parameterized.class)
public class SlaveTokenCreatorTest {
    private SlaveTokenCreatorFixture fixture;
    private Master master;
    private RequestContext requestContext;
    private RequestContextFactory requestContextFactory;
    private String name;
    private AbstractTokenCreator tokenCreator;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> tokenCreators() {
        SlaveTokenCreatorFixture slaveLabelTokenCreatorFixture = new SlaveTokenCreatorFixture(){

            @Override
            public AbstractTokenCreator build(Master master, RequestContextFactory requestContextFactory) {
                return new SlaveLabelTokenCreator(master, requestContextFactory);
            }

            @Override
            public Response<Integer> callMasterMethod(Master master, RequestContext ctx, String name) {
                return master.createLabel(ctx, name);
            }
        };
        SlaveTokenCreatorFixture slaveRelationshipTypeTokenCreatorFixture = new SlaveTokenCreatorFixture(){

            @Override
            public AbstractTokenCreator build(Master master, RequestContextFactory requestContextFactory) {
                return new SlaveRelationshipTypeCreator(master, requestContextFactory);
            }

            @Override
            public Response<Integer> callMasterMethod(Master master, RequestContext ctx, String name) {
                return master.createRelationshipType(ctx, name);
            }
        };
        SlaveTokenCreatorFixture slavePropertyTokenCreatorFixture = new SlaveTokenCreatorFixture(){

            @Override
            public AbstractTokenCreator build(Master master, RequestContextFactory requestContextFactory) {
                return new SlavePropertyTokenCreator(master, requestContextFactory);
            }

            @Override
            public Response<Integer> callMasterMethod(Master master, RequestContext ctx, String name) {
                return master.createPropertyKey(ctx, name);
            }
        };
        return Arrays.asList({"SlaveLabelTokenCreator", slaveLabelTokenCreatorFixture}, {"SlaveRelationshipTypeTokenCreator", slaveRelationshipTypeTokenCreatorFixture}, {"SlavePropertyTokenCreator", slavePropertyTokenCreatorFixture});
    }

    public SlaveTokenCreatorTest(String name, SlaveTokenCreatorFixture fixture) {
        this.fixture = fixture;
        this.master = (Master)Mockito.mock(Master.class);
        this.requestContext = new RequestContext(1L, 2, 3, 4L, 5L);
        this.name = "Poke";
        this.requestContextFactory = new ConstantRequestContextFactory(this.requestContext);
        this.tokenCreator = fixture.build(this.master, this.requestContextFactory);
    }

    @Test(expected=TransientTransactionFailureException.class)
    public void mustTranslateComExceptionsToTransientTransactionFailures() throws Exception {
        Mockito.when(this.fixture.callMasterMethod(this.master, this.requestContext, this.name)).thenThrow(new Throwable[]{new ComException()});
        this.tokenCreator.getOrCreate(this.name);
    }

    @Test
    public void mustReturnIdentifierFromMaster() throws Exception {
        Mockito.when(this.fixture.callMasterMethod(this.master, this.requestContext, this.name)).thenReturn((Object)new IntegerResponse(13));
        Assert.assertThat((Object)this.tokenCreator.getOrCreate(this.name), (Matcher)Matchers.is((Object)13));
    }

    public static interface SlaveTokenCreatorFixture {
        public AbstractTokenCreator build(Master var1, RequestContextFactory var2);

        public Response<Integer> callMasterMethod(Master var1, RequestContext var2, String var3);
    }
}

