/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.ha;

import java.util.Iterator;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.InstanceId;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.security.WriteOperationsNotAllowedException;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

public class ReadOnlySlaveIT {
    @Rule
    public final ClusterRule clusterRule = ((ClusterRule)new ClusterRule(this.getClass()).withSharedSetting(HaSettings.tx_push_factor, "2")).withInstanceSetting(GraphDatabaseSettings.read_only, oneBasedServerId -> oneBasedServerId == 2 ? "true" : null);

    @Test
    public void givenClusterWithReadOnlySlaveWhenWriteTxOnSlaveThenCommitFails() throws Throwable {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase readOnlySlave = cluster.getMemberByServerId(new InstanceId(2));
        try (Transaction tx = readOnlySlave.beginTx();){
            readOnlySlave.createNode();
            tx.success();
            TestCase.fail((String)"Should have thrown exception");
        }
        catch (WriteOperationsNotAllowedException writeOperationsNotAllowedException) {
            // empty catch block
        }
    }

    @Test
    public void givenClusterWithReadOnlySlaveWhenChangePropertyOnSlaveThenThrowException() throws Throwable {
        Node node;
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        try (Transaction tx = master.beginTx();){
            node = master.createNode();
            tx.success();
        }
        HighlyAvailableGraphDatabase readOnlySlave = cluster.getMemberByServerId(new InstanceId(2));
        try (Transaction tx = readOnlySlave.beginTx();){
            Node slaveNode = readOnlySlave.getNodeById(node.getId());
            slaveNode.setProperty("foo", (Object)"bar");
            tx.success();
            TestCase.fail((String)"Should have thrown exception");
        }
        catch (WriteOperationsNotAllowedException writeOperationsNotAllowedException) {
            // empty catch block
        }
    }

    @Test
    public void givenClusterWithReadOnlySlaveWhenAddNewLabelOnSlaveThenThrowException() throws Throwable {
        Node node;
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        try (Transaction tx = master.beginTx();){
            node = master.createNode();
            tx.success();
        }
        HighlyAvailableGraphDatabase readOnlySlave = cluster.getMemberByServerId(new InstanceId(2));
        try (Transaction tx = readOnlySlave.beginTx();){
            Node slaveNode = readOnlySlave.getNodeById(node.getId());
            slaveNode.addLabel(Label.label((String)"FOO"));
            tx.success();
            TestCase.fail((String)"Should have thrown exception");
        }
        catch (WriteOperationsNotAllowedException writeOperationsNotAllowedException) {
            // empty catch block
        }
    }

    @Test
    public void givenClusterWithReadOnlySlaveWhenAddNewRelTypeOnSlaveThenThrowException() throws Throwable {
        Node node2;
        Node node;
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        try (Transaction tx = master.beginTx();){
            node = master.createNode();
            node2 = master.createNode();
            tx.success();
        }
        HighlyAvailableGraphDatabase readOnlySlave = cluster.getMemberByServerId(new InstanceId(2));
        try (Transaction tx = readOnlySlave.beginTx();){
            Node slaveNode = readOnlySlave.getNodeById(node.getId());
            Node slaveNode2 = readOnlySlave.getNodeById(node2.getId());
            slaveNode.createRelationshipTo(slaveNode2, RelationshipType.withName((String)"KNOWS"));
            tx.success();
            TestCase.fail((String)"Should have thrown exception");
        }
        catch (WriteOperationsNotAllowedException writeOperationsNotAllowedException) {
            // empty catch block
        }
    }

    @Test
    public void givenClusterWithReadOnlySlaveWhenCreatingNodeOnMasterThenSlaveShouldBeAbleToPullUpdates() throws Exception {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        Label label = Label.label((String)"label");
        Transaction tx = master.beginTx();
        Object object = null;
        try {
            master.createNode(new Label[]{label});
            tx.success();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Iterable<HighlyAvailableGraphDatabase> allMembers = cluster.getAllMembers(new HighlyAvailableGraphDatabase[0]);
        for (HighlyAvailableGraphDatabase member : allMembers) {
            Transaction tx2 = member.beginTx();
            Throwable throwable = null;
            try {
                long count = Iterators.count((Iterator)member.findNodes(label));
                tx2.success();
                Assert.assertEquals((long)1L, (long)count);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx2 == null) continue;
                if (throwable != null) {
                    try {
                        tx2.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx2.close();
            }
        }
    }
}

