/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.com.ports.allocation.PortAuthority;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.rule.TestDirectory;

public class ConcurrentInstanceStartupIT {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();

    @Test
    public void concurrentStartupShouldWork() throws Exception {
        this.testDirectory.directory("nothingToSeeHereMoveAlong");
        int[] clusterPorts = new int[]{PortAuthority.allocatePort(), PortAuthority.allocatePort(), PortAuthority.allocatePort()};
        String initialHosts = this.initialHosts(clusterPorts);
        CyclicBarrier barrier = new CyclicBarrier(clusterPorts.length);
        ArrayList<Thread> daThreads = new ArrayList<Thread>(clusterPorts.length);
        HighlyAvailableGraphDatabase[] dbs = new HighlyAvailableGraphDatabase[clusterPorts.length];
        int i = 0;
        while (i < clusterPorts.length) {
            int finalI = i++;
            Thread t = new Thread(() -> {
                try {
                    barrier.await();
                    dbs[finalI] = this.startDbAtBase(finalI, initialHosts, clusterPorts[finalI]);
                }
                catch (InterruptedException | BrokenBarrierException e) {
                    throw new RuntimeException(e);
                }
            });
            daThreads.add(t);
            t.start();
        }
        for (Thread daThread : daThreads) {
            daThread.join();
        }
        boolean masterDone = false;
        for (HighlyAvailableGraphDatabase db : dbs) {
            if (db.isMaster()) {
                if (masterDone) {
                    throw new Exception("Two masters discovered");
                }
                masterDone = true;
            }
            try (Transaction tx = db.beginTx();){
                db.createNode();
                tx.success();
            }
        }
        Assert.assertTrue((boolean)masterDone);
        for (HighlyAvailableGraphDatabase db : dbs) {
            db.shutdown();
        }
    }

    private String initialHosts(int[] clusterPorts) {
        return IntStream.of(clusterPorts).mapToObj(i -> "127.0.0.1:" + i).collect(Collectors.joining(","));
    }

    private HighlyAvailableGraphDatabase startDbAtBase(int i, String initialHosts, int clusterPort) {
        GraphDatabaseBuilder masterBuilder = new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.path(i).getAbsoluteFile()).setConfig(ClusterSettings.initial_hosts, initialHosts).setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + clusterPort).setConfig(ClusterSettings.server_id, "" + i).setConfig(HaSettings.ha_server, ":" + PortAuthority.allocatePort()).setConfig(HaSettings.tx_push_factor, "0").setConfig(OnlineBackupSettings.online_backup_enabled, "false");
        return (HighlyAvailableGraphDatabase)masterBuilder.newGraphDatabase();
    }

    private File path(int i) {
        return this.testDirectory.directory(i + "");
    }
}

