/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;

public class UpdatePullerScheduler
extends LifecycleAdapter {
    private final JobScheduler scheduler;
    private final Log log;
    private final UpdatePuller updatePuller;
    private final long pullIntervalMillis;
    private JobScheduler.JobHandle intervalJobHandle;

    public UpdatePullerScheduler(JobScheduler scheduler, LogProvider logProvider, UpdatePuller updatePullingThread, long pullIntervalMillis) {
        this.scheduler = scheduler;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
        this.updatePuller = updatePullingThread;
        this.pullIntervalMillis = pullIntervalMillis;
    }

    public void init() throws Throwable {
        if (this.pullIntervalMillis > 0L) {
            this.intervalJobHandle = this.scheduler.scheduleRecurring(JobScheduler.Groups.pullUpdates, () -> {
                try {
                    this.updatePuller.pullUpdates();
                }
                catch (InterruptedException e) {
                    this.log.error("Pull updates failed", (Throwable)e);
                }
            }, this.pullIntervalMillis, this.pullIntervalMillis, TimeUnit.MILLISECONDS);
        }
    }

    public void shutdown() throws Throwable {
        if (this.intervalJobHandle != null) {
            this.intervalJobHandle.cancel(false);
        }
    }
}

