/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

public class TwoInstanceClusterIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule(this.getClass());
    private ClusterManager.ManagedCluster cluster;

    @Before
    public void setup() throws Exception {
        this.cluster = ((ClusterRule)((ClusterRule)((ClusterRule)((ClusterRule)this.clusterRule.withSharedSetting(HaSettings.read_timeout, "1s")).withSharedSetting(HaSettings.state_switch_timeout, "2s")).withSharedSetting(HaSettings.com_chunk_size, "1024")).withCluster((Supplier)ClusterManager.clusterOfSize(2))).startCluster();
    }

    @Test
    public void masterShouldRemainAvailableIfTheSlaveDiesAndRecovers() throws Throwable {
        long slaveNodeId;
        long masterNodeId;
        Node node;
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        HighlyAvailableGraphDatabase theSlave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        String propertyName = "prop";
        String propertyValue1 = "value1";
        String propertyValue2 = "value2";
        ClusterManager.RepairKit repairKit = this.cluster.fail(theSlave);
        this.cluster.await(ClusterManager.memberSeesOtherMemberAsFailed(master, theSlave));
        try (Transaction tx = master.beginTx();){
            node = master.createNode();
            node.setProperty(propertyName, (Object)propertyValue1);
            masterNodeId = node.getId();
            tx.success();
        }
        repairKit.repair();
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        tx = theSlave.beginTx();
        var12_8 = null;
        try {
            node = theSlave.createNode();
            node.setProperty(propertyName, (Object)propertyValue2);
            Assert.assertEquals((Object)propertyValue1, (Object)theSlave.getNodeById(masterNodeId).getProperty(propertyName));
            slaveNodeId = node.getId();
            tx.success();
        }
        catch (Throwable throwable) {
            var12_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var12_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var12_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = master.beginTx();
        var12_8 = null;
        try {
            Assert.assertEquals((Object)propertyValue2, (Object)master.getNodeById(slaveNodeId).getProperty(propertyName));
            tx.success();
        }
        catch (Throwable throwable) {
            var12_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var12_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var12_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void slaveShouldMoveToPendingAndThenRecoverIfMasterDiesAndThenRecovers() throws Throwable {
        long slaveNodeId;
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        HighlyAvailableGraphDatabase theSlave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        String propertyName = "prop";
        String propertyValue = "value1";
        ClusterManager.RepairKit repairKit = this.cluster.fail(master);
        this.cluster.await(ClusterManager.memberSeesOtherMemberAsFailed(theSlave, master));
        Assert.assertEquals((Object)HighAvailabilityMemberState.PENDING, (Object)theSlave.getInstanceState());
        repairKit.repair();
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        try (Transaction tx = theSlave.beginTx();){
            Node node = theSlave.createNode();
            slaveNodeId = node.getId();
            node.setProperty(propertyName, (Object)propertyValue);
            tx.success();
        }
        tx = master.beginTx();
        var9_7 = null;
        try {
            Assert.assertEquals((Object)propertyValue, (Object)master.getNodeById(slaveNodeId).getProperty(propertyName));
            tx.success();
        }
        catch (Throwable throwable) {
            var9_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var9_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var9_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }
}

