/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.transaction;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.com.ComException;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.helpers.collection.FilteringIterator;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.com.master.Slave;
import org.neo4j.kernel.ha.com.master.SlavePriorities;
import org.neo4j.kernel.ha.com.master.SlavePriority;
import org.neo4j.kernel.ha.com.master.Slaves;
import org.neo4j.kernel.ha.transaction.CommitPusher;
import org.neo4j.kernel.impl.util.CappedLogger;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.time.Clocks;

public class TransactionPropagator
implements Lifecycle {
    private int desiredReplicationFactor;
    private SlavePriority replicationStrategy;
    private ExecutorService slaveCommitters;
    private final Log log;
    private final Configuration config;
    private final Slaves slaves;
    private final CommitPusher pusher;
    private final CappedLogger slaveCommitFailureLogger;
    private final CappedLogger pushedToTooFewSlaveLogger;

    public static Configuration from(final Config config) {
        return new Configuration(){

            @Override
            public int getTxPushFactor() {
                return (Integer)config.get(HaSettings.tx_push_factor);
            }

            @Override
            public InstanceId getServerId() {
                return (InstanceId)config.get(ClusterSettings.server_id);
            }

            @Override
            public SlavePriority getReplicationStrategy() {
                switch ((HaSettings.TxPushStrategy)((Object)config.get(HaSettings.tx_push_strategy))) {
                    case fixed_descending: {
                        return SlavePriorities.fixedDescending();
                    }
                    case fixed_ascending: {
                        return SlavePriorities.fixedAscending();
                    }
                    case round_robin: {
                        return SlavePriorities.roundRobin();
                    }
                }
                throw new RuntimeException("Unknown replication strategy ");
            }
        };
    }

    public static Configuration from(final Config config, final SlavePriority slavePriority) {
        return new Configuration(){

            @Override
            public int getTxPushFactor() {
                return (Integer)config.get(HaSettings.tx_push_factor);
            }

            @Override
            public InstanceId getServerId() {
                return (InstanceId)config.get(ClusterSettings.server_id);
            }

            @Override
            public SlavePriority getReplicationStrategy() {
                return slavePriority;
            }
        };
    }

    public TransactionPropagator(Configuration config, Log log, Slaves slaves, CommitPusher pusher) {
        this.config = config;
        this.log = log;
        this.slaves = slaves;
        this.pusher = pusher;
        this.slaveCommitFailureLogger = new CappedLogger(log).setTimeLimit(5L, TimeUnit.SECONDS, Clocks.systemClock());
        this.pushedToTooFewSlaveLogger = new CappedLogger(log).setTimeLimit(5L, TimeUnit.SECONDS, Clocks.systemClock());
    }

    public void init() {
    }

    public void start() {
        this.slaveCommitters = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("slave-committer"));
        this.desiredReplicationFactor = this.config.getTxPushFactor();
        this.replicationStrategy = this.config.getReplicationStrategy();
    }

    public void stop() {
        this.slaveCommitters.shutdown();
    }

    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int committed(long txId, int authorId) {
        boolean isAuthoredBySlave;
        int replicationFactor = this.desiredReplicationFactor;
        boolean bl = isAuthoredBySlave = this.config.getServerId().toIntegerIndex() != authorId;
        if (isAuthoredBySlave) {
            --replicationFactor;
        }
        if (replicationFactor == 0) {
            return replicationFactor;
        }
        HashSet<ReplicationContext> committers = new HashSet<ReplicationContext>();
        try {
            int successfulReplications = 0;
            Iterator<Slave> slaveList = this.filter(this.replicationStrategy.prioritize(this.slaves.getSlaves()).iterator(), authorId);
            CompletionNotifier notifier = new CompletionNotifier();
            for (int i = 0; i < replicationFactor && slaveList.hasNext(); ++i) {
                Slave slave = slaveList.next();
                Callable<Void> slaveCommitter = this.slaveCommitter(slave, txId, notifier);
                committers.add(new ReplicationContext(this.slaveCommitters.submit(slaveCommitter), slave));
            }
            ArrayList<ReplicationContext> toAdd = new ArrayList<ReplicationContext>();
            ArrayList<ReplicationContext> toRemove = new ArrayList<ReplicationContext>();
            while (true) {
                Iterator iterator;
                if (!committers.isEmpty() && successfulReplications < replicationFactor) {
                    toAdd.clear();
                    toRemove.clear();
                    iterator = committers.iterator();
                } else {
                    if (successfulReplications < replicationFactor) {
                        this.pushedToTooFewSlaveLogger.info("Transaction " + txId + " couldn't commit on enough slaves, desired " + replicationFactor + ", but could only commit at " + successfulReplications);
                    }
                    int n = replicationFactor - successfulReplications;
                    Iterator iterator2 = committers.iterator();
                    while (true) {
                        if (!iterator2.hasNext()) {
                            return n;
                        }
                        ReplicationContext committer = (ReplicationContext)iterator2.next();
                        committer.future.cancel(false);
                    }
                }
                while (iterator.hasNext()) {
                    ReplicationContext context = (ReplicationContext)iterator.next();
                    if (!context.future.isDone()) continue;
                    if (this.isSuccessful(context)) {
                        ++successfulReplications;
                    } else if (slaveList.hasNext()) {
                        Callable<Void> slaveCommitter;
                        Slave newSlave = slaveList.next();
                        try {
                            slaveCommitter = this.slaveCommitter(newSlave, txId, notifier);
                        }
                        catch (Throwable t) {
                            this.log.error("Unknown error commit master transaction at slave", t);
                            int n = this.desiredReplicationFactor;
                            Iterator iterator3 = committers.iterator();
                            while (true) {
                                if (!iterator3.hasNext()) {
                                    return n;
                                }
                                ReplicationContext committer = (ReplicationContext)iterator3.next();
                                committer.future.cancel(false);
                            }
                        }
                        toAdd.add(new ReplicationContext(this.slaveCommitters.submit(slaveCommitter), newSlave));
                    }
                    toRemove.add(context);
                }
                if (!toAdd.isEmpty()) {
                    committers.addAll(toAdd);
                }
                if (!toRemove.isEmpty()) {
                    committers.removeAll(toRemove);
                }
                if (committers.isEmpty()) continue;
                notifier.waitForAnyCompletion();
            }
        }
        catch (Throwable throwable) {
            Iterator iterator = committers.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    throw throwable;
                }
                ReplicationContext committer = (ReplicationContext)iterator.next();
                committer.future.cancel(false);
            }
        }
    }

    private Iterator<Slave> filter(Iterator<Slave> slaves, Integer externalAuthorServerId) {
        return externalAuthorServerId == null ? slaves : new FilteringIterator((Iterator)slaves, item -> item.getServerId() != externalAuthorServerId.intValue());
    }

    private boolean isSuccessful(ReplicationContext context) {
        try {
            context.future.get();
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (ExecutionException e) {
            context.throwable = e.getCause();
            this.slaveCommitFailureLogger.error("Slave " + context.slave.getServerId() + ": Replication commit threw" + (context.throwable instanceof ComException ? " communication" : "") + " exception:", context.throwable);
            return false;
        }
        catch (CancellationException e) {
            return false;
        }
    }

    private Callable<Void> slaveCommitter(Slave slave, long txId, CompletionNotifier notifier) {
        return () -> {
            try {
                this.pusher.queuePush(slave, txId);
                Void void_ = null;
                return void_;
            }
            finally {
                notifier.completed();
            }
        };
    }

    private static class CompletionNotifier {
        private boolean notified;

        private CompletionNotifier() {
        }

        synchronized void completed() {
            this.notified = true;
            this.notifyAll();
        }

        synchronized void waitForAnyCompletion() {
            if (!this.notified) {
                this.notified = false;
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            } else {
                this.notified = false;
            }
        }

        public String toString() {
            return "CompletionNotifier{id=" + System.identityHashCode(this) + ",notified=" + this.notified + "}";
        }
    }

    private static class ReplicationContext {
        final Future<Void> future;
        final Slave slave;
        Throwable throwable;

        ReplicationContext(Future<Void> future, Slave slave) {
            this.future = future;
            this.slave = slave;
        }
    }

    public static interface Configuration {
        public int getTxPushFactor();

        public InstanceId getServerId();

        public SlavePriority getReplicationStrategy();
    }
}

