/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

public class LabelIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule(this.getClass());
    protected ClusterManager.ManagedCluster cluster;

    @Before
    public void setup() throws Exception {
        this.cluster = this.clusterRule.startCluster();
    }

    @Test
    public void creatingIndexOnMasterShouldHaveSlavesBuildItAsWell() throws Throwable {
        HighlyAvailableGraphDatabase slave1 = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase slave2 = this.cluster.getAnySlave(slave1);
        Label label = Label.label((String)"Person");
        TransactionContinuation txOnSlave1 = LabelIT.createNodeAndKeepTxOpen(slave1, label);
        TransactionContinuation txOnSlave2 = LabelIT.createNodeAndKeepTxOpen(slave2, label);
        LabelIT.commit(txOnSlave1);
        LabelIT.commit(txOnSlave2);
        Assert.assertEquals((long)LabelIT.getLabelId(slave1, label), (long)LabelIT.getLabelId(slave2, label));
    }

    /*
     * Exception decompiling
     */
    private static long getLabelId(HighlyAvailableGraphDatabase db, Label label) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void commit(TransactionContinuation txc) throws Exception {
        txc.resume();
        txc.commit();
    }

    private static TransactionContinuation createNodeAndKeepTxOpen(HighlyAvailableGraphDatabase db, Label label) {
        TransactionContinuation txc = new TransactionContinuation(db);
        txc.begin();
        db.createNode(new Label[]{label});
        txc.suspend();
        return txc;
    }

    private static ThreadToStatementContextBridge threadToStatementContextBridgeFrom(HighlyAvailableGraphDatabase db) {
        return (ThreadToStatementContextBridge)db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
    }

    private static class TransactionContinuation {
        private final HighlyAvailableGraphDatabase db;
        private KernelTransaction graphDbTx;
        private final ThreadToStatementContextBridge bridge;

        private TransactionContinuation(HighlyAvailableGraphDatabase db) {
            this.db = db;
            this.bridge = LabelIT.threadToStatementContextBridgeFrom(db);
        }

        public void begin() {
            this.db.beginTx();
            this.graphDbTx = this.bridge.getKernelTransactionBoundToThisThread(false);
        }

        public void suspend() {
            this.graphDbTx = this.bridge.getKernelTransactionBoundToThisThread(true);
            this.bridge.unbindTransactionFromCurrentThread();
        }

        public void resume() throws Exception {
            this.bridge.bindTransactionToCurrentThread(this.graphDbTx);
        }

        public void commit() {
            try {
                this.graphDbTx.close();
            }
            catch (TransactionFailureException e) {
                throw new org.neo4j.graphdb.TransactionFailureException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

