/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.neo4j.kernel.ha.cluster.DefaultConversationSPI;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.scheduler.JobScheduler;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultConversationSPITest {
    @Mock(answer=Answers.RETURNS_MOCKS)
    private Locks locks;
    @Mock
    private JobScheduler jobScheduler;
    @InjectMocks
    private DefaultConversationSPI conversationSpi;

    @Test
    public void testAcquireClient() throws Exception {
        this.conversationSpi.acquireClient();
        ((Locks)Mockito.verify((Object)this.locks)).newClient();
    }

    @Test
    public void testScheduleRecurringJob() throws Exception {
        Runnable job = (Runnable)Mockito.mock(Runnable.class);
        JobScheduler.Group group = (JobScheduler.Group)Mockito.mock(JobScheduler.Group.class);
        this.conversationSpi.scheduleRecurringJob(group, 0L, job);
        ((JobScheduler)Mockito.verify((Object)this.jobScheduler)).scheduleRecurring(group, job, 0L, TimeUnit.MILLISECONDS);
    }
}

