/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.transaction;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.TimeUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Workers;

public class TransactionThroughMasterSwitchStressIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule(this.getClass()).withInstanceSetting(HaSettings.slave_only, value -> value == 1 || value == 2 ? "true" : "false");

    @Test
    public void shouldNotHaveTransactionsRunningThroughRoleSwitchProduceInconsistencies() throws Throwable {
        long duration = (Long)TimeUtil.parseTimeMillis.apply(System.getProperty(this.getClass().getName() + ".duration", "30s"));
        long endTime = System.currentTimeMillis() + duration;
        while (System.currentTimeMillis() < endTime) {
            this.oneRound();
        }
    }

    private void oneRound() throws Throwable {
        String key = "key";
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        long nodeId = this.createNode((GraphDatabaseService)master);
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        Workers transactors = new Workers("Transactors");
        AtomicInteger successes = new AtomicInteger();
        AtomicBoolean end = new AtomicBoolean();
        for (int i = 0; i < 10; ++i) {
            transactors.start(() -> TransactionThroughMasterSwitchStressIT.lambda$oneRound$1(end, (GraphDatabaseService)master, nodeId, successes));
        }
        this.reelectTheSameMasterMakingItGoToPendingAndBack(cluster);
        long targetSuccesses = successes.get() + 20;
        while ((long)successes.get() < targetSuccesses) {
            Thread.sleep(100L);
        }
        end.set(true);
        transactors.awaitAndThrowOnError(RuntimeException.class);
        Assert.assertEquals((Object)successes.get(), (Object)this.getNodePropertyValue((GraphDatabaseService)master, nodeId, "key"));
    }

    private Object getNodePropertyValue(GraphDatabaseService db, long nodeId, String key) {
        try (Transaction tx = db.beginTx();){
            Object value = db.getNodeById(nodeId).getProperty(key);
            tx.success();
            Object object = value;
            return object;
        }
    }

    private void reelectTheSameMasterMakingItGoToPendingAndBack(ClusterManager.ManagedCluster cluster) throws Throwable {
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        ClusterManager.RepairKit masterRepair = cluster.fail(master, false, ClusterManager.NetworkFlag.IN, ClusterManager.NetworkFlag.OUT);
        cluster.await(ClusterManager.memberThinksItIsRole(master, "UNKNOWN"));
        masterRepair.repair();
        cluster.await(ClusterManager.memberThinksItIsRole(master, "master"));
        cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        Assert.assertEquals((Object)master, (Object)cluster.getMaster());
    }

    private long createNode(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            tx.success();
            long l = node.getId();
            return l;
        }
    }

    private static /* synthetic */ void lambda$oneRound$1(AtomicBoolean end, GraphDatabaseService master, long nodeId, AtomicInteger successes) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while (!end.get()) {
            boolean committed = true;
            try (Transaction tx = master.beginTx();){
                Node node = master.getNodeById(nodeId);
                tx.acquireWriteLock((PropertyContainer)node);
                node.setProperty("key", (Object)((Integer)node.getProperty("key", (Object)0) + 1));
                node.createRelationshipTo(master.createNode(), (RelationshipType)MyRelTypes.TEST);
                Thread.sleep(((Random)random).nextInt(1000));
                tx.success();
            }
            catch (Throwable e) {
                committed = false;
            }
            if (!committed) continue;
            successes.incrementAndGet();
        }
    }
}

