/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.io.IOException;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.ha.cluster.DefaultMasterImplSPI;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class DefaultMasterImplSPITest {
    @Test
    public void flushStoreFilesWithCorrectCheckpointTriggerName() throws IOException {
        CheckPointer checkPointer = (CheckPointer)Mockito.mock(CheckPointer.class);
        NeoStoreDataSource dataSource = (NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class);
        Mockito.when((Object)dataSource.listStoreFiles(Matchers.anyBoolean())).thenReturn((Object)Iterators.emptyResourceIterator());
        DefaultMasterImplSPI master = new DefaultMasterImplSPI((GraphDatabaseAPI)Mockito.mock(GraphDatabaseAPI.class, (Answer)Mockito.RETURNS_MOCKS), (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class), new Monitors(), (LabelTokenHolder)Mockito.mock(LabelTokenHolder.class), (PropertyKeyTokenHolder)Mockito.mock(PropertyKeyTokenHolder.class), (RelationshipTypeTokenHolder)Mockito.mock(RelationshipTypeTokenHolder.class), (IdGeneratorFactory)Mockito.mock(IdGeneratorFactory.class), (TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class), checkPointer, (TransactionIdStore)Mockito.mock(TransactionIdStore.class), (LogicalTransactionStore)Mockito.mock(LogicalTransactionStore.class), dataSource, (PageCache)Mockito.mock(PageCache.class), new StoreCopyCheckPointMutex(), (LogProvider)NullLogProvider.getInstance());
        master.flushStoresAndStreamStoreFiles((StoreWriter)Mockito.mock(StoreWriter.class));
        SimpleTriggerInfo expectedTriggerInfo = new SimpleTriggerInfo("store copy");
        ((CheckPointer)Mockito.verify((Object)checkPointer)).tryCheckPoint((TriggerInfo)expectedTriggerInfo);
    }
}

