/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.function.Suppliers;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.SlaveLockManager;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.community.CommunityLockManger;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.time.Clocks;

public class SlaveLockManagerTest {
    private RequestContextFactory requestContextFactory;
    private Master master;
    private AvailabilityGuard availabilityGuard;

    @Before
    public void setUp() {
        this.requestContextFactory = new RequestContextFactory(1, Suppliers.singleton((Object)Mockito.mock(TransactionIdStore.class)));
        this.master = (Master)Mockito.mock(Master.class);
        this.availabilityGuard = new AvailabilityGuard(Clocks.systemClock(), (Log)NullLog.getInstance());
    }

    @Test
    public void shutsDownLocalLocks() throws Throwable {
        Locks localLocks = (Locks)Mockito.mock(Locks.class);
        SlaveLockManager slaveLockManager = this.newSlaveLockManager(localLocks);
        slaveLockManager.close();
        ((Locks)Mockito.verify((Object)localLocks)).close();
    }

    @Test
    public void doesNotCreateClientsAfterShutdown() throws Throwable {
        SlaveLockManager slaveLockManager = this.newSlaveLockManager((Locks)new CommunityLockManger(Config.defaults(), Clocks.systemClock()));
        Assert.assertNotNull((Object)slaveLockManager.newClient());
        slaveLockManager.close();
        try {
            slaveLockManager.newClient();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    private SlaveLockManager newSlaveLockManager(Locks localLocks) {
        return new SlaveLockManager(localLocks, this.requestContextFactory, this.master, this.availabilityGuard, (LogProvider)NullLogProvider.getInstance(), Config.defaults());
    }
}

