/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.net.URI;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.protocol.election.Election;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachineTest;
import org.neo4j.kernel.ha.cluster.SimpleHighAvailabilityMemberContext;
import org.neo4j.kernel.impl.store.StoreId;

public class HAStateMachineIllegalTransitionsTest {
    private final InstanceId me = new InstanceId(1);
    private ClusterMemberListener memberListener;
    private HighAvailabilityMemberStateMachine stateMachine;
    private Election election;

    @Before
    public void setup() throws Throwable {
        SimpleHighAvailabilityMemberContext context = new SimpleHighAvailabilityMemberContext(this.me, false);
        ClusterMemberEvents events = (ClusterMemberEvents)Mockito.mock(ClusterMemberEvents.class);
        HighAvailabilityMemberStateMachineTest.ClusterMemberListenerContainer memberListenerContainer = HighAvailabilityMemberStateMachineTest.mockAddClusterMemberListener(events);
        this.election = (Election)Mockito.mock(Election.class);
        this.stateMachine = this.buildMockedStateMachine((HighAvailabilityMemberContext)context, events, this.election);
        this.stateMachine.init();
        this.memberListener = memberListenerContainer.get();
        HighAvailabilityMemberStateMachineTest.HAStateChangeListener probe = new HighAvailabilityMemberStateMachineTest.HAStateChangeListener();
        this.stateMachine.addHighAvailabilityMemberListener((HighAvailabilityMemberListener)probe);
    }

    @Test
    public void shouldProperlyHandleMasterAvailableWhenInPending() throws Throwable {
        Assert.assertThat((Object)this.stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
        this.memberListener.memberIsAvailable("master", this.me, URI.create("ha://whatever"), StoreId.DEFAULT);
        this.assertPendingStateAndElectionsAsked();
    }

    @Test
    public void shouldProperlyHandleSlaveAvailableWhenInPending() throws Throwable {
        Assert.assertThat((Object)this.stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
        this.memberListener.memberIsAvailable("slave", this.me, URI.create("ha://whatever"), StoreId.DEFAULT);
        this.assertPendingStateAndElectionsAsked();
    }

    @Test
    public void shouldProperlyHandleNonElectedMasterBecomingAvailableWhenInToSlave() throws Throwable {
        InstanceId other = new InstanceId(2);
        InstanceId rogueMaster = new InstanceId(3);
        Assert.assertThat((Object)this.stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
        this.memberListener.memberIsAvailable("master", other, URI.create("ha://whatever"), StoreId.DEFAULT);
        Assert.assertThat((Object)this.stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.TO_SLAVE));
        this.memberListener.memberIsAvailable("master", rogueMaster, URI.create("ha://fromNowhere"), StoreId.DEFAULT);
        this.assertPendingStateAndElectionsAsked();
    }

    @Test
    public void shouldProperlyHandleConflictingMasterAvailableMessage() throws Throwable {
        InstanceId rogue = new InstanceId(2);
        Assert.assertThat((Object)this.stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
        this.memberListener.coordinatorIsElected(this.me);
        Assert.assertThat((Object)this.stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.TO_MASTER));
        this.memberListener.memberIsAvailable("master", rogue, URI.create("ha://someUri"), StoreId.DEFAULT);
        this.assertPendingStateAndElectionsAsked();
    }

    @Test
    public void shouldProperlyHandleConflictingSlaveIsAvailableMessageWhenInToMaster() throws Throwable {
        Assert.assertThat((Object)this.stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
        this.memberListener.coordinatorIsElected(this.me);
        Assert.assertThat((Object)this.stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.TO_MASTER));
        this.memberListener.memberIsAvailable("slave", this.me, URI.create("ha://someUri"), StoreId.DEFAULT);
        this.assertPendingStateAndElectionsAsked();
    }

    @Test
    public void shouldProperlyHandleConflictingSlaveIsAvailableWhenInMaster() throws Throwable {
        Assert.assertThat((Object)this.stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
        this.memberListener.coordinatorIsElected(this.me);
        Assert.assertThat((Object)this.stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.TO_MASTER));
        this.memberListener.memberIsAvailable("master", this.me, URI.create("ha://someUri"), StoreId.DEFAULT);
        Assert.assertThat((Object)this.stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.MASTER));
        this.memberListener.memberIsAvailable("slave", this.me, URI.create("ha://someUri"), StoreId.DEFAULT);
        this.assertPendingStateAndElectionsAsked();
    }

    @Test
    public void shouldProperlyHandleMasterIsAvailableWhenInMasterState() throws Throwable {
        InstanceId rogue = new InstanceId(2);
        Assert.assertThat((Object)this.stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
        this.memberListener.coordinatorIsElected(this.me);
        Assert.assertThat((Object)this.stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.TO_MASTER));
        this.memberListener.memberIsAvailable("master", this.me, URI.create("ha://someUri"), StoreId.DEFAULT);
        Assert.assertThat((Object)this.stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.MASTER));
        this.memberListener.memberIsAvailable("master", rogue, URI.create("ha://someUri"), StoreId.DEFAULT);
        this.assertPendingStateAndElectionsAsked();
    }

    @Test
    public void shouldProperlyHandleMasterIsAvailableWhenInSlaveState() throws Throwable {
        InstanceId master = new InstanceId(2);
        InstanceId rogueMaster = new InstanceId(3);
        Assert.assertThat((Object)this.stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
        this.memberListener.coordinatorIsElected(master);
        this.memberListener.memberIsAvailable("master", master, URI.create("ha://someUri"), StoreId.DEFAULT);
        Assert.assertThat((Object)this.stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.TO_SLAVE));
        this.memberListener.memberIsAvailable("slave", this.me, URI.create("ha://myUri"), StoreId.DEFAULT);
        Assert.assertThat((Object)this.stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.SLAVE));
        this.memberListener.memberIsAvailable("master", rogueMaster, URI.create("ha://someOtherUri"), StoreId.DEFAULT);
        this.assertPendingStateAndElectionsAsked();
    }

    private void assertPendingStateAndElectionsAsked() {
        Assert.assertThat((Object)this.stateMachine.getCurrentState(), (Matcher)CoreMatchers.equalTo((Object)HighAvailabilityMemberState.PENDING));
        ((Election)Mockito.verify((Object)this.election)).performRoleElections();
    }

    private HighAvailabilityMemberStateMachine buildMockedStateMachine(HighAvailabilityMemberContext context, ClusterMemberEvents events, Election election) {
        return new HighAvailabilityMemberStateMachineTest.StateMachineBuilder().withContext(context).withEvents(events).withElection(election).build();
    }
}

