/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.factory;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.neo4j.cluster.BindingListener;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.client.ClusterClientModule;
import org.neo4j.cluster.com.BindingNotifier;
import org.neo4j.cluster.logging.NettyLoggerFactory;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.member.paxos.MemberIsAvailable;
import org.neo4j.cluster.member.paxos.PaxosClusterMemberAvailability;
import org.neo4j.cluster.member.paxos.PaxosClusterMemberEvents;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcast;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectInputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectOutputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectStreamFactory;
import org.neo4j.cluster.protocol.cluster.Cluster;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.cluster.protocol.election.Election;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.NotElectableElectionCredentialsProvider;
import org.neo4j.cluster.protocol.heartbeat.Heartbeat;
import org.neo4j.cluster.protocol.snapshot.Snapshot;
import org.neo4j.com.Server;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.com.storecopy.StoreCopyClient;
import org.neo4j.com.storecopy.TransactionCommittingResponseUnpacker;
import org.neo4j.function.Factory;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.bolt.BoltConnectionTracker;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ssl.SslPolicyLoader;
import org.neo4j.kernel.enterprise.builtinprocs.EnterpriseBuiltInDbmsProcedures;
import org.neo4j.kernel.ha.BranchDetectingTxVerifier;
import org.neo4j.kernel.ha.BranchedDataMigrator;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighAvailabilityDiagnostics;
import org.neo4j.kernel.ha.HighAvailabilityLogger;
import org.neo4j.kernel.ha.LastUpdateTime;
import org.neo4j.kernel.ha.PullerFactory;
import org.neo4j.kernel.ha.TransactionChecksumLookup;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.cluster.ConversationSPI;
import org.neo4j.kernel.ha.cluster.DefaultConversationSPI;
import org.neo4j.kernel.ha.cluster.DefaultElectionCredentialsProvider;
import org.neo4j.kernel.ha.cluster.DefaultMasterImplSPI;
import org.neo4j.kernel.ha.cluster.HANewSnapshotFunction;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.cluster.SimpleHighAvailabilityMemberContext;
import org.neo4j.kernel.ha.cluster.SwitchToMaster;
import org.neo4j.kernel.ha.cluster.SwitchToSlave;
import org.neo4j.kernel.ha.cluster.SwitchToSlaveBranchThenCopy;
import org.neo4j.kernel.ha.cluster.SwitchToSlaveCopyThenBranch;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.cluster.member.HighAvailabilitySlaves;
import org.neo4j.kernel.ha.cluster.member.ObservedClusterMembers;
import org.neo4j.kernel.ha.cluster.modeswitch.CommitProcessSwitcher;
import org.neo4j.kernel.ha.cluster.modeswitch.ComponentSwitcherContainer;
import org.neo4j.kernel.ha.cluster.modeswitch.HighAvailabilityModeSwitcher;
import org.neo4j.kernel.ha.cluster.modeswitch.LabelTokenCreatorSwitcher;
import org.neo4j.kernel.ha.cluster.modeswitch.LockManagerSwitcher;
import org.neo4j.kernel.ha.cluster.modeswitch.PropertyKeyCreatorSwitcher;
import org.neo4j.kernel.ha.cluster.modeswitch.RelationshipTypeCreatorSwitcher;
import org.neo4j.kernel.ha.cluster.modeswitch.StatementLocksFactorySwitcher;
import org.neo4j.kernel.ha.cluster.modeswitch.UpdatePullerSwitcher;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.ConversationManager;
import org.neo4j.kernel.ha.com.master.DefaultSlaveFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.master.MasterImpl;
import org.neo4j.kernel.ha.com.master.MasterServer;
import org.neo4j.kernel.ha.com.master.Slave;
import org.neo4j.kernel.ha.com.master.SlaveFactory;
import org.neo4j.kernel.ha.com.master.Slaves;
import org.neo4j.kernel.ha.com.slave.InvalidEpochExceptionHandler;
import org.neo4j.kernel.ha.com.slave.MasterClientResolver;
import org.neo4j.kernel.ha.com.slave.SlaveServer;
import org.neo4j.kernel.ha.factory.HighlyAvailableCommitProcessFactory;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.ha.id.HaIdReuseEligibility;
import org.neo4j.kernel.ha.management.ClusterDatabaseInfoProvider;
import org.neo4j.kernel.ha.management.HighlyAvailableKernelData;
import org.neo4j.kernel.ha.transaction.CommitPusher;
import org.neo4j.kernel.ha.transaction.OnDiskLastTxIdGetter;
import org.neo4j.kernel.ha.transaction.TransactionPropagator;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHeaderInformation;
import org.neo4j.kernel.impl.core.DelegatingLabelTokenHolder;
import org.neo4j.kernel.impl.core.DelegatingPropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.DelegatingRelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.LastTxIdGetter;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.ReadOnlyTokenCreator;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.TokenCreator;
import org.neo4j.kernel.impl.coreapi.CoreAPIAvailabilityGuard;
import org.neo4j.kernel.impl.enterprise.EnterpriseConstraintSemantics;
import org.neo4j.kernel.impl.enterprise.EnterpriseEditionModule;
import org.neo4j.kernel.impl.enterprise.StandardBoltConnectionTracker;
import org.neo4j.kernel.impl.enterprise.id.EnterpriseIdTypeConfigurationProvider;
import org.neo4j.kernel.impl.enterprise.transaction.log.checkpoint.ConfigurableIOLimiter;
import org.neo4j.kernel.impl.factory.CanWrite;
import org.neo4j.kernel.impl.factory.CommunityEditionModule;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.factory.ReadOnly;
import org.neo4j.kernel.impl.factory.StatementLocksFactorySelector;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.stats.IdBasedStoreEntityCounters;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.info.DiagnosticsProvider;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.KernelData;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.udc.UsageData;
import org.neo4j.udc.UsageDataKeys;

public class HighlyAvailableEditionModule
extends EditionModule {
    private HighAvailabilityMemberStateMachine memberStateMachine;
    public ClusterMembers members;

    public HighlyAvailableEditionModule(PlatformModule platformModule) {
        this.ioLimiter = new ConfigurableIOLimiter(platformModule.config);
        LifeSupport life = platformModule.life;
        life.add((Lifecycle)platformModule.dataSourceManager);
        LifeSupport paxosLife = new LifeSupport();
        LifeSupport clusteringLife = new LifeSupport();
        FileSystemAbstraction fs = platformModule.fileSystem;
        File storeDir = platformModule.storeDir;
        Config config = platformModule.config;
        Dependencies dependencies = platformModule.dependencies;
        LogService logging = platformModule.logging;
        Monitors monitors = platformModule.monitors;
        this.accessCapability = (Boolean)config.get(GraphDatabaseSettings.read_only) != false ? new ReadOnly() : new CanWrite();
        this.idTypeConfigurationProvider = new EnterpriseIdTypeConfigurationProvider(config);
        this.watcherService = this.createFileSystemWatcherService(platformModule.fileSystem, storeDir, logging, platformModule.jobScheduler, HighlyAvailableEditionModule.fileWatcherFileNameFilter());
        dependencies.satisfyDependencies(new Object[]{this.watcherService});
        life.add((Lifecycle)this.watcherService);
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new NettyLoggerFactory(logging.getInternalLogProvider()));
        life.add((Lifecycle)new BranchedDataMigrator(platformModule.storeDir, platformModule.pageCache));
        DelegateInvocationHandler<Master> masterDelegateInvocationHandler = new DelegateInvocationHandler<Master>(Master.class);
        Master master = (Master)Proxy.newProxyInstance(Master.class.getClassLoader(), new Class[]{Master.class}, masterDelegateInvocationHandler);
        InstanceId serverId = (InstanceId)config.get(ClusterSettings.server_id);
        RequestContextFactory requestContextFactory = (RequestContextFactory)((Object)dependencies.satisfyDependency((Object)new RequestContextFactory(serverId.toIntegerIndex(), dependencies.provideDependency(TransactionIdStore.class))));
        long idReuseSafeZone = ((Duration)config.get(HaSettings.id_reuse_safe_zone_time)).toMillis();
        TransactionCommittingResponseUnpacker responseUnpacker = (TransactionCommittingResponseUnpacker)dependencies.satisfyDependency((Object)new TransactionCommittingResponseUnpacker((DependencyResolver)dependencies, ((Integer)config.get(HaSettings.pull_apply_batch_size)).intValue(), idReuseSafeZone));
        Supplier kernelProvider = dependencies.provideDependency(KernelAPI.class);
        this.transactionStartTimeout = ((Duration)config.get(HaSettings.state_switch_timeout)).toMillis();
        DelegateInvocationHandler<ClusterMemberEvents> clusterEventsDelegateInvocationHandler = new DelegateInvocationHandler<ClusterMemberEvents>(ClusterMemberEvents.class);
        DelegateInvocationHandler<HighAvailabilityMemberContext> memberContextDelegateInvocationHandler = new DelegateInvocationHandler<HighAvailabilityMemberContext>(HighAvailabilityMemberContext.class);
        DelegateInvocationHandler<ClusterMemberAvailability> clusterMemberAvailabilityDelegateInvocationHandler = new DelegateInvocationHandler<ClusterMemberAvailability>(ClusterMemberAvailability.class);
        ClusterMemberEvents clusterEvents = (ClusterMemberEvents)dependencies.satisfyDependency((Object)((ClusterMemberEvents)Proxy.newProxyInstance(ClusterMemberEvents.class.getClassLoader(), new Class[]{ClusterMemberEvents.class, Lifecycle.class}, clusterEventsDelegateInvocationHandler)));
        HighAvailabilityMemberContext memberContext = (HighAvailabilityMemberContext)Proxy.newProxyInstance(HighAvailabilityMemberContext.class.getClassLoader(), new Class[]{HighAvailabilityMemberContext.class}, memberContextDelegateInvocationHandler);
        ClusterMemberAvailability clusterMemberAvailability = (ClusterMemberAvailability)dependencies.satisfyDependency((Object)((ClusterMemberAvailability)Proxy.newProxyInstance(ClusterMemberAvailability.class.getClassLoader(), new Class[]{ClusterMemberAvailability.class}, clusterMemberAvailabilityDelegateInvocationHandler)));
        AtomicReference<HighAvailabilityMemberStateMachine> electionProviderRef = new AtomicReference<HighAvailabilityMemberStateMachine>();
        OnDiskLastTxIdGetter lastTxIdGetter = new OnDiskLastTxIdGetter(() -> ((TransactionIdStore)platformModule.dependencies.resolveDependency(TransactionIdStore.class)).getLastCommittedTransactionId());
        Object electionCredentialsProvider = (Boolean)config.get(HaSettings.slave_only) != false ? new NotElectableElectionCredentialsProvider() : new DefaultElectionCredentialsProvider((InstanceId)config.get(ClusterSettings.server_id), lastTxIdGetter, () -> ((HighAvailabilityMemberStateMachine)electionProviderRef.get()).getCurrentState());
        ObjectStreamFactory objectStreamFactory = new ObjectStreamFactory();
        ClusterClientModule clusterClientModule = new ClusterClientModule(clusteringLife, dependencies, monitors, config, logging, (ElectionCredentialsProvider)electionCredentialsProvider);
        final ClusterClient clusterClient = clusterClientModule.clusterClient;
        PaxosClusterMemberEvents localClusterEvents = new PaxosClusterMemberEvents((Snapshot)clusterClient, (Cluster)clusterClient, (Heartbeat)clusterClient, (AtomicBroadcast)clusterClient, logging.getInternalLogProvider(), item -> {
            for (MemberIsAvailable member : item.getCurrentAvailableMembers()) {
                if (!member.getRoleUri().getScheme().equals("ha") || !HighAvailabilityModeSwitcher.getServerId(member.getRoleUri()).equals(platformModule.config.get(ClusterSettings.server_id))) continue;
                logging.getInternalLog(PaxosClusterMemberEvents.class).error(String.format("Instance %s has the same serverId as ours (%s) - will not join this cluster", member.getRoleUri(), ((InstanceId)config.get(ClusterSettings.server_id)).toIntegerIndex()));
                return true;
            }
            return true;
        }, (BiFunction)new HANewSnapshotFunction(), (ObjectInputStreamFactory)objectStreamFactory, (ObjectOutputStreamFactory)objectStreamFactory, (NamedThreadFactory.Monitor)platformModule.monitors.newMonitor(NamedThreadFactory.Monitor.class, new String[0]));
        clusterClient.addClusterListener((ClusterListener)new ClusterListener.Adapter(){
            boolean hasRequestedElection = true;

            public void enteredCluster(ClusterConfiguration clusterConfiguration) {
                clusterClient.performRoleElections();
            }

            public void elected(String role, InstanceId instanceId, URI electedMember) {
                if (this.hasRequestedElection && role.equals("coordinator")) {
                    clusterClient.removeClusterListener((ClusterListener)this);
                }
            }
        });
        SimpleHighAvailabilityMemberContext localMemberContext = new SimpleHighAvailabilityMemberContext(clusterClient.getServerId(), (Boolean)config.get(HaSettings.slave_only));
        PaxosClusterMemberAvailability localClusterMemberAvailability = new PaxosClusterMemberAvailability(clusterClient.getServerId(), (BindingNotifier)clusterClient, (AtomicBroadcast)clusterClient, logging.getInternalLogProvider(), (ObjectInputStreamFactory)objectStreamFactory, (ObjectOutputStreamFactory)objectStreamFactory);
        memberContextDelegateInvocationHandler.setDelegate(localMemberContext);
        clusterEventsDelegateInvocationHandler.setDelegate((ClusterMemberEvents)localClusterEvents);
        clusterMemberAvailabilityDelegateInvocationHandler.setDelegate((ClusterMemberAvailability)localClusterMemberAvailability);
        ObservedClusterMembers observedMembers = new ObservedClusterMembers(logging.getInternalLogProvider(), (Cluster)clusterClient, (Heartbeat)clusterClient, clusterEvents, (InstanceId)config.get(ClusterSettings.server_id));
        this.memberStateMachine = new HighAvailabilityMemberStateMachine(memberContext, platformModule.availabilityGuard, observedMembers, clusterEvents, (Election)clusterClient, logging.getInternalLogProvider());
        this.members = (ClusterMembers)dependencies.satisfyDependency((Object)new ClusterMembers(observedMembers, this.memberStateMachine));
        dependencies.satisfyDependency((Object)this.memberStateMachine);
        paxosLife.add((Lifecycle)this.memberStateMachine);
        electionProviderRef.set(this.memberStateMachine);
        HighAvailabilityLogger highAvailabilityLogger = new HighAvailabilityLogger(logging.getUserLogProvider(), (InstanceId)config.get(ClusterSettings.server_id));
        platformModule.availabilityGuard.addListener((AvailabilityGuard.AvailabilityListener)highAvailabilityLogger);
        clusterEvents.addClusterMemberListener((ClusterMemberListener)highAvailabilityLogger);
        clusterClient.addClusterListener((ClusterListener)highAvailabilityLogger);
        paxosLife.add((Lifecycle)clusterEvents);
        paxosLife.add((Lifecycle)localClusterMemberAvailability);
        HaIdGeneratorFactory editionIdGeneratorFactory = (HaIdGeneratorFactory)this.createIdGeneratorFactory(masterDelegateInvocationHandler, logging.getInternalLogProvider(), requestContextFactory, fs);
        this.eligibleForIdReuse = new HaIdReuseEligibility(this.members, (Clock)platformModule.clock, idReuseSafeZone);
        this.createIdComponents(platformModule, dependencies, editionIdGeneratorFactory);
        dependencies.satisfyDependency((Object)this.idGeneratorFactory);
        dependencies.satisfyDependency((Object)this.idController);
        dependencies.satisfyDependency((Object)new IdBasedStoreEntityCounters(this.idGeneratorFactory));
        AtomicReference<HighAvailabilityModeSwitcher> exceptionHandlerRef = new AtomicReference<HighAvailabilityModeSwitcher>();
        InvalidEpochExceptionHandler invalidEpochHandler = () -> ((HighAvailabilityModeSwitcher)exceptionHandlerRef.get()).forceElections();
        Supplier logEntryReader = dependencies.provideDependency(LogEntryReader.class);
        MasterClientResolver masterClientResolver = new MasterClientResolver(logging.getInternalLogProvider(), (ResponseUnpacker)responseUnpacker, invalidEpochHandler, (int)((Duration)config.get(HaSettings.read_timeout)).toMillis(), (int)((Duration)config.get(HaSettings.lock_read_timeout)).toMillis(), (Integer)config.get(HaSettings.max_concurrent_channels_per_slave), ((Long)config.get(HaSettings.com_chunk_size)).intValue(), logEntryReader);
        LastUpdateTime lastUpdateTime = new LastUpdateTime();
        DelegateInvocationHandler<UpdatePuller> updatePullerDelegate = new DelegateInvocationHandler<UpdatePuller>(UpdatePuller.class);
        UpdatePuller updatePullerProxy = (UpdatePuller)Proxy.newProxyInstance(UpdatePuller.class.getClassLoader(), new Class[]{UpdatePuller.class}, updatePullerDelegate);
        dependencies.satisfyDependency((Object)updatePullerProxy);
        PullerFactory pullerFactory = new PullerFactory(requestContextFactory, master, lastUpdateTime, logging.getInternalLogProvider(), serverId, invalidEpochHandler, ((Duration)config.get(HaSettings.pull_interval)).toMillis(), platformModule.jobScheduler, (DependencyResolver)dependencies, platformModule.availabilityGuard, this.memberStateMachine, monitors);
        dependencies.satisfyDependency((Object)paxosLife.add((Lifecycle)pullerFactory.createObligationFulfiller(updatePullerProxy)));
        Function<Slave, SlaveServer> slaveServerFactory = slave -> new SlaveServer((Slave)slave, this.slaveServerConfig(config), logging.getInternalLogProvider(), (ByteCounterMonitor)monitors.newMonitor(ByteCounterMonitor.class, SlaveServer.class, new String[0]), (RequestMonitor)monitors.newMonitor(RequestMonitor.class, SlaveServer.class, new String[0]));
        SwitchToSlave switchToSlaveInstance = this.chooseSwitchToSlaveStrategy(platformModule, config, dependencies, logging, monitors, masterDelegateInvocationHandler, requestContextFactory, clusterMemberAvailability, masterClientResolver, updatePullerProxy, pullerFactory, slaveServerFactory, editionIdGeneratorFactory);
        Factory masterSPIFactory = () -> new DefaultMasterImplSPI((GraphDatabaseAPI)platformModule.graphDatabaseFacade, platformModule.fileSystem, platformModule.monitors, this.labelTokenHolder, this.propertyKeyTokenHolder, this.relationshipTypeTokenHolder, this.idGeneratorFactory, (TransactionCommitProcess)platformModule.dependencies.resolveDependency(TransactionCommitProcess.class), (CheckPointer)platformModule.dependencies.resolveDependency(CheckPointer.class), (TransactionIdStore)platformModule.dependencies.resolveDependency(TransactionIdStore.class), (LogicalTransactionStore)platformModule.dependencies.resolveDependency(LogicalTransactionStore.class), (NeoStoreDataSource)platformModule.dependencies.resolveDependency(NeoStoreDataSource.class), (PageCache)platformModule.dependencies.resolveDependency(PageCache.class), platformModule.storeCopyCheckPointMutex, logging.getInternalLogProvider());
        Factory conversationSPIFactory = () -> new DefaultConversationSPI(this.lockManager, platformModule.jobScheduler);
        Factory conversationManagerFactory = () -> new ConversationManager((ConversationSPI)conversationSPIFactory.newInstance(), config);
        BiFunction<ConversationManager, LifeSupport, Master> masterFactory = (conversationManager, life1) -> (MasterImpl)life1.add((Lifecycle)new MasterImpl((MasterImpl.SPI)masterSPIFactory.newInstance(), (ConversationManager)((Object)conversationManager), (MasterImpl.Monitor)monitors.newMonitor(MasterImpl.Monitor.class, MasterImpl.class, new String[0]), config));
        BiFunction<Master, ConversationManager, MasterServer> masterServerFactory = (arg_0, arg_1) -> this.lambda$new$9(platformModule, logging, config, monitors, (Supplier)logEntryReader, arg_0, arg_1);
        SwitchToMaster switchToMasterInstance = new SwitchToMaster(logging, editionIdGeneratorFactory, config, dependencies.provideDependency(SlaveFactory.class), (Factory<ConversationManager>)conversationManagerFactory, masterFactory, masterServerFactory, masterDelegateInvocationHandler, clusterMemberAvailability, platformModule.dependencies.provideDependency(NeoStoreDataSource.class));
        ComponentSwitcherContainer componentSwitcherContainer = new ComponentSwitcherContainer();
        Supplier<StoreId> storeIdSupplier = () -> ((NeoStoreDataSource)dependencies.resolveDependency(NeoStoreDataSource.class)).getStoreId();
        HighAvailabilityModeSwitcher highAvailabilityModeSwitcher = new HighAvailabilityModeSwitcher(switchToSlaveInstance, switchToMasterInstance, (Election)clusterClient, clusterMemberAvailability, clusterClient, storeIdSupplier, (InstanceId)config.get(ClusterSettings.server_id), componentSwitcherContainer, platformModule.dataSourceManager, logging);
        exceptionHandlerRef.set(highAvailabilityModeSwitcher);
        clusterClient.addBindingListener((BindingListener)highAvailabilityModeSwitcher);
        this.memberStateMachine.addHighAvailabilityMemberListener(highAvailabilityModeSwitcher);
        paxosLife.add((Lifecycle)highAvailabilityModeSwitcher);
        componentSwitcherContainer.add(new UpdatePullerSwitcher(updatePullerDelegate, pullerFactory));
        life.add((Lifecycle)requestContextFactory);
        life.add((Lifecycle)responseUnpacker);
        platformModule.diagnosticsManager.appendProvider((DiagnosticsProvider)new HighAvailabilityDiagnostics(this.memberStateMachine, clusterClient));
        dependencies.satisfyDependency((Object)SslPolicyLoader.create((Config)config, (LogProvider)logging.getInternalLogProvider()));
        this.lockManager = (Locks)dependencies.satisfyDependency((Object)this.createLockManager(componentSwitcherContainer, config, masterDelegateInvocationHandler, requestContextFactory, platformModule.availabilityGuard, (Clock)platformModule.clock, logging));
        this.statementLocksFactory = this.createStatementLocksFactory(componentSwitcherContainer, config, logging);
        this.propertyKeyTokenHolder = (PropertyKeyTokenHolder)dependencies.satisfyDependency((Object)new DelegatingPropertyKeyTokenHolder(this.createPropertyKeyCreator(config, componentSwitcherContainer, masterDelegateInvocationHandler, requestContextFactory, kernelProvider)));
        this.labelTokenHolder = (LabelTokenHolder)dependencies.satisfyDependency((Object)new DelegatingLabelTokenHolder(this.createLabelIdCreator(config, componentSwitcherContainer, masterDelegateInvocationHandler, requestContextFactory, kernelProvider)));
        this.relationshipTypeTokenHolder = (RelationshipTypeTokenHolder)dependencies.satisfyDependency((Object)new DelegatingRelationshipTypeTokenHolder(this.createRelationshipTypeCreator(config, componentSwitcherContainer, masterDelegateInvocationHandler, requestContextFactory, kernelProvider)));
        dependencies.satisfyDependency((Object)this.createKernelData(config, (GraphDatabaseAPI)platformModule.graphDatabaseFacade, this.members, fs, platformModule.pageCache, storeDir, lastUpdateTime, lastTxIdGetter, life));
        this.commitProcessFactory = this.createCommitProcessFactory(dependencies, logging, monitors, config, paxosLife, clusterClient, this.members, platformModule.jobScheduler, master, requestContextFactory, componentSwitcherContainer, logEntryReader);
        this.headerInformationFactory = this.createHeaderInformationFactory(memberContext);
        this.schemaWriteGuard = () -> {
            if (!this.memberStateMachine.isMaster()) {
                throw new InvalidTransactionTypeKernelException("Modifying the database schema can only be done on the master server, this server is a slave. Please issue schema modification commands directly to the master.");
            }
        };
        config.augment(GraphDatabaseSettings.allow_upgrade, "false");
        this.constraintSemantics = new EnterpriseConstraintSemantics();
        this.coreAPIAvailabilityGuard = new CoreAPIAvailabilityGuard(platformModule.availabilityGuard, this.transactionStartTimeout);
        this.registerRecovery(platformModule.databaseInfo, (DependencyResolver)dependencies, logging);
        UsageData usageData = (UsageData)dependencies.resolveDependency(UsageData.class);
        this.publishEditionInfo(usageData, platformModule.databaseInfo, config);
        this.publishServerId(config, usageData);
        life.add((Lifecycle)clusteringLife);
        life.add((Lifecycle)paxosLife);
        dependencies.satisfyDependency((Object)this.createSessionTracker());
    }

    public void registerEditionSpecificProcedures(Procedures procedures) throws KernelException {
        procedures.registerProcedure(EnterpriseBuiltInDbmsProcedures.class, true);
    }

    private StatementLocksFactory createStatementLocksFactory(ComponentSwitcherContainer componentSwitcherContainer, Config config, LogService logging) {
        StatementLocksFactory configuredStatementLocks = new StatementLocksFactorySelector(this.lockManager, config, logging).select();
        DelegateInvocationHandler<StatementLocksFactory> locksFactoryDelegate = new DelegateInvocationHandler<StatementLocksFactory>(StatementLocksFactory.class);
        StatementLocksFactory locksFactory = (StatementLocksFactory)Proxy.newProxyInstance(StatementLocksFactory.class.getClassLoader(), new Class[]{StatementLocksFactory.class}, locksFactoryDelegate);
        StatementLocksFactorySwitcher locksSwitcher = new StatementLocksFactorySwitcher(locksFactoryDelegate, configuredStatementLocks);
        componentSwitcherContainer.add(locksSwitcher);
        return locksFactory;
    }

    static Predicate<String> fileWatcherFileNameFilter() {
        return Predicates.any((Predicate[])new Predicate[]{fileName -> fileName.startsWith("neostore.transaction.db"), fileName -> fileName.startsWith("index.db"), filename -> filename.startsWith("branched"), filename -> filename.startsWith("temp-copy")});
    }

    private SwitchToSlave chooseSwitchToSlaveStrategy(PlatformModule platformModule, Config config, Dependencies dependencies, LogService logging, Monitors monitors, DelegateInvocationHandler<Master> masterDelegateInvocationHandler, RequestContextFactory requestContextFactory, ClusterMemberAvailability clusterMemberAvailability, MasterClientResolver masterClientResolver, UpdatePuller updatePullerProxy, PullerFactory pullerFactory, Function<Slave, SlaveServer> slaveServerFactory, HaIdGeneratorFactory idGeneratorFactory) {
        switch ((HaSettings.BranchedDataCopyingStrategy)((Object)config.get(HaSettings.branched_data_copying_strategy))) {
            case branch_then_copy: {
                return new SwitchToSlaveBranchThenCopy(platformModule.storeDir, logging, platformModule.fileSystem, config, (DependencyResolver)dependencies, idGeneratorFactory, masterDelegateInvocationHandler, clusterMemberAvailability, requestContextFactory, pullerFactory, platformModule.kernelExtensions.listFactories(), masterClientResolver, (SwitchToSlave.Monitor)monitors.newMonitor(SwitchToSlave.Monitor.class, new String[0]), (StoreCopyClient.Monitor)monitors.newMonitor(StoreCopyClient.Monitor.class, new String[0]), dependencies.provideDependency(NeoStoreDataSource.class), dependencies.provideDependency(TransactionIdStore.class), slaveServerFactory, updatePullerProxy, platformModule.pageCache, monitors, platformModule.transactionMonitor);
            }
            case copy_then_branch: {
                return new SwitchToSlaveCopyThenBranch(platformModule.storeDir, logging, platformModule.fileSystem, config, (DependencyResolver)dependencies, idGeneratorFactory, masterDelegateInvocationHandler, clusterMemberAvailability, requestContextFactory, pullerFactory, platformModule.kernelExtensions.listFactories(), masterClientResolver, (SwitchToSlave.Monitor)monitors.newMonitor(SwitchToSlave.Monitor.class, new String[0]), (StoreCopyClient.Monitor)monitors.newMonitor(StoreCopyClient.Monitor.class, new String[0]), dependencies.provideDependency(NeoStoreDataSource.class), dependencies.provideDependency(TransactionIdStore.class), slaveServerFactory, updatePullerProxy, platformModule.pageCache, monitors, platformModule.transactionMonitor);
            }
        }
        throw new RuntimeException("Unknown branched data copying strategy");
    }

    private void publishServerId(Config config, UsageData sysInfo) {
        sysInfo.set(UsageDataKeys.serverId, (Object)((InstanceId)config.get(ClusterSettings.server_id)).toString());
    }

    private TransactionHeaderInformationFactory createHeaderInformationFactory(final HighAvailabilityMemberContext memberContext) {
        return new TransactionHeaderInformationFactory.WithRandomBytes(){

            protected TransactionHeaderInformation createUsing(byte[] additionalHeader) {
                return new TransactionHeaderInformation(memberContext.getElectedMasterId().toIntegerIndex(), memberContext.getMyId().toIntegerIndex(), additionalHeader);
            }
        };
    }

    private CommitProcessFactory createCommitProcessFactory(Dependencies dependencies, LogService logging, Monitors monitors, Config config, LifeSupport paxosLife, ClusterClient clusterClient, ClusterMembers members, JobScheduler jobScheduler, Master master, RequestContextFactory requestContextFactory, ComponentSwitcherContainer componentSwitcherContainer, Supplier<LogEntryReader<ReadableClosablePositionAwareChannel>> logEntryReader) {
        DefaultSlaveFactory slaveFactory = (DefaultSlaveFactory)dependencies.satisfyDependency((Object)new DefaultSlaveFactory(logging.getInternalLogProvider(), monitors, ((Long)config.get(HaSettings.com_chunk_size)).intValue(), logEntryReader));
        HostnamePort me = (HostnamePort)config.get(ClusterSettings.cluster_server);
        Slaves slaves = (Slaves)dependencies.satisfyDependency((Object)paxosLife.add((Lifecycle)new HighAvailabilitySlaves(members, (Cluster)clusterClient, slaveFactory, me)));
        TransactionPropagator transactionPropagator = new TransactionPropagator(TransactionPropagator.from(config), logging.getInternalLog(TransactionPropagator.class), slaves, new CommitPusher(jobScheduler));
        paxosLife.add((Lifecycle)transactionPropagator);
        DelegateInvocationHandler<TransactionCommitProcess> commitProcessDelegate = new DelegateInvocationHandler<TransactionCommitProcess>(TransactionCommitProcess.class);
        CommitProcessSwitcher commitProcessSwitcher = new CommitProcessSwitcher(transactionPropagator, master, commitProcessDelegate, requestContextFactory, monitors, (DependencyResolver)dependencies);
        componentSwitcherContainer.add(commitProcessSwitcher);
        return new HighlyAvailableCommitProcessFactory(commitProcessDelegate);
    }

    private IdGeneratorFactory createIdGeneratorFactory(DelegateInvocationHandler<Master> masterDelegateInvocationHandler, LogProvider logging, RequestContextFactory requestContextFactory, FileSystemAbstraction fs) {
        HaIdGeneratorFactory idGeneratorFactory = new HaIdGeneratorFactory(masterDelegateInvocationHandler, logging, requestContextFactory, fs, this.idTypeConfigurationProvider);
        idGeneratorFactory.switchToMaster();
        return idGeneratorFactory;
    }

    private Locks createLockManager(ComponentSwitcherContainer componentSwitcherContainer, Config config, DelegateInvocationHandler<Master> masterDelegateInvocationHandler, RequestContextFactory requestContextFactory, AvailabilityGuard availabilityGuard, Clock clock, LogService logService) {
        DelegateInvocationHandler<Locks> lockManagerDelegate = new DelegateInvocationHandler<Locks>(Locks.class);
        Locks lockManager = (Locks)Proxy.newProxyInstance(Locks.class.getClassLoader(), new Class[]{Locks.class}, lockManagerDelegate);
        Factory locksFactory = () -> CommunityEditionModule.createLockManager((Config)config, (Clock)clock, (LogService)logService);
        LockManagerSwitcher lockManagerModeSwitcher = new LockManagerSwitcher(lockManagerDelegate, masterDelegateInvocationHandler, requestContextFactory, availabilityGuard, (Factory<Locks>)locksFactory, logService.getInternalLogProvider(), config);
        componentSwitcherContainer.add(lockManagerModeSwitcher);
        return lockManager;
    }

    private TokenCreator createRelationshipTypeCreator(Config config, ComponentSwitcherContainer componentSwitcherContainer, DelegateInvocationHandler<Master> masterInvocationHandler, RequestContextFactory requestContextFactory, Supplier<KernelAPI> kernelProvider) {
        if (((Boolean)config.get(GraphDatabaseSettings.read_only)).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        DelegateInvocationHandler<TokenCreator> relationshipTypeCreatorDelegate = new DelegateInvocationHandler<TokenCreator>(TokenCreator.class);
        TokenCreator relationshipTypeCreator = (TokenCreator)Proxy.newProxyInstance(TokenCreator.class.getClassLoader(), new Class[]{TokenCreator.class}, relationshipTypeCreatorDelegate);
        RelationshipTypeCreatorSwitcher typeCreatorModeSwitcher = new RelationshipTypeCreatorSwitcher(relationshipTypeCreatorDelegate, masterInvocationHandler, requestContextFactory, kernelProvider, this.idGeneratorFactory);
        componentSwitcherContainer.add(typeCreatorModeSwitcher);
        return relationshipTypeCreator;
    }

    private TokenCreator createPropertyKeyCreator(Config config, ComponentSwitcherContainer componentSwitcherContainer, DelegateInvocationHandler<Master> masterDelegateInvocationHandler, RequestContextFactory requestContextFactory, Supplier<KernelAPI> kernelProvider) {
        if (((Boolean)config.get(GraphDatabaseSettings.read_only)).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        DelegateInvocationHandler<TokenCreator> propertyKeyCreatorDelegate = new DelegateInvocationHandler<TokenCreator>(TokenCreator.class);
        TokenCreator propertyTokenCreator = (TokenCreator)Proxy.newProxyInstance(TokenCreator.class.getClassLoader(), new Class[]{TokenCreator.class}, propertyKeyCreatorDelegate);
        PropertyKeyCreatorSwitcher propertyKeyCreatorModeSwitcher = new PropertyKeyCreatorSwitcher(propertyKeyCreatorDelegate, masterDelegateInvocationHandler, requestContextFactory, kernelProvider, this.idGeneratorFactory);
        componentSwitcherContainer.add(propertyKeyCreatorModeSwitcher);
        return propertyTokenCreator;
    }

    private TokenCreator createLabelIdCreator(Config config, ComponentSwitcherContainer componentSwitcherContainer, DelegateInvocationHandler<Master> masterDelegateInvocationHandler, RequestContextFactory requestContextFactory, Supplier<KernelAPI> kernelProvider) {
        if (((Boolean)config.get(GraphDatabaseSettings.read_only)).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        DelegateInvocationHandler<TokenCreator> labelIdCreatorDelegate = new DelegateInvocationHandler<TokenCreator>(TokenCreator.class);
        TokenCreator labelIdCreator = (TokenCreator)Proxy.newProxyInstance(TokenCreator.class.getClassLoader(), new Class[]{TokenCreator.class}, labelIdCreatorDelegate);
        LabelTokenCreatorSwitcher modeSwitcher = new LabelTokenCreatorSwitcher(labelIdCreatorDelegate, masterDelegateInvocationHandler, requestContextFactory, kernelProvider, this.idGeneratorFactory);
        componentSwitcherContainer.add(modeSwitcher);
        return labelIdCreator;
    }

    private KernelData createKernelData(Config config, GraphDatabaseAPI graphDb, ClusterMembers members, FileSystemAbstraction fs, PageCache pageCache, File storeDir, LastUpdateTime lastUpdateTime, LastTxIdGetter txIdGetter, LifeSupport life) {
        ClusterDatabaseInfoProvider databaseInfo = new ClusterDatabaseInfoProvider(members, txIdGetter, lastUpdateTime);
        return (KernelData)life.add((Lifecycle)new HighlyAvailableKernelData(graphDb, members, databaseInfo, fs, pageCache, storeDir, config));
    }

    private void registerRecovery(final DatabaseInfo databaseInfo, final DependencyResolver dependencyResolver, final LogService logging) {
        this.memberStateMachine.addHighAvailabilityMemberListener(new HighAvailabilityMemberListener.Adapter(){

            @Override
            public void masterIsAvailable(HighAvailabilityMemberChangeEvent event) {
                if (event.getOldState().equals((Object)HighAvailabilityMemberState.TO_MASTER) && event.getNewState().equals((Object)HighAvailabilityMemberState.MASTER)) {
                    this.doAfterRecoveryAndStartup();
                }
            }

            @Override
            public void slaveIsAvailable(HighAvailabilityMemberChangeEvent event) {
                if (event.getOldState().equals((Object)HighAvailabilityMemberState.TO_SLAVE) && event.getNewState().equals((Object)HighAvailabilityMemberState.SLAVE)) {
                    this.doAfterRecoveryAndStartup();
                }
            }

            private void doAfterRecoveryAndStartup() {
                try {
                    HighlyAvailableEditionModule.this.doAfterRecoveryAndStartup(databaseInfo, dependencyResolver);
                    HighlyAvailableEditionModule.assureLastCommitTimestampInitialized(dependencyResolver);
                }
                catch (Throwable throwable) {
                    Log messagesLog = logging.getInternalLog(EnterpriseEditionModule.class);
                    messagesLog.error("Post recovery error", throwable);
                    try {
                        HighlyAvailableEditionModule.this.memberStateMachine.stop();
                    }
                    catch (Throwable throwable1) {
                        messagesLog.warn("Could not stop", throwable1);
                    }
                    try {
                        HighlyAvailableEditionModule.this.memberStateMachine.start();
                    }
                    catch (Throwable throwable1) {
                        messagesLog.warn("Could not start", throwable1);
                    }
                }
            }
        });
    }

    private static void assureLastCommitTimestampInitialized(DependencyResolver resolver) {
        MetaDataStore metaDataStore = (MetaDataStore)resolver.resolveDependency(MetaDataStore.class);
        LogicalTransactionStore txStore = (LogicalTransactionStore)resolver.resolveDependency(LogicalTransactionStore.class);
        TransactionId txInfo = metaDataStore.getLastCommittedTransaction();
        long lastCommitTimestampFromStore = txInfo.commitTimestamp();
        if (txInfo.transactionId() == 1L) {
            metaDataStore.setLastTransactionCommitTimestamp(0L);
            return;
        }
        if (lastCommitTimestampFromStore == 1L || lastCommitTimestampFromStore == 0L) {
            long lastCommitTimestampFromLogs;
            try {
                TransactionMetadataCache.TransactionMetadata metadata = txStore.getMetadataFor(txInfo.transactionId());
                lastCommitTimestampFromLogs = metadata.getTimeWritten();
            }
            catch (NoSuchTransactionException e) {
                lastCommitTimestampFromLogs = 1L;
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to read transaction logs", e);
            }
            metaDataStore.setLastTransactionCommitTimestamp(lastCommitTimestampFromLogs);
        }
    }

    private Server.Configuration masterServerConfig(Config config) {
        return this.commonConfig(config);
    }

    private Server.Configuration slaveServerConfig(Config config) {
        return this.commonConfig(config);
    }

    private Server.Configuration commonConfig(final Config config) {
        return new Server.Configuration(){

            public long getOldChannelThreshold() {
                return ((Duration)config.get(HaSettings.lock_read_timeout)).toMillis();
            }

            public int getMaxConcurrentTransactions() {
                return (Integer)config.get(HaSettings.max_concurrent_channels_per_slave);
            }

            public int getChunkSize() {
                return ((Long)config.get(HaSettings.com_chunk_size)).intValue();
            }

            public HostnamePort getServerAddress() {
                return (HostnamePort)config.get(HaSettings.ha_server);
            }
        };
    }

    protected BoltConnectionTracker createSessionTracker() {
        return new StandardBoltConnectionTracker();
    }

    public void setupSecurityModule(PlatformModule platformModule, Procedures procedures) {
        EnterpriseEditionModule.setupEnterpriseSecurityModule((PlatformModule)platformModule, (Procedures)procedures);
    }

    private /* synthetic */ MasterServer lambda$new$9(PlatformModule platformModule, LogService logging, Config config, Monitors monitors, Supplier logEntryReader, Master master1, ConversationManager conversationManager) {
        TransactionChecksumLookup txChecksumLookup = new TransactionChecksumLookup((TransactionIdStore)platformModule.dependencies.resolveDependency(TransactionIdStore.class), (LogicalTransactionStore)platformModule.dependencies.resolveDependency(LogicalTransactionStore.class));
        return new MasterServer(master1, logging.getInternalLogProvider(), this.masterServerConfig(config), new BranchDetectingTxVerifier(logging.getInternalLogProvider(), txChecksumLookup), (ByteCounterMonitor)monitors.newMonitor(ByteCounterMonitor.class, MasterServer.class, new String[0]), (RequestMonitor)monitors.newMonitor(RequestMonitor.class, MasterServer.class, new String[0]), conversationManager, (LogEntryReader<ReadableClosablePositionAwareChannel>)((LogEntryReader)logEntryReader.get()));
    }
}

