/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

public class ConstraintsInHAIT {
    @Rule
    public ClusterRule clusterRule = new ClusterRule(this.getClass());

    @Test
    public void creatingConstraintOnSlaveIsNotAllowed() throws Exception {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        slave.beginTx();
        try {
            ConstraintCreator constraintCreator = slave.schema().constraintFor(Label.label((String)"LabelName")).assertPropertyIsUnique("PropertyName");
            constraintCreator.create();
            Assert.fail((String)"should have thrown exception");
        }
        catch (ConstraintViolationException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"Modifying the database schema can only be done on the master server, this server is a slave. Please issue schema modification commands directly to the master."));
        }
    }
}

