/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

public class UpdatePullerSwitchIT {
    @Rule
    public final ClusterRule clusterRule = ((ClusterRule)((ClusterRule)((ClusterRule)new ClusterRule(this.getClass()).withCluster((Supplier)ClusterManager.clusterOfSize(2))).withSharedSetting(HaSettings.tx_push_factor, "0")).withSharedSetting(HaSettings.pull_interval, "100s")).withFirstInstanceId(6);

    @Test
    public void updatePullerSwitchOnNodeModeSwitch() throws Throwable {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        Label firstLabel = Label.label((String)"firstLabel");
        this.createLabeledNodeOnMaster(cluster, firstLabel);
        this.pullUpdatesOnSlave(cluster);
        this.checkLabeledNodeExistanceOnSlave(cluster, firstLabel);
        this.verifyUpdatePullerThreads(cluster);
        for (int i = 1; i <= 2; ++i) {
            ClusterManager.RepairKit repairKit = cluster.shutdown(cluster.getMaster());
            cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
            Label currentLabel = Label.label((String)("label_" + i));
            this.createLabeledNodeOnMaster(cluster, currentLabel);
            repairKit.repair();
            cluster.await(ClusterManager.allSeesAllAsAvailable(), 120L);
            this.pullUpdatesOnSlave(cluster);
            this.checkLabeledNodeExistanceOnSlave(cluster, currentLabel);
            this.verifyUpdatePullerThreads(cluster);
        }
    }

    private void verifyUpdatePullerThreads(ClusterManager.ManagedCluster cluster) {
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        Optional<Map.Entry<Thread, StackTraceElement[]>> masterEntry = this.findThreadWithPrefix(threads, "UpdatePuller@" + this.serverId(cluster.getMaster()));
        Assert.assertFalse((String)String.format("Found an update puller on master.%s", masterEntry.map(this::prettyPrint).orElse("")), (boolean)masterEntry.isPresent());
        Optional<Map.Entry<Thread, StackTraceElement[]>> slaveEntry = this.findThreadWithPrefix(threads, "UpdatePuller@" + this.serverId(cluster.getAnySlave(new HighlyAvailableGraphDatabase[0])));
        Assert.assertTrue((String)"Found no update puller on slave", (boolean)slaveEntry.isPresent());
    }

    private String prettyPrint(Map.Entry<Thread, StackTraceElement[]> entry) {
        return String.format("\n\tThread: %s\n\tStackTrace: %s", entry.getKey(), Arrays.toString(entry.getValue()));
    }

    private InstanceId serverId(HighlyAvailableGraphDatabase db) {
        return (InstanceId)((Config)db.getDependencyResolver().resolveDependency(Config.class)).get(ClusterSettings.server_id);
    }

    private Optional<Map.Entry<Thread, StackTraceElement[]>> findThreadWithPrefix(Map<Thread, StackTraceElement[]> threads, String prefix) {
        return threads.entrySet().stream().filter(entry -> ((Thread)entry.getKey()).getName().startsWith(prefix)).findFirst();
    }

    private void pullUpdatesOnSlave(ClusterManager.ManagedCluster cluster) throws InterruptedException {
        UpdatePuller updatePuller = (UpdatePuller)cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]).getDependencyResolver().resolveDependency(UpdatePuller.class);
        Assert.assertTrue((String)"We should always have some updates to pull", (boolean)updatePuller.tryPullUpdates());
    }

    private void checkLabeledNodeExistanceOnSlave(ClusterManager.ManagedCluster cluster, Label label) {
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try (Transaction transaction = slave.beginTx();){
            ResourceIterator slaveNodes = slave.findNodes(label);
            Assert.assertEquals((long)1L, (long)Iterators.asList((Iterator)slaveNodes).size());
            transaction.success();
        }
    }

    private void createLabeledNodeOnMaster(ClusterManager.ManagedCluster cluster, Label label) {
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        try (Transaction transaction = master.beginTx();){
            Node masterNode = master.createNode();
            masterNode.addLabel(label);
            transaction.success();
        }
    }
}

