/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.member;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.cluster.InstanceId;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.cluster.member.ObservedClusterMembers;
import org.neo4j.kernel.impl.store.StoreId;

public class ClusterMembersTest {
    private final ObservedClusterMembers observedClusterMembers = (ObservedClusterMembers)Mockito.mock(ObservedClusterMembers.class);
    private final HighAvailabilityMemberStateMachine stateMachine = (HighAvailabilityMemberStateMachine)Mockito.mock(HighAvailabilityMemberStateMachine.class);
    private final ClusterMembers clusterMembers = new ClusterMembers(this.observedClusterMembers, this.stateMachine);

    @Test
    public void currentInstanceStateUpdated() {
        ClusterMember currentInstance = ClusterMembersTest.createClusterMember(1, "UNKNOWN");
        Mockito.when((Object)this.observedClusterMembers.getAliveMembers()).thenReturn(Collections.singletonList(currentInstance));
        Mockito.when((Object)this.observedClusterMembers.getCurrentMember()).thenReturn((Object)currentInstance);
        Mockito.when((Object)this.stateMachine.getCurrentState()).thenReturn((Object)HighAvailabilityMemberState.MASTER);
        ClusterMember self = this.clusterMembers.getCurrentMember();
        Assert.assertEquals((Object)"master", (Object)self.getHARole());
    }

    @Test
    public void aliveMembersWithValidCurrentInstanceState() {
        ClusterMember currentInstance = ClusterMembersTest.createClusterMember(1, "UNKNOWN");
        ClusterMember otherInstance = ClusterMembersTest.createClusterMember(2, "slave");
        List<ClusterMember> members = Arrays.asList(currentInstance, otherInstance);
        Mockito.when((Object)this.observedClusterMembers.getAliveMembers()).thenReturn(members);
        Mockito.when((Object)this.observedClusterMembers.getCurrentMember()).thenReturn((Object)currentInstance);
        Mockito.when((Object)this.stateMachine.getCurrentState()).thenReturn((Object)HighAvailabilityMemberState.MASTER);
        Iterable currentMembers = this.clusterMembers.getAliveMembers();
        Assert.assertEquals((String)"Only active members should be available", (long)2L, (long)Iterables.count((Iterable)currentMembers));
        Assert.assertEquals((long)1L, (long)ClusterMembersTest.countInstancesWithRole(currentMembers, "master"));
        Assert.assertEquals((long)1L, (long)ClusterMembersTest.countInstancesWithRole(currentMembers, "slave"));
    }

    @Test
    public void observedStateDoesNotKnowCurrentInstance() {
        ClusterMember currentInstance = ClusterMembersTest.createClusterMember(1, "slave");
        ClusterMember otherInstance = ClusterMembersTest.createClusterMember(2, "master");
        List<ClusterMember> members = Arrays.asList(currentInstance, otherInstance);
        Mockito.when((Object)this.observedClusterMembers.getMembers()).thenReturn(members);
        Mockito.when((Object)this.observedClusterMembers.getCurrentMember()).thenReturn(null);
        Mockito.when((Object)this.stateMachine.getCurrentState()).thenReturn((Object)HighAvailabilityMemberState.SLAVE);
        Assert.assertNull((Object)this.clusterMembers.getCurrentMember());
        Assert.assertEquals(members, (Object)this.clusterMembers.getMembers());
    }

    @Test
    public void incorrectlyObservedCurrentInstanceStateUpdated() {
        ClusterMember currentInstance = ClusterMembersTest.createClusterMember(1, "slave");
        ClusterMember otherInstance = ClusterMembersTest.createClusterMember(2, "master");
        List<ClusterMember> members = Arrays.asList(currentInstance, otherInstance);
        Mockito.when((Object)this.observedClusterMembers.getMembers()).thenReturn(members);
        Mockito.when((Object)this.observedClusterMembers.getCurrentMember()).thenReturn((Object)currentInstance);
        Mockito.when((Object)this.stateMachine.getCurrentState()).thenReturn((Object)HighAvailabilityMemberState.MASTER);
        Iterable currentMembers = this.clusterMembers.getMembers();
        Assert.assertEquals((String)"All members should be available", (long)2L, (long)Iterables.count((Iterable)currentMembers));
        Assert.assertEquals((long)2L, (long)ClusterMembersTest.countInstancesWithRole(currentMembers, "master"));
    }

    @Test
    public void currentMemberHasCorrectRoleWhenInPendingState() {
        ClusterMember member = ClusterMembersTest.createClusterMember(1, "master");
        Mockito.when((Object)this.observedClusterMembers.getCurrentMember()).thenReturn((Object)member);
        Mockito.when((Object)this.stateMachine.getCurrentState()).thenReturn((Object)HighAvailabilityMemberState.PENDING);
        Assert.assertEquals((Object)"UNKNOWN", (Object)this.clusterMembers.getCurrentMemberRole());
    }

    @Test
    public void currentMemberHasCorrectRoleWhenInToSlaveState() {
        ClusterMember member = ClusterMembersTest.createClusterMember(1, "master");
        Mockito.when((Object)this.observedClusterMembers.getCurrentMember()).thenReturn((Object)member);
        Mockito.when((Object)this.stateMachine.getCurrentState()).thenReturn((Object)HighAvailabilityMemberState.TO_SLAVE);
        Assert.assertEquals((Object)"UNKNOWN", (Object)this.clusterMembers.getCurrentMemberRole());
    }

    @Test
    public void currentMemberHasCorrectRoleWhenInToMasterState() {
        ClusterMember member = ClusterMembersTest.createClusterMember(1, "master");
        Mockito.when((Object)this.observedClusterMembers.getCurrentMember()).thenReturn((Object)member);
        Mockito.when((Object)this.stateMachine.getCurrentState()).thenReturn((Object)HighAvailabilityMemberState.TO_MASTER);
        Assert.assertEquals((Object)"UNKNOWN", (Object)this.clusterMembers.getCurrentMemberRole());
    }

    private static int countInstancesWithRole(Iterable<ClusterMember> currentMembers, String role) {
        int counter = 0;
        for (ClusterMember clusterMember : currentMembers) {
            if (!role.equals(clusterMember.getHARole())) continue;
            ++counter;
        }
        return counter;
    }

    private static ClusterMember createClusterMember(int id, String role) {
        ClusterMember member = new ClusterMember(new InstanceId(id));
        return member.availableAs(role, null, StoreId.DEFAULT);
    }
}

