/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.ha.lock.LockStatus;
import org.neo4j.kernel.ha.lock.SlaveLocksClient;
import org.neo4j.kernel.impl.enterprise.lock.forseti.ForsetiLockManager;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.time.Clocks;

public class SlaveLocksClientConcurrentTest {
    private static ExecutorService executor;
    private Master master;
    private ForsetiLockManager lockManager;
    private RequestContextFactory requestContextFactory;
    private AvailabilityGuard availabilityGuard;

    @BeforeClass
    public static void initExecutor() {
        executor = Executors.newCachedThreadPool();
    }

    @AfterClass
    public static void closeExecutor() {
        executor.shutdownNow();
    }

    @Before
    public void setUp() {
        this.master = (Master)Mockito.mock(Master.class, (Answer)new LockedOnMasterAnswer());
        this.lockManager = new ForsetiLockManager(Config.defaults(), Clocks.systemClock(), (ResourceType[])ResourceTypes.values());
        this.requestContextFactory = (RequestContextFactory)Mockito.mock(RequestContextFactory.class);
        this.availabilityGuard = new AvailabilityGuard(Clocks.systemClock(), (Log)Mockito.mock(Log.class));
        Mockito.when((Object)this.requestContextFactory.newRequestContext(Mockito.anyInt())).thenReturn((Object)RequestContext.anonymous((long)1L));
    }

    @Test(timeout=1000L)
    public void readersCanAcquireLockAsSoonAsItReleasedOnMaster() throws InterruptedException {
        SlaveLocksClient reader = this.createClient();
        SlaveLocksClient writer = this.createClient();
        CountDownLatch readerCompletedLatch = new CountDownLatch(1);
        CountDownLatch resourceLatch = new CountDownLatch(1);
        Mockito.when((Object)this.master.endLockSession((RequestContext)ArgumentMatchers.any(RequestContext.class), ArgumentMatchers.anyBoolean())).then((Answer)new WaitLatchAnswer(resourceLatch, readerCompletedLatch));
        long nodeId = 10L;
        ResourceReader resourceReader = new ResourceReader(reader, (ResourceType)ResourceTypes.NODE, nodeId, resourceLatch, readerCompletedLatch);
        ResourceWriter resourceWriter = new ResourceWriter(writer, (ResourceType)ResourceTypes.NODE, nodeId);
        executor.submit(resourceReader);
        executor.submit(resourceWriter);
        Assert.assertTrue((String)"Reader should wait for writer to release locks before acquire", (boolean)readerCompletedLatch.await(1000L, TimeUnit.MILLISECONDS));
    }

    private SlaveLocksClient createClient() {
        return new SlaveLocksClient(this.master, this.lockManager.newClient(), (Locks)this.lockManager, this.requestContextFactory, this.availabilityGuard, (LogProvider)NullLogProvider.getInstance());
    }

    private abstract class ResourceWorker
    implements Runnable {
        protected final SlaveLocksClient locksClient;
        protected final ResourceType resourceType;
        protected final long id;

        ResourceWorker(SlaveLocksClient locksClient, ResourceType resourceType, long id) {
            this.locksClient = locksClient;
            this.resourceType = resourceType;
            this.id = id;
        }
    }

    private class ResourceReader
    extends ResourceWorker {
        private final CountDownLatch resourceLatch;
        private final CountDownLatch resourceReleaseLatch;

        ResourceReader(SlaveLocksClient locksClient, ResourceType resourceType, long id, CountDownLatch resourceLatch, CountDownLatch resourceReleaseLatch) {
            super(locksClient, resourceType, id);
            this.resourceLatch = resourceLatch;
            this.resourceReleaseLatch = resourceReleaseLatch;
        }

        @Override
        public void run() {
            try {
                this.resourceLatch.await();
                this.locksClient.acquireShared(LockTracer.NONE, this.resourceType, new long[]{this.id});
                this.resourceReleaseLatch.countDown();
                this.locksClient.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class ResourceWriter
    extends ResourceWorker {
        ResourceWriter(SlaveLocksClient locksClient, ResourceType resourceType, long id) {
            super(locksClient, resourceType, id);
        }

        @Override
        public void run() {
            this.locksClient.acquireExclusive(LockTracer.NONE, this.resourceType, new long[]{this.id});
            this.locksClient.close();
        }
    }

    private static class WaitLatchAnswer
    implements Answer<Void> {
        private final CountDownLatch resourceLatch;
        private final CountDownLatch resourceReleaseLatch;

        WaitLatchAnswer(CountDownLatch resourceLatch, CountDownLatch resourceReleaseLatch) {
            this.resourceLatch = resourceLatch;
            this.resourceReleaseLatch = resourceReleaseLatch;
        }

        public Void answer(InvocationOnMock invocation) throws Throwable {
            this.resourceLatch.countDown();
            this.resourceReleaseLatch.await();
            return null;
        }
    }

    private static class LockedOnMasterAnswer
    implements Answer {
        private final Response lockResult = (Response)Mockito.mock(Response.class);

        LockedOnMasterAnswer() {
            Mockito.when((Object)this.lockResult.response()).thenReturn((Object)new LockResult(LockStatus.OK_LOCKED));
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            return this.lockResult;
        }
    }
}

