/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.com.ComException;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.graphdb.TransientDatabaseFailureException;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.DistributedLockFailureException;
import org.neo4j.kernel.ha.lock.LocalDeadlockDetectedException;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.impl.locking.ActiveLock;
import org.neo4j.kernel.impl.locking.LockClientStoppedException;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.LockType;
import org.neo4j.kernel.impl.locking.LockWaitEvent;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.lock.AcquireLockTimeoutException;
import org.neo4j.storageengine.api.lock.ResourceType;

class SlaveLocksClient
implements Locks.Client {
    private final Master master;
    private final Locks.Client client;
    private final Locks localLockManager;
    private final RequestContextFactory requestContextFactory;
    private final AvailabilityGuard availabilityGuard;
    private final Log log;
    private boolean initialized;
    private volatile boolean stopped;

    SlaveLocksClient(Master master, Locks.Client local, Locks localLockManager, RequestContextFactory requestContextFactory, AvailabilityGuard availabilityGuard, LogProvider logProvider) {
        this.master = master;
        this.client = local;
        this.localLockManager = localLockManager;
        this.requestContextFactory = requestContextFactory;
        this.availabilityGuard = availabilityGuard;
        this.log = logProvider.getLog(this.getClass());
    }

    public void acquireShared(LockTracer tracer, ResourceType resourceType, long ... resourceIds) throws AcquireLockTimeoutException {
        this.assertNotStopped();
        long[] newResourceIds = this.firstTimeSharedLocks(resourceType, resourceIds);
        if (newResourceIds.length > 0) {
            try {
                this.acquireSharedOnMasterFiltered(tracer, resourceType, newResourceIds);
            }
            catch (Throwable failure) {
                if (resourceIds != newResourceIds) {
                    this.releaseShared(resourceType, resourceIds, newResourceIds);
                }
                throw failure;
            }
            for (long resourceId : newResourceIds) {
                if (this.client.trySharedLock(resourceType, resourceId)) continue;
                throw new LocalDeadlockDetectedException(this.client, this.localLockManager, resourceType, resourceId, LockType.READ);
            }
        }
    }

    public void acquireExclusive(LockTracer tracer, ResourceType resourceType, long ... resourceIds) throws AcquireLockTimeoutException {
        this.assertNotStopped();
        long[] newResourceIds = this.firstTimeExclusiveLocks(resourceType, resourceIds);
        if (newResourceIds.length > 0) {
            try (LockWaitEvent event = tracer.waitForLock(true, resourceType, newResourceIds);){
                this.acquireExclusiveOnMaster(resourceType, newResourceIds);
            }
            catch (Throwable failure) {
                if (resourceIds != newResourceIds) {
                    this.releaseExclusive(resourceType, resourceIds, newResourceIds);
                }
                throw failure;
            }
            for (long resourceId : newResourceIds) {
                if (this.client.tryExclusiveLock(resourceType, resourceId)) continue;
                throw new LocalDeadlockDetectedException(this.client, this.localLockManager, resourceType, resourceId, LockType.WRITE);
            }
        }
    }

    public boolean tryExclusiveLock(ResourceType resourceType, long resourceId) {
        throw this.newUnsupportedDirectTryLockUsageException();
    }

    public boolean trySharedLock(ResourceType resourceType, long resourceId) {
        throw this.newUnsupportedDirectTryLockUsageException();
    }

    public boolean reEnterShared(ResourceType resourceType, long resourceId) {
        throw new UnsupportedOperationException();
    }

    public boolean reEnterExclusive(ResourceType resourceType, long resourceId) {
        throw new UnsupportedOperationException();
    }

    public void releaseShared(ResourceType resourceType, long ... resourceIds) {
        this.assertNotStopped();
        this.client.releaseShared(resourceType, resourceIds);
    }

    public void releaseExclusive(ResourceType resourceType, long ... resourceIds) {
        this.assertNotStopped();
        this.client.releaseExclusive(resourceType, resourceIds);
    }

    public void prepare() {
        this.client.prepare();
    }

    public void stop() {
        this.client.stop();
        this.stopLockSessionOnMaster();
        this.stopped = true;
    }

    public void close() {
        this.client.close();
        if (this.initialized) {
            if (!this.stopped) {
                this.closeLockSessionOnMaster();
                this.stopped = true;
            }
            this.initialized = false;
        }
    }

    public int getLockSessionId() {
        this.assertNotStopped();
        return this.initialized ? this.client.getLockSessionId() : -1;
    }

    public Stream<? extends ActiveLock> activeLocks() {
        return this.client.activeLocks();
    }

    public long activeLockCount() {
        return this.client.activeLockCount();
    }

    void acquireDeferredSharedLocks(LockTracer tracer) {
        this.assertNotStopped();
        Map deferredLocksMap = this.client.activeLocks().filter(activeLock -> "SHARED".equals(activeLock.mode())).filter(this::isLabelOrRelationshipType).collect(Collectors.groupingBy(ActiveLock::resourceType, Collectors.mapping(ActiveLock::resourceId, Collectors.toList())));
        deferredLocksMap.forEach((type, ids) -> this.lockResourcesOnMaster(tracer, (ResourceType)type, (List<Long>)ids));
    }

    private void lockResourcesOnMaster(LockTracer tracer, ResourceType type, List<Long> ids) {
        long[] resourceIds = PrimitiveLongCollections.asArray(ids.iterator());
        try (LockWaitEvent event = tracer.waitForLock(false, type, resourceIds);){
            this.acquireSharedOnMaster(type, resourceIds);
        }
    }

    private boolean isLabelOrRelationshipType(ActiveLock activeLock) {
        return activeLock.resourceType() == ResourceTypes.LABEL || activeLock.resourceType() == ResourceTypes.RELATIONSHIP_TYPE;
    }

    private void stopLockSessionOnMaster() {
        try {
            this.endLockSessionOnMaster(false);
        }
        catch (Throwable t) {
            this.log.warn("Unable to stop lock session on master", t);
        }
    }

    private void closeLockSessionOnMaster() {
        this.endLockSessionOnMaster(true);
    }

    private void endLockSessionOnMaster(boolean success) {
        try {
            Response<Void> ignored = this.master.endLockSession(this.newRequestContextFor(this.client), success);
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        catch (ComException e) {
            throw new DistributedLockFailureException("Failed to end the lock session on the master (which implies releasing all held locks)", this.master, e);
        }
    }

    private long[] firstTimeSharedLocks(ResourceType resourceType, long[] resourceIds) {
        int cursor = 0;
        for (int i = 0; i < resourceIds.length; ++i) {
            if (this.client.reEnterShared(resourceType, resourceIds[i])) continue;
            resourceIds[cursor++] = resourceIds[i];
        }
        if (cursor == 0) {
            return PrimitiveLongCollections.EMPTY_LONG_ARRAY;
        }
        return cursor == resourceIds.length ? resourceIds : Arrays.copyOf(resourceIds, cursor);
    }

    private long[] firstTimeExclusiveLocks(ResourceType resourceType, long[] resourceIds) {
        int cursor = 0;
        for (int i = 0; i < resourceIds.length; ++i) {
            if (this.client.reEnterExclusive(resourceType, resourceIds[i])) continue;
            resourceIds[cursor++] = resourceIds[i];
        }
        if (cursor == 0) {
            return PrimitiveLongCollections.EMPTY_LONG_ARRAY;
        }
        return cursor == resourceIds.length ? resourceIds : Arrays.copyOf(resourceIds, cursor);
    }

    private void releaseShared(ResourceType resourceType, long[] resourceIds, long[] excludedIds) {
        int j = 0;
        for (int i = 0; i < resourceIds.length; ++i) {
            if (resourceIds[i] == excludedIds[j]) {
                ++j;
                continue;
            }
            this.client.releaseShared(resourceType, new long[]{resourceIds[i]});
        }
    }

    private void releaseExclusive(ResourceType resourceType, long[] resourceIds, long[] excludedIds) {
        int j = 0;
        for (int i = 0; i < resourceIds.length; ++i) {
            if (resourceIds[i] == excludedIds[j]) {
                ++j;
                continue;
            }
            this.client.releaseShared(resourceType, new long[]{resourceIds[i]});
        }
    }

    private void acquireSharedOnMasterFiltered(LockTracer lockTracer, ResourceType resourceType, long ... resourceIds) {
        if (resourceType == ResourceTypes.INDEX_ENTRY || resourceType == ResourceTypes.LABEL || resourceType == ResourceTypes.RELATIONSHIP_TYPE) {
            return;
        }
        try (LockWaitEvent event = lockTracer.waitForLock(false, resourceType, resourceIds);){
            this.acquireSharedOnMaster(resourceType, resourceIds);
        }
    }

    private void acquireSharedOnMaster(ResourceType resourceType, long[] resourceIds) {
        this.makeSureTxHasBeenInitialized();
        RequestContext requestContext = this.newRequestContextFor(this);
        try (Response<LockResult> response = this.master.acquireSharedLock(requestContext, resourceType, resourceIds);){
            this.receiveLockResponse(response);
        }
        catch (ComException e) {
            throw new DistributedLockFailureException("Cannot get shared lock(s) on master", this.master, e);
        }
    }

    private void acquireExclusiveOnMaster(ResourceType resourceType, long ... resourceIds) {
        this.makeSureTxHasBeenInitialized();
        RequestContext requestContext = this.newRequestContextFor(this);
        try (Response<LockResult> response = this.master.acquireExclusiveLock(requestContext, resourceType, resourceIds);){
            this.receiveLockResponse(response);
        }
        catch (ComException e) {
            throw new DistributedLockFailureException("Cannot get exclusive lock(s) on master", this.master, e);
        }
    }

    private void receiveLockResponse(Response<LockResult> response) {
        LockResult result = (LockResult)response.response();
        switch (result.getStatus()) {
            case DEAD_LOCKED: {
                throw new DeadlockDetectedException(result.getMessage());
            }
            case NOT_LOCKED: {
                throw new UnsupportedOperationException(result.toString());
            }
            case OK_LOCKED: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(result.toString());
            }
        }
    }

    private void makeSureTxHasBeenInitialized() {
        try {
            this.availabilityGuard.checkAvailable();
        }
        catch (AvailabilityGuard.UnavailableException e) {
            throw new TransientDatabaseFailureException("Database not available", (Throwable)e);
        }
        if (!this.initialized) {
            try {
                Response<Void> ignored = this.master.newLockSession(this.newRequestContextFor(this.client));
                Throwable throwable = null;
                if (ignored != null) {
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        ignored.close();
                    }
                }
            }
            catch (Exception exception) {
                ComException e = exception instanceof ComException ? (ComException)((Object)exception) : new ComException((Throwable)exception);
                throw new DistributedLockFailureException("Failed to start a new lock session on master", this.master, e);
            }
            this.initialized = true;
        }
    }

    private RequestContext newRequestContextFor(Locks.Client client) {
        return this.requestContextFactory.newRequestContext(client.getLockSessionId());
    }

    private void assertNotStopped() {
        if (this.stopped) {
            throw new LockClientStoppedException((Locks.Client)this);
        }
    }

    private UnsupportedOperationException newUnsupportedDirectTryLockUsageException() {
        return new UnsupportedOperationException("Distributed tryLocks are not supported. They only work with local lock managers.");
    }
}

