/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.EnterpriseGraphDatabaseFactory;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.test.rule.TestDirectory;

public class ForeignStoreIdIT {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    private GraphDatabaseService firstInstance;
    private GraphDatabaseService foreignInstance;

    @After
    public void after() throws Exception {
        if (this.foreignInstance != null) {
            this.foreignInstance.shutdown();
        }
        if (this.firstInstance != null) {
            this.firstInstance.shutdown();
        }
    }

    @Test
    public void emptyForeignDbShouldJoinAfterHavingItsEmptyDbDeleted() throws Exception {
        int firstInstanceClusterPort = PortAuthority.allocatePort();
        this.firstInstance = new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.testDirectory.directory("1")).setConfig(ClusterSettings.server_id, "1").setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + firstInstanceClusterPort).setConfig(HaSettings.ha_server, "127.0.0.1:" + PortAuthority.allocatePort()).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:" + firstInstanceClusterPort).setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
        File foreignDbStoreDir = this.createAnotherStore(this.testDirectory.directory("2"), 0);
        this.foreignInstance = new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(foreignDbStoreDir).setConfig(ClusterSettings.server_id, "2").setConfig(ClusterSettings.initial_hosts, "127.0.0.1:" + firstInstanceClusterPort).setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + PortAuthority.allocatePort()).setConfig(HaSettings.ha_server, "127.0.0.1:" + PortAuthority.allocatePort()).setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
        long foreignNode = this.createNode(this.foreignInstance, "foreigner");
        Assert.assertEquals((long)foreignNode, (long)this.findNode(this.firstInstance, "foreigner"));
    }

    @Test
    public void nonEmptyForeignDbShouldNotBeAbleToJoin() throws Exception {
        int firstInstanceClusterPort = PortAuthority.allocatePort();
        this.firstInstance = new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.testDirectory.directory("1")).setConfig(ClusterSettings.server_id, "1").setConfig(ClusterSettings.initial_hosts, "127.0.0.1:" + firstInstanceClusterPort).setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + firstInstanceClusterPort).setConfig(HaSettings.ha_server, "127.0.0.1:" + PortAuthority.allocatePort()).setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
        this.createNodes(this.firstInstance, 3, "first");
        File foreignDbStoreDir = this.createAnotherStore(this.testDirectory.directory("2"), 1);
        this.foreignInstance = new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(foreignDbStoreDir).setConfig(ClusterSettings.server_id, "2").setConfig(ClusterSettings.initial_hosts, "127.0.0.1:" + firstInstanceClusterPort).setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + PortAuthority.allocatePort()).setConfig(HaSettings.ha_server, "127.0.0.1:" + PortAuthority.allocatePort()).setConfig(HaSettings.state_switch_timeout, "5s").setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
        try {
            this.createNode(this.foreignInstance, "foreigner");
            Assert.fail((String)"Shouldn't be able to create a node, since it shouldn't have joined");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private long findNode(GraphDatabaseService db, String name) {
        try (Transaction transaction = db.beginTx();){
            for (Node node : db.getAllNodes()) {
                if (!name.equals(node.getProperty("name", null))) continue;
                long l = node.getId();
                return l;
            }
            Assert.fail((String)("Didn't find node '" + name + "' in " + db));
            long l = -1L;
            return l;
        }
    }

    private File createAnotherStore(File directory, int transactions) {
        GraphDatabaseService db = new EnterpriseGraphDatabaseFactory().newEmbeddedDatabaseBuilder(directory).setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
        this.createNodes(db, transactions, "node");
        db.shutdown();
        return directory;
    }

    private void createNodes(GraphDatabaseService db, int transactions, String prefix) {
        for (int i = 0; i < transactions; ++i) {
            this.createNode(db, prefix + i);
        }
    }

    private long createNode(GraphDatabaseService db, String name) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            node.setProperty("name", (Object)name);
            tx.success();
            long l = node.getId();
            return l;
        }
    }
}

