/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.com.RequestContext;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.TransactionStreamResponse;
import org.neo4j.kernel.ha.AbstractTokenCreator;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;

public class AbstractTokenCreatorTest {
    private final Master master = (Master)Mockito.mock(Master.class);
    private final RequestContextFactory requestContextFactory = (RequestContextFactory)Mockito.mock(RequestContextFactory.class);
    private final RequestContext context = new RequestContext(1L, 2, 3, 4L, 5L);
    private final String label = "A";
    private final Response<Integer> response = new TransactionStreamResponse((Object)42, null, null, ResourceReleaser.NO_OP);
    private final AbstractTokenCreator creator = new AbstractTokenCreator(this.master, this.requestContextFactory){

        protected Response<Integer> create(Master master, RequestContext context, String name) {
            Assert.assertEquals((Object)AbstractTokenCreatorTest.this.master, (Object)master);
            Assert.assertEquals((Object)AbstractTokenCreatorTest.this.context, (Object)context);
            Assert.assertEquals((Object)"A", (Object)name);
            return AbstractTokenCreatorTest.this.response;
        }
    };

    @Before
    public void setup() {
        Mockito.when((Object)this.requestContextFactory.newRequestContext()).thenReturn((Object)this.context);
    }

    @Test
    public void shouldCreateALabelOnMasterAndApplyItLocally() {
        int responseValue = (Integer)this.response.response();
        int result = this.creator.getOrCreate("A");
        Assert.assertEquals((long)responseValue, (long)result);
    }

    @Test
    public void shouldThrowIfCreateThrowsAnException() {
        RuntimeException re = new RuntimeException("IO");
        AbstractTokenCreator throwingCreator = (AbstractTokenCreator)Mockito.spy((Object)this.creator);
        ((AbstractTokenCreator)Mockito.doThrow((Throwable[])new Throwable[]{re}).when((Object)throwingCreator)).create((Master)ArgumentMatchers.any(Master.class), (RequestContext)ArgumentMatchers.any(RequestContext.class), ArgumentMatchers.anyString());
        try {
            throwingCreator.getOrCreate("A");
            Assert.fail((String)"Should have thrown");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)re, (Object)e);
        }
    }
}

