/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.lock.trace.LockRecord;
import org.neo4j.kernel.ha.lock.trace.RecordingLockTracer;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.test.ha.ClusterRule;

public class SlaveStatementLocksFactoryIT {
    private static final Label testLabel = Label.label((String)"testLabel");
    private static final String testProperty = "testProperty";
    @Rule
    public final ClusterRule clusterRule = ((ClusterRule)new ClusterRule().withSharedSetting(GraphDatabaseFacadeFactory.Configuration.tracer, "slaveLocksTracer")).withSharedSetting(HaSettings.tx_push_factor, "2");
    private ClusterManager.ManagedCluster managedCluster;

    @Before
    public void setUp() throws Exception {
        this.managedCluster = this.clusterRule.startCluster();
    }

    @Test
    public void acquireSharedLocksDuringSlaveWriteTx() {
        HighlyAvailableGraphDatabase anySlave = this.managedCluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase master = this.managedCluster.getMaster();
        this.createSingleTestLabeledNode(master);
        LockRecord sharedLabelLock = LockRecord.of(false, (ResourceType)ResourceTypes.LABEL, 0L);
        List<LockRecord> requestedLocks = this.getRequestedLocks(anySlave);
        Assert.assertFalse((boolean)requestedLocks.contains(sharedLabelLock));
        this.createSingleTestLabeledNode(anySlave);
        Assert.assertTrue((boolean)requestedLocks.contains(sharedLabelLock));
    }

    @Test
    public void doNotAcquireSharedLocksDuringSlaveReadTx() {
        HighlyAvailableGraphDatabase anySlave = this.managedCluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase master = this.managedCluster.getMaster();
        try (Transaction tx = master.beginTx();){
            Node node = master.createNode(new Label[]{testLabel});
            node.setProperty(testProperty, (Object)"a");
            tx.success();
        }
        this.createIndex(master, testLabel, testProperty);
        var4_4 = null;
        try (Transaction transaction = anySlave.beginTx();){
            Assert.assertEquals((long)1L, (long)Iterables.count((Iterable)anySlave.schema().getIndexes(testLabel)));
            transaction.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        Assert.assertTrue((boolean)this.getRequestedLocks(anySlave).isEmpty());
    }

    private void createSingleTestLabeledNode(HighlyAvailableGraphDatabase master) {
        try (Transaction tx = master.beginTx();){
            master.createNode(new Label[]{testLabel});
            tx.success();
        }
    }

    private void createIndex(HighlyAvailableGraphDatabase master, Label label, String property) {
        try (Transaction transaction = master.beginTx();){
            master.schema().indexFor(label).on(property).create();
            transaction.success();
        }
        transaction = master.beginTx();
        var5_5 = null;
        try {
            master.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            transaction.success();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var5_5 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    private List<LockRecord> getRequestedLocks(HighlyAvailableGraphDatabase master) {
        Tracers tracers = (Tracers)master.getDependencyResolver().resolveDependency(Tracers.class);
        RecordingLockTracer lockTracer = (RecordingLockTracer)tracers.lockTracer;
        return lockTracer.getRequestedLocks();
    }
}

