/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.internal.KernelData;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.test.ManagedResource;
import org.neo4j.test.rule.TestDirectory;

public class HaKernelDataIT {
    @Rule
    public final ManagedResource<HighlyAvailableGraphDatabase> ha = new ManagedResource<HighlyAvailableGraphDatabase>(){

        @Override
        protected HighlyAvailableGraphDatabase createResource(TestDirectory dir) throws Exception {
            int clusterPort = PortAuthority.allocatePort();
            return (HighlyAvailableGraphDatabase)new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(dir.directory().getAbsoluteFile()).setConfig(ClusterSettings.server_id, "1").setConfig(ClusterSettings.cluster_server, "127.0.0.1:" + clusterPort).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:" + clusterPort).setConfig(HaSettings.ha_server, "127.0.0.1:" + PortAuthority.allocatePort()).setConfig(OnlineBackupSettings.online_backup_enabled, Boolean.FALSE.toString()).newGraphDatabase();
        }

        @Override
        protected void disposeResource(HighlyAvailableGraphDatabase resource) {
            resource.shutdown();
        }
    };

    @Test
    public void shouldReturnHaGraphDbFromKernelData() throws Exception {
        HighlyAvailableGraphDatabase haGraphDb = this.ha.getResource();
        KernelData kernelData = (KernelData)haGraphDb.getDependencyResolver().resolveDependency(KernelData.class);
        Assert.assertSame((Object)kernelData.graphDatabase(), (Object)haGraphDb);
    }
}

