/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.neo4j.com.ObjectSerializer;
import org.neo4j.com.RequestType;
import org.neo4j.com.TargetCaller;
import org.neo4j.kernel.ha.HaRequestType;
import org.neo4j.kernel.ha.HaRequestTypes;
import org.neo4j.kernel.ha.com.master.Master;

abstract class AbstractHaRequestTypes
implements HaRequestTypes {
    private final HaRequestType[] types = new HaRequestType[HaRequestTypes.Type.values().length];

    AbstractHaRequestTypes() {
    }

    protected <A, B, C> void register(HaRequestTypes.Type type, TargetCaller<A, B> targetCaller, ObjectSerializer<C> objectSerializer) {
        this.register(type, targetCaller, objectSerializer, true);
    }

    protected <A, B, C> void register(HaRequestTypes.Type type, TargetCaller<A, B> targetCaller, ObjectSerializer<C> objectSerializer, boolean unpack) {
        assert (this.types[type.ordinal()] == null);
        this.types[type.ordinal()] = new HaRequestType(targetCaller, objectSerializer, (byte)type.ordinal(), unpack);
    }

    @Override
    public RequestType<Master> type(HaRequestTypes.Type type) {
        return this.type((byte)type.ordinal());
    }

    @Override
    public RequestType<Master> type(byte id) {
        HaRequestType requestType = this.types[id];
        if (requestType == null) {
            throw new UnsupportedOperationException("Not used anymore, merely here to keep the ordinal ids of the others");
        }
        return requestType;
    }
}

