/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.ha;

import java.net.URI;
import java.util.Objects;
import java.util.function.BiFunction;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.paxos.MemberIsAvailable;
import org.neo4j.cluster.member.paxos.PaxosClusterMemberEvents;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.ha.cluster.HANewSnapshotFunction;
import org.neo4j.kernel.impl.store.StoreId;

public class ClusterMembersSnapshotTest {
    private static final String URI = "http://me";

    @Test
    public void snapshotListPrunesSameMemberOnIdenticalAvailabilityEvents() throws Exception {
        PaxosClusterMemberEvents.ClusterMembersSnapshot snapshot = new PaxosClusterMemberEvents.ClusterMembersSnapshot((BiFunction)new PaxosClusterMemberEvents.UniqueRoleFilter());
        URI clusterUri = new URI(URI);
        InstanceId instanceId = new InstanceId(1);
        MemberIsAvailable memberIsAvailable = new MemberIsAvailable("master", instanceId, clusterUri, new URI("http://me?something"), StoreId.DEFAULT);
        snapshot.availableMember(memberIsAvailable);
        snapshot.availableMember(memberIsAvailable);
        Assert.assertEquals((long)1L, (long)Iterables.count((Iterable)snapshot.getCurrentAvailable(instanceId)));
        Assert.assertThat((Object)snapshot.getCurrentAvailable(instanceId), (Matcher)CoreMatchers.hasItem(ClusterMembersSnapshotTest.memberIsAvailable(memberIsAvailable)));
        Assert.assertEquals((long)1L, (long)Iterables.count((Iterable)snapshot.getCurrentAvailableMembers()));
        Assert.assertThat((Object)snapshot.getCurrentAvailableMembers(), (Matcher)CoreMatchers.hasItems((Matcher[])new Matcher[]{ClusterMembersSnapshotTest.memberIsAvailable(memberIsAvailable)}));
    }

    @Test
    public void snapshotListShouldContainOnlyOneEventForARoleWithTheSameIdWhenSwitchingFromMasterToSlave() throws Exception {
        PaxosClusterMemberEvents.ClusterMembersSnapshot snapshot = new PaxosClusterMemberEvents.ClusterMembersSnapshot((BiFunction)new HANewSnapshotFunction());
        URI clusterUri = new URI(URI);
        InstanceId instanceId = new InstanceId(1);
        MemberIsAvailable event1 = new MemberIsAvailable("master", instanceId, clusterUri, new URI("http://me?something"), StoreId.DEFAULT);
        snapshot.availableMember(event1);
        MemberIsAvailable event2 = new MemberIsAvailable("slave", instanceId, clusterUri, new URI("http://me?something"), StoreId.DEFAULT);
        snapshot.availableMember(event2);
        Assert.assertEquals((long)1L, (long)Iterables.count((Iterable)snapshot.getCurrentAvailable(instanceId)));
        Assert.assertThat((Object)snapshot.getCurrentAvailable(instanceId), (Matcher)CoreMatchers.hasItems((Matcher[])new Matcher[]{ClusterMembersSnapshotTest.memberIsAvailable(event2)}));
        Assert.assertEquals((long)1L, (long)Iterables.count((Iterable)snapshot.getCurrentAvailableMembers()));
        Assert.assertThat((Object)snapshot.getCurrentAvailableMembers(), (Matcher)CoreMatchers.hasItems((Matcher[])new Matcher[]{ClusterMembersSnapshotTest.memberIsAvailable(event2)}));
    }

    @Test
    public void snapshotListShouldContainOnlyOneEventForARoleWithTheSameIdWhenSwitchingFromSlaveToMaster() throws Exception {
        PaxosClusterMemberEvents.ClusterMembersSnapshot snapshot = new PaxosClusterMemberEvents.ClusterMembersSnapshot((BiFunction)new HANewSnapshotFunction());
        URI clusterUri = new URI(URI);
        InstanceId instanceId = new InstanceId(1);
        MemberIsAvailable event1 = new MemberIsAvailable("slave", instanceId, clusterUri, new URI("http://me?something"), StoreId.DEFAULT);
        snapshot.availableMember(event1);
        MemberIsAvailable event2 = new MemberIsAvailable("master", instanceId, clusterUri, new URI("http://me?something"), StoreId.DEFAULT);
        snapshot.availableMember(event2);
        Assert.assertEquals((long)1L, (long)Iterables.count((Iterable)snapshot.getCurrentAvailable(instanceId)));
        Assert.assertThat((Object)snapshot.getCurrentAvailable(instanceId), (Matcher)CoreMatchers.hasItems((Matcher[])new Matcher[]{ClusterMembersSnapshotTest.memberIsAvailable(event2)}));
        Assert.assertEquals((long)1L, (long)Iterables.count((Iterable)snapshot.getCurrentAvailableMembers()));
        Assert.assertThat((Object)snapshot.getCurrentAvailableMembers(), (Matcher)CoreMatchers.hasItems((Matcher[])new Matcher[]{ClusterMembersSnapshotTest.memberIsAvailable(event2)}));
    }

    @Test
    public void snapshotListPrunesOtherMemberWithSameMasterRole() throws Exception {
        PaxosClusterMemberEvents.ClusterMembersSnapshot snapshot = new PaxosClusterMemberEvents.ClusterMembersSnapshot((BiFunction)new HANewSnapshotFunction());
        URI clusterUri = new URI(URI);
        InstanceId instanceId = new InstanceId(1);
        MemberIsAvailable event = new MemberIsAvailable("master", instanceId, clusterUri, new URI("http://me?something1"), StoreId.DEFAULT);
        snapshot.availableMember(event);
        URI otherClusterUri = new URI(URI);
        InstanceId otherInstanceId = new InstanceId(2);
        MemberIsAvailable otherEvent = new MemberIsAvailable("master", otherInstanceId, otherClusterUri, new URI("http://me?something2"), StoreId.DEFAULT);
        snapshot.availableMember(otherEvent);
        Assert.assertEquals((long)1L, (long)Iterables.count((Iterable)snapshot.getCurrentAvailable(otherInstanceId)));
        Assert.assertThat((Object)snapshot.getCurrentAvailable(otherInstanceId), (Matcher)CoreMatchers.hasItems((Matcher[])new Matcher[]{ClusterMembersSnapshotTest.memberIsAvailable(otherEvent)}));
        Assert.assertEquals((long)1L, (long)Iterables.count((Iterable)snapshot.getCurrentAvailableMembers()));
        Assert.assertThat((Object)snapshot.getCurrentAvailableMembers(), (Matcher)CoreMatchers.hasItems((Matcher[])new Matcher[]{ClusterMembersSnapshotTest.memberIsAvailable(otherEvent)}));
    }

    @Test
    public void snapshotListDoesNotPruneOtherMemberWithSlaveRole() throws Exception {
        PaxosClusterMemberEvents.ClusterMembersSnapshot snapshot = new PaxosClusterMemberEvents.ClusterMembersSnapshot((BiFunction)new HANewSnapshotFunction());
        URI clusterUri = new URI(URI);
        InstanceId instanceId = new InstanceId(1);
        MemberIsAvailable event = new MemberIsAvailable("slave", instanceId, clusterUri, new URI("http://me?something1"), StoreId.DEFAULT);
        snapshot.availableMember(event);
        URI otherClusterUri = new URI(URI);
        InstanceId otherInstanceId = new InstanceId(2);
        MemberIsAvailable otherEvent = new MemberIsAvailable("slave", otherInstanceId, otherClusterUri, new URI("http://me?something2"), StoreId.DEFAULT);
        snapshot.availableMember(otherEvent);
        Assert.assertEquals((long)2L, (long)Iterables.count((Iterable)snapshot.getCurrentAvailableMembers()));
        Assert.assertThat((Object)snapshot.getCurrentAvailableMembers(), (Matcher)CoreMatchers.hasItems((Matcher[])new Matcher[]{ClusterMembersSnapshotTest.memberIsAvailable(event), ClusterMembersSnapshotTest.memberIsAvailable(otherEvent)}));
    }

    private static Matcher<MemberIsAvailable> memberIsAvailable(final MemberIsAvailable expected) {
        return new BaseMatcher<MemberIsAvailable>(){

            public boolean matches(Object item) {
                MemberIsAvailable input = (MemberIsAvailable)item;
                return Objects.equals(input.getClusterUri(), expected.getClusterUri()) && Objects.equals(input.getRole(), expected.getRole()) && Objects.equals(input.getRoleUri(), expected.getRoleUri());
            }

            public void describeTo(Description description) {
            }
        };
    }
}

