/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.com.ComException;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.GraphDatabaseServiceCleaner;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.ha.ClusterRule;
import org.neo4j.test.rule.RepeatRule;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.concurrent.OtherThreadRule;

@RunWith(value=Parameterized.class)
public class PropertyConstraintsStressIT {
    @Parameterized.Parameter
    public ConstraintOperations constraintOps;
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @ClassRule
    public static final ClusterRule clusterRule = new ClusterRule();
    @Rule
    public OtherThreadRule<Object> slaveWork = new OtherThreadRule();
    @Rule
    public OtherThreadRule<Object> masterWork = new OtherThreadRule();
    @Rule
    public RepeatRule repeater = new RepeatRule();
    protected ClusterManager.ManagedCluster cluster;
    private final int REPETITIONS = 1;
    private static long runtime = Long.getLong("neo4j.PropertyConstraintsStressIT.runtime", TimeUnit.SECONDS.toMillis(10L));
    private volatile String labelOrRelType = "Foo";
    private volatile String property;
    private final AtomicInteger roundNo = new AtomicInteger(0);
    private static final ConstraintOperations UNIQUE_PROPERTY_CONSTRAINT_OPS = new ConstraintOperations(){

        @Override
        public void createEntity(HighlyAvailableGraphDatabase db, String type, String propertyKey, Object value, boolean constraintComplient) {
            db.createNode(new Label[]{Label.label((String)type)}).setProperty(propertyKey, value);
        }

        @Override
        public boolean isValid(HighlyAvailableGraphDatabase db, String type, String property) {
            try (Transaction tx = db.beginTx();){
                HashSet<Object> values = new HashSet<Object>();
                try (ResourceIterator nodes = db.findNodes(Label.label((String)type));){
                    for (Node node : Iterators.loop((Iterator)nodes)) {
                        Object value = node.getProperty(property);
                        if (values.contains(value)) {
                            boolean bl = false;
                            return bl;
                        }
                        values.add(value);
                    }
                }
                tx.success();
            }
            return true;
        }

        @Override
        public OtherThreadExecutor.WorkerCommand<Object, Boolean> createConstraint(HighlyAvailableGraphDatabase db, String type, String property) {
            return state -> {
                boolean constraintCreationFailed = false;
                try (Transaction tx = db.beginTx();){
                    db.schema().constraintFor(Label.label((String)type)).assertPropertyIsUnique(property).create();
                    tx.success();
                }
                catch (ConstraintViolationException e) {
                    constraintCreationFailed = true;
                }
                return constraintCreationFailed;
            };
        }

        public String toString() {
            return "UNIQUE_PROPERTY_CONSTRAINT";
        }
    };
    private static final ConstraintOperations NODE_PROPERTY_EXISTENCE_CONSTRAINT_OPS = new ConstraintOperations(){

        @Override
        public void createEntity(HighlyAvailableGraphDatabase db, String type, String propertyKey, Object value, boolean constraintCompliant) {
            Node node = db.createNode(new Label[]{Label.label((String)type)});
            if (constraintCompliant) {
                node.setProperty(propertyKey, value);
            }
        }

        @Override
        public boolean isValid(HighlyAvailableGraphDatabase db, String type, String property) {
            try (Transaction tx = db.beginTx();){
                for (Node node : Iterators.loop((Iterator)db.findNodes(Label.label((String)type)))) {
                    if (node.hasProperty(property)) continue;
                    boolean bl = false;
                    return bl;
                }
                tx.success();
            }
            return true;
        }

        @Override
        public OtherThreadExecutor.WorkerCommand<Object, Boolean> createConstraint(HighlyAvailableGraphDatabase db, String type, String property) {
            String query = String.format("CREATE CONSTRAINT ON (n:`%s`) ASSERT exists(n.`%s`)", type, property);
            return PropertyConstraintsStressIT.createPropertyExistenceConstraintCommand((GraphDatabaseService)db, query);
        }

        public String toString() {
            return "NODE_PROPERTY_EXISTENCE_CONSTRAINT";
        }
    };
    private static final ConstraintOperations REL_PROPERTY_EXISTENCE_CONSTRAINT_OPS = new ConstraintOperations(){

        @Override
        public void createEntity(HighlyAvailableGraphDatabase db, String type, String propertyKey, Object value, boolean constraintCompliant) {
            Node start = db.createNode();
            Node end = db.createNode();
            Relationship relationship = start.createRelationshipTo(end, RelationshipType.withName((String)type));
            if (constraintCompliant) {
                relationship.setProperty(propertyKey, value);
            }
        }

        @Override
        public boolean isValid(HighlyAvailableGraphDatabase db, String type, String property) {
            try (Transaction tx = db.beginTx();){
                for (Relationship relationship : db.getAllRelationships()) {
                    if (!relationship.getType().name().equals(type) || relationship.hasProperty(property)) continue;
                    boolean bl = false;
                    return bl;
                }
                tx.success();
            }
            return true;
        }

        @Override
        public OtherThreadExecutor.WorkerCommand<Object, Boolean> createConstraint(HighlyAvailableGraphDatabase db, String type, String property) {
            String query = String.format("CREATE CONSTRAINT ON ()-[r:`%s`]-() ASSERT exists(r.`%s`)", type, property);
            return PropertyConstraintsStressIT.createPropertyExistenceConstraintCommand((GraphDatabaseService)db, query);
        }

        public String toString() {
            return "RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT";
        }
    };

    @Parameterized.Parameters(name="{0}:{1}")
    public static Iterable<ConstraintOperations> params() {
        return Arrays.asList(UNIQUE_PROPERTY_CONSTRAINT_OPS, UNIQUE_PROPERTY_CONSTRAINT_OPS, NODE_PROPERTY_EXISTENCE_CONSTRAINT_OPS, REL_PROPERTY_EXISTENCE_CONSTRAINT_OPS);
    }

    @Before
    public void setup() {
        this.cluster = ((ClusterRule)clusterRule.withSharedSetting(HaSettings.pull_interval, "0")).startCluster();
        this.clearData();
    }

    private void clearData() {
        HighlyAvailableGraphDatabase db = this.cluster.getMaster();
        GraphDatabaseServiceCleaner.cleanDatabaseContent((GraphDatabaseService)db);
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
    }

    @RepeatRule.Repeat(times=1)
    @Test
    public void shouldNotAllowConstraintsViolationsUnderStress_A() throws Exception {
        this.shouldNotAllowConstraintsViolationsUnderStress(new Operation(){

            @Override
            void perform() {
                this.constraintCreation = PropertyConstraintsStressIT.this.masterWork.execute(PropertyConstraintsStressIT.this.createConstraint(this.master));
                this.constraintViolation = PropertyConstraintsStressIT.this.slaveWork.execute(PropertyConstraintsStressIT.this.performConstraintViolatingInserts(this.slave));
            }
        });
    }

    @RepeatRule.Repeat(times=1)
    @Test
    public void shouldNotAllowConstraintsViolationsUnderStress_B() throws Exception {
        this.shouldNotAllowConstraintsViolationsUnderStress(new Operation(){

            @Override
            void perform() {
                this.constraintViolation = PropertyConstraintsStressIT.this.slaveWork.execute(PropertyConstraintsStressIT.this.performConstraintViolatingInserts(this.slave));
                this.constraintCreation = PropertyConstraintsStressIT.this.masterWork.execute(PropertyConstraintsStressIT.this.createConstraint(this.master));
            }
        });
    }

    @RepeatRule.Repeat(times=1)
    @Test
    public void shouldNotAllowConstraintsViolationsUnderStress_C() throws Exception {
        this.shouldNotAllowConstraintsViolationsUnderStress(new Operation(){

            @Override
            void perform() {
                this.constraintCreation = PropertyConstraintsStressIT.this.masterWork.execute(PropertyConstraintsStressIT.this.createConstraint(this.master));
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.constraintViolation = PropertyConstraintsStressIT.this.slaveWork.execute(PropertyConstraintsStressIT.this.performConstraintViolatingInserts(this.slave));
            }
        });
    }

    @RepeatRule.Repeat(times=1)
    @Test
    public void shouldNotAllowConstraintsViolationsUnderStress_D() throws Exception {
        this.shouldNotAllowConstraintsViolationsUnderStress(new Operation(){

            @Override
            void perform() {
                this.constraintViolation = PropertyConstraintsStressIT.this.slaveWork.execute(PropertyConstraintsStressIT.this.performConstraintViolatingInserts(this.slave));
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.constraintCreation = PropertyConstraintsStressIT.this.masterWork.execute(PropertyConstraintsStressIT.this.createConstraint(this.master));
            }
        });
    }

    @RepeatRule.Repeat(times=1)
    @Test
    public void shouldNotAllowConstraintsViolationsUnderStress_E() throws Exception {
        this.shouldNotAllowConstraintsViolationsUnderStress(new Operation(){

            @Override
            void perform() {
                this.constraintCreation = PropertyConstraintsStressIT.this.masterWork.execute(PropertyConstraintsStressIT.this.createConstraint(this.master));
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.constraintViolation = PropertyConstraintsStressIT.this.slaveWork.execute(PropertyConstraintsStressIT.this.performConstraintViolatingInserts(this.slave));
            }
        });
    }

    @RepeatRule.Repeat(times=1)
    @Test
    public void shouldNotAllowConstraintsViolationsUnderStress_F() throws Exception {
        this.shouldNotAllowConstraintsViolationsUnderStress(new Operation(){

            @Override
            void perform() {
                this.constraintViolation = PropertyConstraintsStressIT.this.slaveWork.execute(PropertyConstraintsStressIT.this.performConstraintViolatingInserts(this.slave));
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.constraintCreation = PropertyConstraintsStressIT.this.masterWork.execute(PropertyConstraintsStressIT.this.createConstraint(this.master));
            }
        });
    }

    public void shouldNotAllowConstraintsViolationsUnderStress(Operation ops) throws Exception {
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        long end = System.currentTimeMillis() + runtime;
        int successfulAttempts = 0;
        while (end > System.currentTimeMillis()) {
            this.setLabelAndPropertyForNextRound();
            this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
            try {
                this.slaveWork.execute(this.performConstraintCompliantInserts(slave)).get();
            }
            catch (ExecutionException e) {
                if (Exceptions.contains((Throwable)e, (String)"could not connect", (Class[])new Class[]{ComException.class})) continue;
            }
            ops.perform();
            this.assertConstraintsNotViolated(ops.constraintCreation, ops.constraintViolation, master);
            ++successfulAttempts;
        }
        Assert.assertThat((Object)successfulAttempts, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    private void assertConstraintsNotViolated(Future<Boolean> constraintCreation, Future<Integer> constraintViolation, HighlyAvailableGraphDatabase master) throws InterruptedException, ExecutionException {
        boolean constraintCreationFailed = constraintCreation.get();
        int txSuccessCount = constraintViolation.get();
        if (constraintCreationFailed) {
            Assert.assertThat((Object)txSuccessCount, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            Assert.assertThat((Object)this.constraintOps.isValid(master, this.labelOrRelType, this.property), (Matcher)Matchers.equalTo((Object)false));
        } else {
            Assert.assertThat((Object)txSuccessCount, (Matcher)Matchers.equalTo((Object)0));
            Assert.assertThat((Object)this.constraintOps.isValid(master, this.labelOrRelType, this.property), (Matcher)Matchers.equalTo((Object)true));
        }
    }

    private OtherThreadExecutor.WorkerCommand<Object, Boolean> createConstraint(HighlyAvailableGraphDatabase master) {
        return this.constraintOps.createConstraint(master, this.labelOrRelType, this.property);
    }

    private OtherThreadExecutor.WorkerCommand<Object, Integer> performConstraintCompliantInserts(HighlyAvailableGraphDatabase slave) {
        return this.performInserts(slave, true);
    }

    private OtherThreadExecutor.WorkerCommand<Object, Integer> performConstraintViolatingInserts(HighlyAvailableGraphDatabase slave) {
        return this.performInserts(slave, false);
    }

    private OtherThreadExecutor.WorkerCommand<Object, Integer> performInserts(HighlyAvailableGraphDatabase slave, boolean constraintCompliant) {
        return state -> {
            int i;
            try {
                for (i = 0; i < 100; ++i) {
                    try (Transaction tx = slave.beginTx();){
                        this.constraintOps.createEntity(slave, this.labelOrRelType, this.property, "value" + i, constraintCompliant);
                        tx.success();
                        continue;
                    }
                }
            }
            catch (ComException | ConstraintViolationException | TransactionFailureException | TransientTransactionFailureException throwable) {
                // empty catch block
            }
            return i;
        };
    }

    private void setLabelAndPropertyForNextRound() {
        this.property = "Key-" + this.roundNo.incrementAndGet();
        this.labelOrRelType = "Foo-" + this.roundNo.get();
    }

    private static OtherThreadExecutor.WorkerCommand<Object, Boolean> createPropertyExistenceConstraintCommand(GraphDatabaseService db, String query) {
        return state -> {
            boolean constraintCreationFailed = false;
            try (Transaction tx = db.beginTx();){
                db.execute(query);
                tx.success();
            }
            catch (QueryExecutionException e) {
                if (Exceptions.rootCause((Throwable)e) instanceof ConstraintValidationException) {
                    constraintCreationFailed = true;
                }
                throw e;
            }
            return constraintCreationFailed;
        };
    }

    static interface ConstraintOperations {
        public void createEntity(HighlyAvailableGraphDatabase var1, String var2, String var3, Object var4, boolean var5);

        public boolean isValid(HighlyAvailableGraphDatabase var1, String var2, String var3);

        public OtherThreadExecutor.WorkerCommand<Object, Boolean> createConstraint(HighlyAvailableGraphDatabase var1, String var2, String var3);
    }

    private abstract class Operation {
        HighlyAvailableGraphDatabase master;
        HighlyAvailableGraphDatabase slave;
        Future<Boolean> constraintCreation;
        Future<Integer> constraintViolation;

        private Operation() {
            this.master = PropertyConstraintsStressIT.this.cluster.getMaster();
            this.slave = PropertyConstraintsStressIT.this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        }

        abstract void perform();
    }
}

