/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.factory;

import java.util.function.Predicate;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.ha.factory.HighlyAvailableEditionModule;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.BufferedIdController;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.IdController;
import org.neo4j.kernel.impl.store.StoreFile;
import org.neo4j.kernel.impl.store.id.BufferingIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.test.ha.ClusterRule;

public class HighlyAvailableEditionModuleIT {
    @Rule
    public ClusterRule clusterRule = new ClusterRule();

    @Test
    public void createBufferedIdComponentsByDefault() {
        ClusterManager.ManagedCluster managedCluster = this.clusterRule.startCluster();
        DependencyResolver dependencyResolver = managedCluster.getMaster().getDependencyResolver();
        IdController idController = (IdController)dependencyResolver.resolveDependency(IdController.class);
        IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)dependencyResolver.resolveDependency(IdGeneratorFactory.class);
        Assert.assertThat((Object)idController, (Matcher)Matchers.instanceOf(BufferedIdController.class));
        Assert.assertThat((Object)idGeneratorFactory, (Matcher)Matchers.instanceOf(BufferingIdGeneratorFactory.class));
    }

    @Test
    public void fileWatcherFileNameFilter() {
        Predicate filter = HighlyAvailableEditionModule.fileWatcherFileNameFilter();
        Assert.assertFalse((boolean)filter.test("neostore"));
        Assert.assertFalse((boolean)filter.test(StoreFile.NODE_STORE.fileName(StoreFileType.STORE)));
        Assert.assertTrue((boolean)filter.test("neostore.transaction.db.1"));
        Assert.assertTrue((boolean)filter.test("index.db.any"));
        Assert.assertTrue((boolean)filter.test("branched"));
        Assert.assertTrue((boolean)filter.test("temp-copy"));
        Assert.assertTrue((boolean)filter.test("neostore.cacheprof"));
    }
}

