/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.test.rule.TestDirectory;

public abstract class ManagedResource<R>
implements TestRule {
    private R resource;

    public final R getResource() {
        R result = this.resource;
        if (result == null) {
            throw new IllegalStateException("Resource is not started.");
        }
        return result;
    }

    protected abstract R createResource(TestDirectory var1);

    protected abstract void disposeResource(R var1);

    public final Statement apply(final Statement base, Description description) {
        final TestDirectory dir = TestDirectory.testDirectory((Class)description.getTestClass());
        return dir.apply(new Statement(){

            public void evaluate() throws Throwable {
                ManagedResource.this.resource = ManagedResource.this.createResource(dir);
                try {
                    base.evaluate();
                }
                finally {
                    Object waste = ManagedResource.this.resource;
                    ManagedResource.this.resource = null;
                    ManagedResource.this.disposeResource(waste);
                }
            }
        }, description);
    }
}

