/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha.upgrade;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.com.RequestContext;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.Server;
import org.neo4j.com.StoreIdTestFactory;
import org.neo4j.com.TransactionStreamResponse;
import org.neo4j.com.TxChecksumVerifier;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.com.storecopy.TransactionCommittingResponseUnpacker;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.MasterClient320;
import org.neo4j.kernel.ha.com.master.ConversationManager;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.master.MasterImpl;
import org.neo4j.kernel.ha.com.master.MasterImplTest;
import org.neo4j.kernel.ha.com.master.MasterServer;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.Commands;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class MasterClientTest {
    private static final String MASTER_SERVER_HOST = "localhost";
    private static final int MASTER_SERVER_PORT = 9191;
    private static final int CHUNK_SIZE = 1024;
    private static final int TIMEOUT = 2000;
    private static final int TX_LOG_COUNT = 10;
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();
    @Rule
    public final LifeRule life = new LifeRule(true);
    private final Monitors monitors = new Monitors();
    private final LogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader = new VersionAwareLogEntryReader();

    @Test(expected=MismatchingStoreIdException.class)
    public void newClientsShouldNotIgnoreStoreIdDifferences() throws Throwable {
        MasterImpl.SPI masterImplSPI = MasterImplTest.mockedSpi(StoreIdTestFactory.newStoreIdForCurrentVersion((long)1L, (long)2L, (long)3L, (long)4L));
        Mockito.when((Object)masterImplSPI.getTransactionChecksum(ArgumentMatchers.anyLong())).thenReturn((Object)5L);
        this.newMasterServer(masterImplSPI);
        StoreId storeId = StoreIdTestFactory.newStoreIdForCurrentVersion((long)5L, (long)6L, (long)7L, (long)8L);
        MasterClient masterClient = this.newMasterClient320(storeId);
        masterClient.handshake(1L, storeId);
    }

    @Test
    public void clientShouldReadAndApplyTransactionLogsOnNewLockSessionRequest() throws Throwable {
        MasterImpl master = (MasterImpl)Mockito.spy((Object)MasterClientTest.newMasterImpl(MasterClientTest.mockMasterImplSpiWith(StoreId.DEFAULT)));
        ((MasterImpl)Mockito.doReturn(MasterClientTest.voidResponseWithTransactionLogs()).when((Object)master)).newLockSession((RequestContext)ArgumentMatchers.any(RequestContext.class));
        this.newMasterServer(master);
        TransactionCommittingResponseUnpacker.Dependencies deps = (TransactionCommittingResponseUnpacker.Dependencies)Mockito.mock(TransactionCommittingResponseUnpacker.Dependencies.class);
        TransactionCommitProcess commitProcess = (TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class);
        Mockito.when((Object)deps.commitProcess()).thenReturn((Object)commitProcess);
        Mockito.when((Object)deps.logService()).thenReturn((Object)NullLogService.getInstance());
        Mockito.when((Object)deps.versionContextSupplier()).thenReturn((Object)EmptyVersionContextSupplier.EMPTY);
        Mockito.when((Object)deps.kernelTransactions()).thenReturn(Mockito.mock(KernelTransactions.class));
        ResponseUnpacker unpacker = (ResponseUnpacker)this.life.add((Lifecycle)new TransactionCommittingResponseUnpacker(deps, 100, 0L));
        MasterClient masterClient = this.newMasterClient320(StoreId.DEFAULT, unpacker);
        masterClient.newLockSession(new RequestContext(1L, 2, 3, 4L, 5L));
        ((TransactionCommitProcess)Mockito.verify((Object)commitProcess)).commit((TransactionToApply)ArgumentMatchers.any(TransactionToApply.class), (CommitEvent)ArgumentMatchers.any(CommitEvent.class), (TransactionApplicationMode)ArgumentMatchers.any(TransactionApplicationMode.class));
    }

    @Test
    public void endLockSessionDoesNotUnpackResponse() throws Throwable {
        HandshakeResult handshakeResult;
        StoreId storeId = new StoreId(1L, 2L, 3L, 4L, 5L);
        long txChecksum = 123L;
        long lastAppliedTx = 5L;
        ResponseUnpacker responseUnpacker = (ResponseUnpacker)Mockito.mock(ResponseUnpacker.class);
        MasterImpl.SPI masterImplSPI = MasterImplTest.mockedSpi(storeId);
        Mockito.when((Object)masterImplSPI.packTransactionObligationResponse((RequestContext)ArgumentMatchers.any(RequestContext.class), ArgumentMatchers.any())).thenReturn((Object)Response.empty());
        Mockito.when((Object)masterImplSPI.getTransactionChecksum(ArgumentMatchers.anyLong())).thenReturn((Object)txChecksum);
        this.newMasterServer(masterImplSPI);
        MasterClient client = this.newMasterClient320(storeId, responseUnpacker);
        try (Response handshakeResponse = client.handshake(1L, storeId);){
            handshakeResult = (HandshakeResult)handshakeResponse.response();
        }
        ((ResponseUnpacker)Mockito.verify((Object)responseUnpacker)).unpackResponse((Response)ArgumentMatchers.any(Response.class), (ResponseUnpacker.TxHandler)ArgumentMatchers.any(ResponseUnpacker.TxHandler.class));
        Mockito.reset((Object[])new ResponseUnpacker[]{responseUnpacker});
        RequestContext context = new RequestContext(handshakeResult.epoch(), 1, 1, lastAppliedTx, txChecksum);
        client.endLockSession(context, false);
        ((ResponseUnpacker)Mockito.verify((Object)responseUnpacker, (VerificationMode)Mockito.never())).unpackResponse((Response)ArgumentMatchers.any(Response.class), (ResponseUnpacker.TxHandler)ArgumentMatchers.any(ResponseUnpacker.TxHandler.class));
    }

    private static MasterImpl.SPI mockMasterImplSpiWith(StoreId storeId) {
        return (MasterImpl.SPI)Mockito.when((Object)((MasterImpl.SPI)Mockito.mock(MasterImpl.SPI.class)).storeId()).thenReturn((Object)storeId).getMock();
    }

    private MasterServer newMasterServer(MasterImpl.SPI masterImplSPI) {
        MasterImpl masterImpl = new MasterImpl(masterImplSPI, (ConversationManager)Mockito.mock(ConversationManager.class), (MasterImpl.Monitor)Mockito.mock(MasterImpl.Monitor.class), MasterClientTest.masterConfig());
        return this.newMasterServer(masterImpl);
    }

    private static MasterImpl newMasterImpl(MasterImpl.SPI masterImplSPI) {
        return new MasterImpl(masterImplSPI, (ConversationManager)Mockito.mock(ConversationManager.class), (MasterImpl.Monitor)Mockito.mock(MasterImpl.Monitor.class), MasterClientTest.masterConfig());
    }

    private MasterServer newMasterServer(MasterImpl masterImpl) {
        return (MasterServer)this.life.add((Lifecycle)new MasterServer((Master)masterImpl, (LogProvider)NullLogProvider.getInstance(), MasterClientTest.masterServerConfiguration(), (TxChecksumVerifier)Mockito.mock(TxChecksumVerifier.class), (ByteCounterMonitor)this.monitors.newMonitor(ByteCounterMonitor.class, MasterClient.class, new String[0]), (RequestMonitor)this.monitors.newMonitor(RequestMonitor.class, MasterClient.class, new String[0]), (ConversationManager)Mockito.mock(ConversationManager.class), this.logEntryReader));
    }

    private MasterClient newMasterClient320(StoreId storeId) {
        return this.newMasterClient320(storeId, ResponseUnpacker.NO_OP_RESPONSE_UNPACKER);
    }

    private MasterClient newMasterClient320(StoreId storeId, ResponseUnpacker responseUnpacker) {
        return (MasterClient)this.life.add((Lifecycle)new MasterClient320(MASTER_SERVER_HOST, 9191, null, (LogProvider)NullLogProvider.getInstance(), storeId, 2000L, 2000L, 1, 1024, responseUnpacker, (ByteCounterMonitor)this.monitors.newMonitor(ByteCounterMonitor.class, MasterClient320.class, new String[0]), (RequestMonitor)this.monitors.newMonitor(RequestMonitor.class, MasterClient320.class, new String[0]), this.logEntryReader));
    }

    private static Response<Void> voidResponseWithTransactionLogs() {
        return new TransactionStreamResponse(null, StoreId.DEFAULT, visitor -> {
            for (int i = 1; i <= 10; ++i) {
                visitor.visit((Object)MasterClientTest.committedTransactionRepresentation(i));
            }
        }, ResourceReleaser.NO_OP);
    }

    private static CommittedTransactionRepresentation committedTransactionRepresentation(int id) {
        return new CommittedTransactionRepresentation(new LogEntryStart(id, id, (long)id, (long)(id - 1), new byte[0], LogPosition.UNSPECIFIED), Commands.transactionRepresentation((Command[])new Command[]{Commands.createNode((long)0L, (long[])new long[0])}), new LogEntryCommit((long)id, (long)id));
    }

    private static Config masterConfig() {
        return Config.defaults((Setting)ClusterSettings.server_id, (String)"1");
    }

    private static Server.Configuration masterServerConfiguration() {
        return new Server.Configuration(){

            public long getOldChannelThreshold() {
                return -1L;
            }

            public int getMaxConcurrentTransactions() {
                return 1;
            }

            public int getChunkSize() {
                return 1024;
            }

            public HostnamePort getServerAddress() {
                return new HostnamePort(MasterClientTest.MASTER_SERVER_HOST, 9191);
            }
        };
    }
}

